/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.support.v4.content.FileProvider;
import android.webkit.MimeTypeMap;
import android.widget.Toast;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class FileUtils {
    public static String[] fileTypes = new String[]{"apk", "avi", "bmp", "chm", "dll", "doc", "docx", "dos", "gif", "html", "jpeg", "jpg", "movie", "mp3", "dat", "mp4", "mpe", "mpeg", "mpg", "pdf", "png", "ppt", "pptx", "rar", "txt", "wav", "wma", "wmv", "xls", "xlsx", "xml", "zip"};
    private static final String TAG = "FileUtils";

    public static File[] loadFiles(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                arrayList.add(file2);
                continue;
            }
            if (!file2.isFile()) continue;
            arrayList2.add(file2);
        }
        MyComparator myComparator = new MyComparator();
        Collections.sort(arrayList, myComparator);
        Collections.sort(arrayList2, myComparator);
        File[] fileArray2 = new File[arrayList.size() + arrayList2.size()];
        System.arraycopy(arrayList.toArray(new File[arrayList.size()]), 0, fileArray2, 0, arrayList.size());
        System.arraycopy(arrayList2.toArray(new File[arrayList2.size()]), 0, fileArray2, arrayList.size(), arrayList2.size());
        return fileArray2;
    }

    public static String getMIMEType(File file) {
        String string = "";
        String string2 = file.getName();
        String string3 = string2.substring(string2.lastIndexOf(".") + 1, string2.length()).toLowerCase();
        string = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string3);
        return string;
    }

    public static String getMIMEType(String string) {
        String string2 = "";
        String string3 = string.substring(string.lastIndexOf(".") + 1, string.length()).toLowerCase();
        string2 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string3);
        return string2;
    }

    @Deprecated
    public static void openFile(File file, Activity activity) {
        String string = FileUtils.getMIMEType(file);
        Uri uri = FileUtils.getUriForFile((Context)activity, file);
        FileUtils.openFile(uri, string, activity);
    }

    @Deprecated
    public static void openFile(Uri uri, String string, Activity activity) {
        Intent intent = new Intent();
        intent.addFlags(0x10000000);
        intent.addFlags(3);
        intent.setAction("android.intent.action.VIEW");
        intent.setDataAndType(uri, string);
        try {
            activity.startActivity(intent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Toast.makeText((Context)activity, (CharSequence)"Can't find proper app to open this file", (int)1).show();
        }
    }

    public static Uri getUriForFile(Context context, File file) {
        if (Build.VERSION.SDK_INT >= 24) {
            return FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".fileProvider"), (File)file);
        }
        return Uri.fromFile((File)file);
    }

    public static class MyComparator
    implements Comparator<File> {
        @Override
        public int compare(File file, File file2) {
            return file.getName().compareTo(file2.getName());
        }
    }
}

