/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.content.Context;
import android.content.SharedPreferences;
import com.hyphenate.util.EMLog;
import java.util.Map;
import java.util.UUID;

public class DeviceUuidFactory {
    protected static final String PREFS_FILE = "device_id.xml";
    protected static final String PREFS_DEVICE_ID = "device_id";
    protected static UUID uuid;

    public DeviceUuidFactory(Context context) {
        if (uuid == null) {
            SharedPreferences sharedPreferences = context.getSharedPreferences(PREFS_FILE, 0);
            String string = sharedPreferences.getString(PREFS_DEVICE_ID, null);
            if (string != null) {
                uuid = UUID.fromString(string);
            } else {
                EMLog.e("DeviceUuidFactory", "Need to generate device uuid");
                uuid = this.generateDeviceUuid(context);
                sharedPreferences.edit().putString(PREFS_DEVICE_ID, uuid.toString()).commit();
            }
        }
    }

    private UUID generateDeviceUuid(Context context) {
        return UUID.randomUUID();
    }

    public UUID getDeviceUuid() {
        return uuid;
    }

    private static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String && ((String)object).trim().length() == 0) {
            return true;
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        return false;
    }
}

