package com.hyphenate.push.common;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;

import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.hyphenate.chat.EMClient;
import com.hyphenate.push.EMPushConfig;
import com.hyphenate.push.EMPushType;
import com.hyphenate.util.EMLog;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class PushUtil {
    private static final String TAG = "PushUtil";

    public static boolean isMainProcess(Context context) {
        int pid = android.os.Process.myPid();
        ActivityManager activityManager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        for (ActivityManager.RunningAppProcessInfo appProcess : activityManager.getRunningAppProcesses()) {
            if (appProcess.pid == pid) {
                return context.getApplicationInfo().packageName.equals(appProcess.processName);
            }
        }
        return false;
    }

    public static String getDeviceManufacturer() {
        String line = "";
        BufferedReader input = null;
        String propName = "ro.miui.ui.version.name";

        try {
            Process p = Runtime.getRuntime().exec("getprop " + propName);
            input = new BufferedReader(new InputStreamReader(p.getInputStream()), 1024);
            line = input.readLine();
            input.close();
        } catch (IOException var12) {
            Log.e("DeviceUtils", "Unable to read sysprop " + propName);
        } finally {
            if (input != null) {
                try {
                    input.close();
                } catch (IOException var11) {
                    ;
                }
            }
        }

        if (!TextUtils.isEmpty(line)) {
            return "XIAOMI";
        }

        String manufacturer = Build.MANUFACTURER.replace("-", "_");
        return manufacturer.toUpperCase();
    }

    public static boolean isSupportPush(EMPushType pushType, EMPushConfig pushConfig) {
        String os = PushUtil.getDeviceManufacturer();
        EMLog.e(TAG, "Current device manufacturer: " + os);

        switch (pushType) {
            case FCM:
                return EMClient.getInstance().getOptions().isUseFCM()
                        && isGooglePlayServicesAvailable(EMClient.getInstance().getContext());
            case MIPUSH:
                return os.contains("XIAOMI");
            case OPPOPUSH:
                return os.contains("OPPO");
            case VIVOPUSH:
                return os.contains("VIVO");
            case MEIZUPUSH:
                return os.contains("MEIZU");
            case HMSPUSH:
                return os.contains("HUAWEI")||os.contains("HONOR");
        }
        return false;
    }

    public static boolean isGooglePlayServicesAvailable(Context context) {
        try {
            if (Class.forName("com.google.android.gms.common.GoogleApiAvailability") != null) {
                int resultCode = GoogleApiAvailability.getInstance().
                        isGooglePlayServicesAvailable(context);
                if (resultCode == ConnectionResult.SUCCESS) {
                    return true;
                }
            }
        } catch (ClassNotFoundException e) {
            EMLog.e(TAG, "" + e.toString());
        }
        return false;
    }
}
