/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package com.hyphenate.chat;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;

import com.hyphenate.chat.adapter.message.EMAMessageBody;
import com.hyphenate.chat.adapter.message.EMAVoiceMessageBody;
import com.hyphenate.util.EMFileHelper;
import com.hyphenate.util.EMLog;

import java.io.File;

/**
 * \~chinese
 * 语音消息体
 *
 * EMVoiceMessageBody body = new EMVoiceMessageBody(voiceFile, length);
 *
 * \~english
 * the voice message body class
 *
 * EMVoiceMessageBody body = new EMVoiceMessageBody(voiceFile, length);
 */
public class EMVoiceMessageBody extends EMFileMessageBody implements Parcelable {

	/**
	 * \~chinese
     * 创建一个语音消息体
     *
     * @param voiceFile 语音文件路径
     * @param duration, 语音事件长度，单位秒
     *
     * \~english
     * create a voice message body
     *
     * @param voiceFile voice file
     * @param duration voice clip length, in seconds
     */
    public EMVoiceMessageBody(File voiceFile, int duration) {
        //mimeType = MimeType.VOICE;
    	this(Uri.fromFile(voiceFile), duration);
    }

	/**
	 * \~chinese
     * 创建一个语音消息体
     *
     * @param voiceFile 语音文件uri
     * @param duration, 语音事件长度，单位秒
     *
     * \~english
     * create a voice message body
     *
     * @param voiceFile voice uri
     * @param duration voice clip length, in seconds
     *
     */
    public EMVoiceMessageBody(Uri voiceFile, int duration) {
        //mimeType = MimeType.VOICE;
    	super(voiceFile, EMAMessageBody.EMAMessageBodyType_VOICE);
    	((EMAVoiceMessageBody)emaObject).setDuration(duration);
    	((EMAVoiceMessageBody)emaObject).setDisplayName(EMFileHelper.getInstance().getFilename(voiceFile));
        EMLog.d("voicemsg", "create voice, message body for:" + voiceFile);
    }

    public EMVoiceMessageBody(EMAVoiceMessageBody body) {
    	super(body);
	}

    /**
     * create voice message body from incoming xmpp message json
     */
    EMVoiceMessageBody(String fileName, String remoteUrl, int length) {
    	super(fileName, EMAMessageBody.EMAMessageBodyType_VOICE);
        ((EMAVoiceMessageBody)emaObject).setLocalPath(fileName);
        ((EMAVoiceMessageBody)emaObject).setRemotePath(remoteUrl);
        ((EMAVoiceMessageBody)emaObject).setDuration(length);
    }
    
    /**
     * \~chinese
     * 获得语音文件的长度 （单位是秒）
     *
     * @return
     * 
     * \~english
     * get the length of the voice time, unit s
     *
     * @return
     */
    public int getLength() {
        return ((EMAVoiceMessageBody)emaObject).duration();
    }

    /**
     * \~chinese
     * 获取文件大小
     * @return
     *
     * \~english
     * get the video file size
     * @return
     */
    public long getFileSize() {
        return ((EMAVoiceMessageBody)emaObject).fileLength();
    }
    
    public String toString() {
        return "voice:" + ((EMAVoiceMessageBody)emaObject).displayName() + ",localurl:" + ((EMAVoiceMessageBody)emaObject).getLocalUrl() + ""
                + ",remoteurl:" + ((EMAVoiceMessageBody)emaObject).getRemoteUrl() + ",length:" + ((EMAVoiceMessageBody)emaObject).duration();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        //members from FileMessageBody
        dest.writeString(((EMAVoiceMessageBody)emaObject).displayName());
        dest.writeString(((EMAVoiceMessageBody)emaObject).getLocalUrl());
        dest.writeString(((EMAVoiceMessageBody)emaObject).getRemoteUrl());
        dest.writeInt(((EMAVoiceMessageBody)emaObject).duration());
    }
    
    public static final Parcelable.Creator<EMVoiceMessageBody> CREATOR
            = new Parcelable.Creator<EMVoiceMessageBody>() {
        public EMVoiceMessageBody createFromParcel(Parcel in) {
            return new EMVoiceMessageBody(in);
        }

        public EMVoiceMessageBody[] newArray(int size) {
            return new EMVoiceMessageBody[size];
        }
    };

    private EMVoiceMessageBody(Parcel in) {
        //members from FileMessageBody
    	super("", EMAMessageBody.EMAMessageBodyType_VOICE);
    	((EMAVoiceMessageBody)emaObject).setDisplayName(in.readString());
    	((EMAVoiceMessageBody)emaObject).setLocalPath(in.readString());
    	((EMAVoiceMessageBody)emaObject).setRemotePath(in.readString());
    	((EMAVoiceMessageBody)emaObject).setDuration(in.readInt());
    }
}
