package com.hyphenate.chat;


/**
 * Created by lijian on 2021/03/17
 *
 * \~chinese
 * 用户属性实体类，有关用户的信息,如下属性：
 * nickName：昵称
 * avatarUrl：头像url
 * email： 邮箱
 * phoneNumber：电话
 * gender：性别(默认为0 ,1表示男,2表示女,其他为非法)
 * signature: 签名
 * birthday： 生日
 * userId:  环信ID
 * ext：扩展字段(用户可自行扩展，建议封装成JSON字符串，也可以设置为空字符串)
 *
 * \~english
 * User attribute entity class, information about the user,
 * the following attributes:
 * nickName; avatarUrl; email; phoneNumber; isMale;
 * signature; birthday; userId;ext;
 *
 */
public class EMUserInfo {
    private String nickName;
    private String avatarUrl;
    private String email;
    private String phoneNumber;
    private int gender = 0;
    private String signature;
    private String birth;
    private String userId;
    private String ext;


    public EMUserInfo(){
    }


    /**
     * 有关用户属性 属性值字段定义如下：
     * NICKNAME 昵称
     * AVATAR_URL  头像
     * EMAIL  邮箱
     * PHONE 电话
     * GENDER  性别
     * SIGN  签名
     * BIRTH 生日
     * EXT  扩展字段
     */
    public enum EMUserInfoType {
        NICKNAME(0,"nickname"),
        AVATAR_URL(1,"avatarurl"),
        EMAIL(2,"mail"),
        PHONE(3,"phone"),
        GENDER(4,"gender"),
        SIGN(5,"sign"),
        BIRTH(6,"birth"),
        EXT(100,"ext");

        private int value;
        private String desc;

        public int getValue() {
            return value;
        }
        public void setValue(int value) {
            this.value = value;
        }
        public String getDesc() {
            return desc;
        }
        public void setDesc(String desc) {
            this.desc = desc;
        }
        private EMUserInfoType(int value, String desc) {
            this.value = value;
            this.desc = desc;
        }
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getAvatarUrl() {
        return avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public int getGender() {
        return gender;
    }

    public void setGender(int gender) {
        this.gender = gender;
    }

    public String getSignature() {
        return signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getBirth() {
        return birth;
    }

    public void setBirth(String birth) {
        this.birth = birth;
    }

    public String getUserId() { return userId; }

    public void setUserId(String userId) { this.userId = userId;}

    public String getExt() {
        return ext;
    }

    public void setExt(String ext) {
        this.ext = ext;
    }
}
