/************************************************************
 *  * EaseMob CONFIDENTIAL 
 * __________________ 
 * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
 *  
 * NOTICE: All information contained herein is, and remains 
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material 
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import android.net.Uri;
import android.text.TextUtils;

import com.hyphenate.chat.adapter.message.EMAFileMessageBody;
import com.hyphenate.chat.adapter.message.EMAFileMessageBody.EMADownloadStatus;
import com.hyphenate.chat.adapter.message.EMAImageMessageBody;
import com.hyphenate.chat.adapter.message.EMAMessageBody;
import com.hyphenate.chat.adapter.message.EMAVideoMessageBody;
import com.hyphenate.chat.adapter.message.EMAVoiceMessageBody;
import com.hyphenate.util.EMFileHelper;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.VersionUtils;

import java.io.File;

import static com.hyphenate.chat.EMClient.TAG;

/**
 * \~chinese
 * 文件类消息的基类
 * 
 * \~english
 * the base class of file type message
 */
public abstract class EMFileMessageBody extends EMMessageBody {
    
    public enum EMDownloadStatus {
        DOWNLOADING,
        SUCCESSED,
        FAILED,
        PENDING
    }

	/**
	 * @param localPath
	 */
	public EMFileMessageBody(String localPath) {
    	this(EMFileHelper.getInstance().formatInUri(localPath));
	}

	public EMFileMessageBody(Uri localPath) {
		this(localPath, EMAMessageBody.EMAMessageBodyType_FILE);
	}

	/**
	 * @param localPath
	 * @param type
	 */
	EMFileMessageBody(String localPath, int type) {
    	this(Uri.fromFile(new File(localPath)), type);
	}

	EMFileMessageBody(Uri localPath, int type) {
		switch (type) {
		case EMAMessageBody.EMAMessageBodyType_FILE:
			emaObject = new EMAFileMessageBody(localPath, type);
			setFileLength(EMFileHelper.getInstance().getFileLength(localPath));
			break;
		case EMAMessageBody.EMAMessageBodyType_IMAGE:
			emaObject = new EMAImageMessageBody(localPath, null);
			setFileLength(EMFileHelper.getInstance().getFileLength(localPath));
			break;
		case EMAMessageBody.EMAMessageBodyType_VIDEO:
			emaObject = new EMAVideoMessageBody(localPath, null);
			setFileLength(EMFileHelper.getInstance().getFileLength(localPath));
			break;
		case EMAMessageBody.EMAMessageBodyType_VOICE:
		    emaObject = new EMAVoiceMessageBody(localPath, 0);
			setFileLength(EMFileHelper.getInstance().getFileLength(localPath));
		    break;
		default:
			break;
		}
	}

	public EMFileMessageBody(EMAFileMessageBody body) {
		emaObject = body;
	}
	

	/**
	 * \~chinese
	 * 获得文件名
	 * 
	 * @return
	 * 
	 * \~english
	 * get file name
	 * @return
	 */
	public String getFileName() {
		return ((EMAFileMessageBody)emaObject).displayName();
	}

	public void setFileName(String fileName) {
		((EMAFileMessageBody)emaObject).setDisplayName(fileName);
	}

	/**
	 * \~chinese
	 * 本地图片，语音等文件的路径或者Uri的String样式
	 * 
	 * @return
	 *
	 * \~english
	 * local file path or the String style of Uri
	 *
	 * @return
	 */
	public String getLocalUrl() {
		return EMFileHelper.getInstance().formatOutLocalUrl(((EMAFileMessageBody)emaObject).getLocalUrl());
	}

	/**
	 * @param localUrl
	 */
	public void setLocalUrl(String localUrl) {
		((EMAFileMessageBody)emaObject).setLocalPath(EMFileHelper.getInstance().formatInUriToString(localUrl));
	}

	/**
	 * \~chinese
	 * 本地图片，语音等文件的路径
	 *
	 * @return
	 *
	 * \~english
	 * local file path
	 */
	public Uri getLocalUri() {
		return EMFileHelper.getInstance().formatOutUri(((EMAFileMessageBody)emaObject).getLocalUrl());
	}

	public void setLocalUrl(Uri localUrl) {
		((EMAFileMessageBody)emaObject).setLocalPath(EMFileHelper.getInstance().formatInUriToString(localUrl));
	}

	/**
	 * \~chinese
	 * 远程图片，声音等的url
	 * 
	 * @return
	 * 
	 * \~english
	 * get file remote url
	 * @return
	 */
	public String getRemoteUrl() {
		return ((EMAFileMessageBody)emaObject).getRemoteUrl();
	}

	public void setRemoteUrl(String remoteUrl) {
		((EMAFileMessageBody)emaObject).setRemotePath(remoteUrl);
	}

	public void setSecret(String secret) {
		((EMAFileMessageBody)emaObject).setSecretKey(secret);
	}

	public String getSecret() {
		return ((EMAFileMessageBody)emaObject).getSecret();
	}
	
	public String displayName() {
		return ((EMAFileMessageBody)emaObject).displayName();
	}
	
	public void setFileLength(long length) {
		((EMAFileMessageBody)emaObject).setFileLength(length);
	}
	
	public EMDownloadStatus downloadStatus() {
	    EMADownloadStatus _status = ((EMAFileMessageBody)emaObject).downloadStatus();
	    switch (_status) {
	    case DOWNLOADING:
	        return EMDownloadStatus.DOWNLOADING;
	    case SUCCESSED:
	        return EMDownloadStatus.SUCCESSED;
	    case FAILED:
	        return EMDownloadStatus.FAILED;
	    case PENDING:
	        return EMDownloadStatus.PENDING;
	    }
	    return EMDownloadStatus.SUCCESSED;
	}
	
	public void setDownloadStatus(EMDownloadStatus status) {
		((EMAFileMessageBody)emaObject).setDownloadStatus(EMADownloadStatus.valueOf(status.name()));
	}

}
