/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.widget.chatrow;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMImageMessageBody;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.utils.EaseImageUtils;
import com.hyphenate.easeui.widget.chatrow.EaseChatRowFile;

public class EaseChatRowImage
extends EaseChatRowFile {
    protected ImageView imageView;
    private EMImageMessageBody imgBody;

    public EaseChatRowImage(Context context, boolean isSender) {
        super(context, isSender);
    }

    public EaseChatRowImage(Context context, EMMessage message, int position, Object adapter) {
        super(context, message, position, adapter);
    }

    @Override
    protected void onInflateView() {
        this.inflater.inflate(!this.showSenderType ? R.layout.ease_row_received_picture : R.layout.ease_row_sent_picture, (ViewGroup)this);
    }

    @Override
    protected void onFindViewById() {
        this.percentageView = (TextView)this.findViewById(R.id.percentage);
        this.imageView = (ImageView)this.findViewById(R.id.image);
    }

    @Override
    protected void onSetUpView() {
        if (this.bubbleLayout != null) {
            this.bubbleLayout.setBackground(null);
        }
        this.imgBody = (EMImageMessageBody)this.message.getBody();
        if (this.message.direct() == EMMessage.Direct.RECEIVE) {
            ViewGroup.LayoutParams params = EaseImageUtils.getImageShowSize(this.context, this.message);
            ViewGroup.LayoutParams layoutParams = this.imageView.getLayoutParams();
            layoutParams.width = params.width;
            layoutParams.height = params.height;
            return;
        }
        this.showImageView(this.message);
    }

    @Override
    protected void onViewUpdate(EMMessage msg) {
        super.onViewUpdate(msg);
    }

    @Override
    protected void onMessageSuccess() {
        super.onMessageSuccess();
        this.showImageView(this.message);
    }

    @Override
    protected void onMessageInProgress() {
        if (this.message.direct() == EMMessage.Direct.SEND) {
            super.onMessageInProgress();
        } else if (!EMClient.getInstance().getOptions().getAutodownloadThumbnail()) {
            if (this.progressBar != null) {
                this.progressBar.setVisibility(4);
            }
            if (this.percentageView != null) {
                this.percentageView.setVisibility(4);
            }
        }
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private void showImageView(EMMessage message) {
        EaseImageUtils.showImage(this.context, this.imageView, message);
    }
}

