/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.net.Uri;
import android.os.Build;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMFileMessageBody;
import com.hyphenate.chat.EMImageMessageBody;
import com.hyphenate.chat.EMLocationMessageBody;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMVideoMessageBody;
import com.hyphenate.chat.EMVoiceMessageBody;
import com.hyphenate.easeui.EaseIM;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.domain.EaseEmojicon;
import com.hyphenate.easeui.domain.EaseUser;
import com.hyphenate.easeui.interfaces.IUIKitInterface;
import com.hyphenate.easeui.manager.EaseChatInterfaceManager;
import com.hyphenate.easeui.utils.EaseCommonUtils;
import com.hyphenate.easeui.utils.EaseEditTextUtils;
import com.hyphenate.easeui.utils.EaseFileUtils;
import com.hyphenate.easeui.utils.EaseSmileUtils;
import com.hyphenate.easeui.utils.EaseUserUtils;
import com.hyphenate.easeui.widget.CenterImageSpan;
import com.hyphenate.easeui.widget.EaseImageView;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.EMLog;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class EaseChatQuoteView
extends LinearLayout {
    private static final String TAG = EaseChatQuoteView.class.getSimpleName();
    private static final float IMAGE_DEFAULT_WIDTH = 36.0f;
    private final Context mContext;
    private TextView quoteContent;
    private ImageView quoteVoiceIcon;
    private TextView quoteVoiceName;
    private TextView quoteVoiceLength;
    private TextView quoteVideoName;
    private EaseImageView quoteVideoIcon;
    private TextView quoteFileTitle;
    private TextView quoteFileName;
    private ImageView quoteFileIcon;
    private TextView quoteImageName;
    private EaseImageView quoteImageView;
    private TextView quoteLocationAddress;
    private TextView quoteBigExpressionTitle;
    private TextView quoteDefaultView;
    private EaseImageView quoteBigExpressionImg;
    private ViewGroup quoteTextLayout;
    private ViewGroup quoteVoiceLayout;
    private ViewGroup quoteVideoLayout;
    private ViewGroup quoteFileLayout;
    private ViewGroup quoteLocationLayout;
    private ViewGroup quoteImageLayout;
    private ViewGroup quoteBigExpressionLayout;
    private ViewGroup quoteDefaultLayout;
    private EMMessage message;
    private EMMessage quoteMessage;
    private final Map<String, String> receiveMsgTypes = new HashMap<String, String>();

    public EaseChatQuoteView(Context context) {
        this(context, null);
    }

    public EaseChatQuoteView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EaseChatQuoteView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.initMsgType();
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ease_quote_style);
        boolean isSender = typedArray.getBoolean(R.styleable.ease_quote_style_ease_chat_item_sender, false);
        typedArray.recycle();
        if (isSender) {
            LayoutInflater.from((Context)context).inflate(R.layout.ease_row_sent_quote_layout, (ViewGroup)this);
        } else {
            LayoutInflater.from((Context)context).inflate(R.layout.ease_row_received_quote_layout, (ViewGroup)this);
        }
        this.quoteContent = (TextView)this.findViewById(R.id.tv_subContent);
        this.quoteVoiceName = (TextView)this.findViewById(R.id.iv_voice_name);
        this.quoteVoiceLength = (TextView)this.findViewById(R.id.tv_voice_length);
        this.quoteVoiceIcon = (ImageView)this.findViewById(R.id.iv_voice);
        this.quoteVideoName = (TextView)this.findViewById(R.id.tv_video_subContent);
        this.quoteVideoIcon = (EaseImageView)this.findViewById(R.id.chatting_content_iv);
        this.quoteFileTitle = (TextView)this.findViewById(R.id.iv_file_title);
        this.quoteFileName = (TextView)this.findViewById(R.id.tv_file_name);
        this.quoteFileIcon = (ImageView)this.findViewById(R.id.iv_file);
        this.quoteImageName = (TextView)this.findViewById(R.id.tv_image_subContent);
        this.quoteImageView = (EaseImageView)this.findViewById(R.id.iv_quote_picture);
        this.quoteLocationAddress = (TextView)this.findViewById(R.id.tv_location_address);
        this.quoteBigExpressionTitle = (TextView)this.findViewById(R.id.tv_bigExpression_subContent);
        this.quoteBigExpressionImg = (EaseImageView)this.findViewById(R.id.iv_bigExpression_picture);
        this.quoteDefaultView = (TextView)this.findViewById(R.id.tv_default);
        this.quoteTextLayout = (ViewGroup)this.findViewById(R.id.subBubble_text_layout);
        this.quoteVoiceLayout = (ViewGroup)this.findViewById(R.id.subBubble_audio_layout);
        this.quoteVideoLayout = (ViewGroup)this.findViewById(R.id.subBubble_video_layout);
        this.quoteFileLayout = (ViewGroup)this.findViewById(R.id.subBubble_file_layout);
        this.quoteImageLayout = (ViewGroup)this.findViewById(R.id.subBubble_image_layout);
        this.quoteLocationLayout = (ViewGroup)this.findViewById(R.id.subBubble_location_layout);
        this.quoteBigExpressionLayout = (ViewGroup)this.findViewById(R.id.subBubble_bigExpression_layout);
        this.quoteDefaultLayout = (ViewGroup)this.findViewById(R.id.subBubble_default_layout);
        this.setTextBreakStrategy(this.quoteContent);
        this.setTextBreakStrategy(this.quoteVoiceName);
        this.setTextBreakStrategy(this.quoteVideoName);
        this.setTextBreakStrategy(this.quoteFileTitle);
        this.setTextBreakStrategy(this.quoteImageName);
        this.setTextBreakStrategy(this.quoteLocationAddress);
        this.setTextBreakStrategy(this.quoteBigExpressionTitle);
        this.setTextBreakStrategy(this.quoteDefaultView);
    }

    private void setTextBreakStrategy(TextView textView) {
        if (Build.VERSION.SDK_INT >= 23) {
            textView.setBreakStrategy(2);
        }
    }

    public void updateMessageInfo(EMMessage quoteMsg) {
        if (quoteMsg == null) {
            EMLog.e((String)TAG, (String)this.getContext().getString(R.string.ease_error_message_not_exist));
            return;
        }
        if (quoteMsg.ext() != null && !quoteMsg.ext().containsKey("msgQuote")) {
            return;
        }
        this.message = quoteMsg;
        JSONObject jsonObject = null;
        try {
            String msgQuote = this.message.getStringAttribute("msgQuote", "");
            if (!TextUtils.isEmpty((CharSequence)msgQuote)) {
                try {
                    jsonObject = new JSONObject(msgQuote);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else {
                jsonObject = this.message.getJSONObjectAttribute("msgQuote");
            }
            if (jsonObject != null) {
                this.setContent(jsonObject);
                this.setVisibility(0);
            } else {
                this.setVisibility(8);
            }
        }
        catch (HyphenateException e) {
            e.printStackTrace();
        }
    }

    private void setContent(JSONObject jsonObject) {
        try {
            String quoteMsgID = jsonObject.getString("msgID");
            String quoteSender = jsonObject.getString("msgSender");
            String quoteType = jsonObject.getString("msgType");
            String quoteContent = jsonObject.getString("msgPreview");
            String quoteSenderNick = "";
            if (!TextUtils.isEmpty((CharSequence)quoteSender)) {
                EaseUser user = EaseUserUtils.getUserInfo(quoteSender);
                quoteSenderNick = user == null ? quoteSender : (TextUtils.isEmpty((CharSequence)user.getNickname()) ? user.getUsername() : user.getNickname());
            }
            this.quoteMessage = EMClient.getInstance().chatManager().getMessage(quoteMsgID);
            this.isShowType(quoteSenderNick, this.getQuoteMessageType(quoteType), quoteContent);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void initMsgType() {
        this.receiveMsgTypes.put("text", EMMessage.Type.TXT.name());
        this.receiveMsgTypes.put("img", EMMessage.Type.IMAGE.name());
        this.receiveMsgTypes.put("video", EMMessage.Type.VIDEO.name());
        this.receiveMsgTypes.put("location", EMMessage.Type.LOCATION.name());
        this.receiveMsgTypes.put("audio", EMMessage.Type.VOICE.name());
        this.receiveMsgTypes.put("file", EMMessage.Type.FILE.name());
        this.receiveMsgTypes.put("cmd", EMMessage.Type.CMD.name());
        this.receiveMsgTypes.put("custom", EMMessage.Type.CUSTOM.name());
    }

    private EMMessage.Type getQuoteMessageType(String quoteType) {
        if (this.receiveMsgTypes.get(quoteType) == null) {
            return EMMessage.Type.TXT;
        }
        return EMMessage.Type.valueOf((String)this.receiveMsgTypes.get(quoteType));
    }

    private void reSetLayout() {
        this.quoteTextLayout.setVisibility(8);
        this.quoteVoiceLayout.setVisibility(8);
        this.quoteVideoLayout.setVisibility(8);
        this.quoteFileLayout.setVisibility(8);
        this.quoteImageLayout.setVisibility(8);
        this.quoteLocationLayout.setVisibility(8);
        this.quoteBigExpressionLayout.setVisibility(8);
        this.quoteDefaultLayout.setVisibility(8);
    }

    private void isShowType(String quoteSender, EMMessage.Type quoteMsgType, String content) {
        this.reSetLayout();
        switch (quoteMsgType) {
            case TXT: {
                this.txtTypeDisplay(this.quoteMessage, quoteSender, content);
                break;
            }
            case IMAGE: {
                this.imageTypeDisplay(this.quoteMessage, quoteSender, content);
                break;
            }
            case VIDEO: {
                this.videoTypeDisplay(this.quoteMessage, quoteSender, content);
                break;
            }
            case LOCATION: {
                this.locationTypeDisplay(this.quoteMessage, quoteSender, content);
                break;
            }
            case VOICE: {
                this.voiceTypeDisplay(this.quoteMessage, quoteSender, content);
                break;
            }
            case FILE: {
                this.fileTypeDisplay(this.quoteMessage, quoteSender, content);
                break;
            }
            default: {
                SpannableString result;
                IUIKitInterface listener = EaseChatInterfaceManager.getInstance().getInterface("quote_message_tag");
                if (!(listener instanceof IChatQuoteMessageShow) || (result = ((IChatQuoteMessageShow)listener).itemQuoteMessageShow(this.quoteMessage, quoteMsgType, quoteSender, content)) == null) break;
                this.reSetLayout();
                this.quoteDefaultView.setText((CharSequence)result);
                this.quoteDefaultLayout.setVisibility(0);
            }
        }
    }

    protected void txtTypeDisplay(EMMessage quoteMessage, String quoteSender, String content) {
        StringBuilder builder = new StringBuilder();
        if (quoteMessage != null && quoteMessage.getBooleanAttribute("em_is_big_expression", false)) {
            this.showBigExpression(quoteMessage);
            builder.append(quoteSender).append(": ");
            SpannableString bigSpan = new SpannableString((CharSequence)builder.toString());
            this.quoteBigExpressionTitle.setText((CharSequence)bigSpan);
            this.quoteBigExpressionLayout.setVisibility(0);
        } else {
            String text = this.getContext().getString(R.string.colon_and_space, new Object[]{quoteSender, content});
            Spannable textSpan = EaseSmileUtils.getSmiledText(this.mContext, text);
            SpannableString spannableString = new SpannableString((CharSequence)textSpan);
            this.quoteContent.setText((CharSequence)spannableString);
            this.quoteContent.setEllipsize(TextUtils.TruncateAt.END);
            this.quoteContent.setMaxLines(2);
            this.quoteTextLayout.setVisibility(0);
        }
    }

    protected void imageTypeDisplay(EMMessage quoteMessage, String quoteSender, String content) {
        StringBuilder builder = new StringBuilder();
        if (quoteMessage == null) {
            builder.append(quoteSender).append(": ");
            this.quoteImageView.setImageResource(R.drawable.ease_default_image);
            ViewGroup.LayoutParams layoutParams = this.quoteImageView.getLayoutParams();
            layoutParams.height = layoutParams.width;
        } else {
            builder.append(quoteSender).append(": ");
            this.showImageView(quoteMessage);
        }
        SpannableString imageSpan = new SpannableString((CharSequence)builder.toString());
        this.quoteImageName.setText((CharSequence)imageSpan);
        this.quoteImageLayout.setVisibility(0);
    }

    protected void videoTypeDisplay(EMMessage quoteMessage, String quoteSender, String content) {
        StringBuilder builder = new StringBuilder();
        if (quoteMessage == null) {
            builder.append(quoteSender).append(": ");
            this.quoteVideoName.setText((CharSequence)builder);
            this.quoteVideoIcon.setImageResource(R.drawable.ease_default_image);
            ViewGroup.LayoutParams layoutParams = this.quoteVideoIcon.getLayoutParams();
            layoutParams.height = layoutParams.width;
        } else {
            builder.append(quoteSender).append(": ");
            SpannableString videoSpan = new SpannableString((CharSequence)builder.toString());
            this.quoteVideoName.setText((CharSequence)videoSpan);
            this.showVideoThumbView(quoteMessage);
        }
        this.quoteVideoLayout.setVisibility(0);
    }

    protected void locationTypeDisplay(EMMessage quoteMessage, String quoteSender, String content) {
        String title = "";
        int startIndex = quoteSender.length() + 1;
        if (quoteMessage == null) {
            title = quoteSender + ": " + content;
        } else if (quoteMessage.getBody() instanceof EMLocationMessageBody) {
            EMLocationMessageBody locationMessageBody = (EMLocationMessageBody)quoteMessage.getBody();
            title = quoteSender + ": " + locationMessageBody.getAddress();
        }
        SpannableStringBuilder locationSb = new SpannableStringBuilder((CharSequence)title);
        CenterImageSpan span = new CenterImageSpan(this.mContext, R.drawable.ease_chat_item_menu_location);
        if (locationSb.length() >= startIndex + 2) {
            locationSb.setSpan((Object)span, startIndex, startIndex + 2, 17);
        }
        this.quoteLocationAddress.setText((CharSequence)locationSb);
        this.quoteLocationLayout.setVisibility(0);
    }

    protected void voiceTypeDisplay(EMMessage quoteMessage, String quoteSender, String content) {
        StringBuilder builder = new StringBuilder();
        if (quoteMessage == null) {
            builder.append(quoteSender).append(": ");
            this.quoteVoiceLength.setText((CharSequence)content);
        } else {
            String voiceLength = "";
            if (quoteMessage.getBody() instanceof EMVoiceMessageBody) {
                EMVoiceMessageBody voiceMessageBody = (EMVoiceMessageBody)quoteMessage.getBody();
                if (voiceMessageBody != null && voiceMessageBody.getLength() > 0) {
                    voiceLength = voiceMessageBody.getLength() + "\"";
                }
                builder.append(quoteSender).append(": ");
            }
            this.quoteVoiceLength.setText((CharSequence)voiceLength);
        }
        SpannableString voiceSpan = new SpannableString((CharSequence)builder.toString());
        this.quoteVoiceName.setText((CharSequence)voiceSpan);
        this.quoteVoiceLayout.setVisibility(0);
    }

    protected void fileTypeDisplay(EMMessage quoteMessage, String quoteSender, String content) {
        StringBuilder builder = new StringBuilder();
        if (quoteMessage == null) {
            builder.append(quoteSender).append(": ");
            this.quoteFileIcon.setVisibility(0);
            this.quoteFileName.setText((CharSequence)content);
        } else {
            String fileName = "";
            if (quoteMessage.getBody() instanceof EMFileMessageBody) {
                EMFileMessageBody fileMessageBody = (EMFileMessageBody)quoteMessage.getBody();
                if (fileMessageBody != null && !TextUtils.isEmpty((CharSequence)fileMessageBody.getFileName())) {
                    fileName = EaseEditTextUtils.ellipsizeMiddleString(this.quoteFileName, fileMessageBody.getFileName(), 1, this.quoteFileName.getWidth() - this.quoteFileName.getPaddingLeft() - this.quoteFileName.getPaddingRight());
                }
                builder.append(quoteSender).append(": ");
            }
            this.quoteFileName.setText((CharSequence)fileName);
        }
        SpannableString fileSpan = new SpannableString((CharSequence)builder.toString());
        this.quoteFileTitle.setText((CharSequence)fileSpan);
        this.quoteFileLayout.setVisibility(0);
    }

    private void showVideoThumbView(EMMessage quoteMessage) {
        EMVideoMessageBody videoMessageBody;
        String imageUri = null;
        String imageUrl = "";
        int width = 0;
        int height = 0;
        if (quoteMessage.getBody() instanceof EMVideoMessageBody && (videoMessageBody = (EMVideoMessageBody)quoteMessage.getBody()) != null) {
            imageUri = videoMessageBody.getLocalThumb();
            imageUrl = videoMessageBody.getThumbnailUrl();
            int thumbnailHeight = videoMessageBody.getThumbnailHeight();
            int thumbnailWidth = videoMessageBody.getThumbnailWidth();
            width = (int)EaseCommonUtils.dip2px(this.mContext, 36.0f);
            height = (int)((float)width * 1.0f * (float)thumbnailHeight / (float)thumbnailWidth);
        }
        ((RequestBuilder)((RequestBuilder)Glide.with((Context)this.mContext).load(EaseFileUtils.isFileExistByUri(this.getContext(), Uri.parse(imageUri)) ? imageUri : imageUrl).override(width, height)).apply(new RequestOptions().error(R.drawable.ease_default_image)).diskCacheStrategy(DiskCacheStrategy.ALL)).into((ImageView)this.quoteVideoIcon);
    }

    private void showImageView(EMMessage message) {
        if (message.getType() == EMMessage.Type.IMAGE) {
            Uri imageUri = null;
            String imageUrl = "";
            int width = 0;
            int height = 0;
            EMImageMessageBody imageMessageBody = (EMImageMessageBody)message.getBody();
            if (imageMessageBody != null) {
                imageUri = imageMessageBody.getLocalUri();
                imageUrl = imageMessageBody.getRemoteUrl();
                int thumbnailHeight = imageMessageBody.getHeight();
                int thumbnailWidth = imageMessageBody.getWidth();
                width = (int)EaseCommonUtils.dip2px(this.mContext, 36.0f);
                height = (int)((float)width * 1.0f * (float)thumbnailHeight / (float)thumbnailWidth);
            }
            ((RequestBuilder)((RequestBuilder)Glide.with((Context)this.mContext).load((Object)(!EaseFileUtils.isFileExistByUri(this.getContext(), imageUri) ? imageUrl : imageUri)).override(width, height)).apply(new RequestOptions().error(R.drawable.ease_default_image)).diskCacheStrategy(DiskCacheStrategy.ALL)).into((ImageView)this.quoteImageView);
        }
    }

    private void showBigExpression(EMMessage message) {
        String emojiconId = message.getStringAttribute("em_expression_id", null);
        EaseEmojicon emojicon = null;
        if (EaseIM.getInstance().getEmojiconInfoProvider() != null) {
            emojicon = EaseIM.getInstance().getEmojiconInfoProvider().getEmojiconInfo(emojiconId);
        }
        if (emojicon != null) {
            if (emojicon.getBigIcon() != 0) {
                Glide.with((Context)this.mContext).load(Integer.valueOf(emojicon.getIcon())).apply((BaseRequestOptions)RequestOptions.placeholderOf((int)R.drawable.ease_default_expression)).into((ImageView)this.quoteBigExpressionImg);
            } else if (emojicon.getBigIconPath() != null) {
                Glide.with((Context)this.mContext).load(emojicon.getBigIconPath()).apply((BaseRequestOptions)RequestOptions.placeholderOf((int)R.drawable.ease_default_expression)).into((ImageView)this.quoteBigExpressionImg);
            } else {
                this.quoteBigExpressionImg.setImageResource(R.drawable.ease_default_expression);
            }
        }
    }

    public void clear() {
        this.message = null;
        this.quoteMessage = null;
    }

    public static interface IChatQuoteMessageShow
    extends IUIKitInterface {
        public SpannableString itemQuoteMessageShow(EMMessage var1, EMMessage.Type var2, String var3, String var4);
    }
}

