/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.style.ImageSpan;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class CenterImageSpan
extends ImageSpan {
    private Boolean isSmallImage = false;

    public CenterImageSpan(@NonNull Context context, int resourceId) {
        this(context, resourceId, 2);
    }

    public CenterImageSpan(@NonNull Context context, int resourceId, int verticalAlignment) {
        super(context, resourceId, verticalAlignment);
    }

    public int getSize(@NonNull Paint paint, CharSequence text, int start, int end, @Nullable Paint.FontMetricsInt fm) {
        Drawable d = this.getDrawable();
        Rect rect = d.getBounds();
        if (fm != null) {
            Paint.FontMetricsInt fmPaint = paint.getFontMetricsInt();
            int imageH = rect.bottom - rect.top;
            int fontH = fmPaint.descent - fmPaint.ascent;
            if (imageH > fontH) {
                this.isSmallImage = false;
                fm.ascent = fmPaint.ascent - (imageH - fontH) / 2;
                fm.top = fmPaint.ascent - (imageH - fontH) / 2;
                fm.bottom = fmPaint.descent + (imageH - fontH) / 2;
                fm.descent = fmPaint.descent + (imageH - fontH) / 2;
            } else {
                this.isSmallImage = true;
                fm.ascent = -rect.bottom;
                fm.descent = 0;
                fm.top = fm.ascent;
                fm.bottom = 0;
            }
        }
        return rect.right;
    }

    public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
        Drawable b = this.getDrawable();
        canvas.save();
        int transY = bottom - b.getBounds().bottom;
        if (this.isSmallImage.booleanValue()) {
            transY -= (bottom - top) / 2 - b.getBounds().height() / 2;
        }
        canvas.translate(x, (float)transY);
        b.draw(canvas);
        canvas.restore();
    }
}

