/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.viewholder;

import android.content.Intent;
import android.os.Parcelable;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.easeui.EaseIM;
import com.hyphenate.easeui.interfaces.MessageListItemClickListener;
import com.hyphenate.easeui.manager.EaseDingMessageHelper;
import com.hyphenate.easeui.ui.EaseDingAckUserListActivity;
import com.hyphenate.easeui.viewholder.EaseChatRowViewHolder;
import com.hyphenate.easeui.widget.chatrow.EaseChatRowText;
import com.hyphenate.exceptions.HyphenateException;

public class EaseTextViewHolder
extends EaseChatRowViewHolder {
    public EaseTextViewHolder(@NonNull View itemView, MessageListItemClickListener itemClickListener) {
        super(itemView, itemClickListener);
    }

    public static EaseChatRowViewHolder create(ViewGroup parent, boolean isSender, MessageListItemClickListener itemClickListener) {
        return new EaseTextViewHolder((View)new EaseChatRowText(parent.getContext(), isSender), itemClickListener);
    }

    @Override
    public void onBubbleClick(EMMessage message) {
        super.onBubbleClick(message);
        if (!EaseDingMessageHelper.get().isDingMessage(message) || message.getChatType() != EMMessage.ChatType.GroupChat || message.direct() != EMMessage.Direct.SEND) {
            return;
        }
        Intent i = new Intent(this.getContext(), EaseDingAckUserListActivity.class);
        i.putExtra("msg", (Parcelable)message);
        this.getContext().startActivity(i);
    }

    @Override
    protected void handleReceiveMessage(EMMessage message) {
        super.handleReceiveMessage(message);
        if (!EaseIM.getInstance().getConfigsManager().enableSendChannelAck() && !message.isAcked() && message.getChatType() == EMMessage.ChatType.Chat) {
            try {
                EMClient.getInstance().chatManager().ackMessageRead(message.getFrom(), message.getMsgId());
            }
            catch (HyphenateException e) {
                e.printStackTrace();
            }
            return;
        }
        ((EaseChatRowText)this.getChatRow()).onSetUpQuoteView(message);
        EaseDingMessageHelper.get().sendAckMessage(message);
    }
}

