/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.utils;

import android.content.Context;
import android.text.TextUtils;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.hyphenate.easeui.EaseIM;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.domain.EaseAvatarOptions;
import com.hyphenate.easeui.domain.EaseUser;
import com.hyphenate.easeui.provider.EaseUserProfileProvider;
import com.hyphenate.easeui.utils.EaseCommonUtils;
import com.hyphenate.easeui.widget.EaseImageView;

public class EaseUserUtils {
    public static EaseUser getUserInfo(String username) {
        EaseUserProfileProvider provider = EaseIM.getInstance().getUserProvider();
        return provider == null ? null : provider.getUser(username);
    }

    public static EaseUser getGroupUserInfo(String groupId, String username) {
        EaseUserProfileProvider provider = EaseIM.getInstance().getUserProvider();
        return provider == null ? null : provider.getGroupUser(groupId, username);
    }

    public static void setUserAvatarStyle(EaseImageView imageView) {
        EaseAvatarOptions avatarOptions = EaseIM.getInstance().getAvatarOptions();
        if (avatarOptions == null || imageView == null) {
            return;
        }
        if (avatarOptions.getAvatarShape() != 0) {
            imageView.setShapeType(avatarOptions.getAvatarShape());
        }
        if (avatarOptions.getAvatarBorderWidth() != 0) {
            imageView.setBorderWidth(avatarOptions.getAvatarBorderWidth());
        }
        if (avatarOptions.getAvatarBorderColor() != 0) {
            imageView.setBorderColor(avatarOptions.getAvatarBorderColor());
        }
        if (avatarOptions.getAvatarRadius() != 0) {
            imageView.setRadius(avatarOptions.getAvatarRadius());
        }
    }

    public static void setUserAvatar(Context context, String username, ImageView imageView) {
        EaseUser user = EaseUserUtils.getUserInfo(username);
        EaseUserUtils.setUserAvatar(context, user, imageView);
    }

    public static void setUserAvatar(Context context, String groupId, String username, ImageView imageView) {
        EaseUser user = EaseUserUtils.getGroupUserInfo(groupId, username);
        EaseUserUtils.setUserAvatar(context, user, imageView);
    }

    private static void setUserAvatar(Context context, EaseUser user, ImageView imageView) {
        if (context == null || imageView == null) {
            return;
        }
        if (user == null || TextUtils.isEmpty((CharSequence)user.getAvatar())) {
            Glide.with((Context)context).load(Integer.valueOf(R.drawable.ease_default_avatar)).into(imageView);
            return;
        }
        try {
            int avatarResId = Integer.parseInt(user.getAvatar());
            Glide.with((Context)context).load(Integer.valueOf(avatarResId)).into(imageView);
        }
        catch (Exception e) {
            Glide.with((Context)context).load(user.getAvatar()).apply(RequestOptions.placeholderOf((int)R.drawable.ease_default_avatar).diskCacheStrategy(DiskCacheStrategy.ALL)).into(imageView);
        }
    }

    public static void showUserAvatar(Context context, String avatar, ImageView imageView) {
        if (TextUtils.isEmpty((CharSequence)avatar)) {
            Glide.with((Context)context).load(Integer.valueOf(R.drawable.ease_default_avatar)).into(imageView);
            return;
        }
        try {
            int avatarResId = Integer.parseInt(avatar);
            Glide.with((Context)context).load(Integer.valueOf(avatarResId)).into(imageView);
        }
        catch (Exception e) {
            Glide.with((Context)context).load(avatar).apply(RequestOptions.placeholderOf((int)R.drawable.ease_default_avatar).diskCacheStrategy(DiskCacheStrategy.ALL)).into(imageView);
        }
    }

    public static void setUserNick(String username, TextView textView) {
        EaseUser user = EaseUserUtils.getUserInfo(username);
        EaseUserUtils.setUserNickname(user, username, textView);
    }

    public static void setUserNick(String groupId, String username, TextView textView) {
        EaseUser user = EaseUserUtils.getGroupUserInfo(groupId, username);
        EaseUserUtils.setUserNickname(user, username, textView);
    }

    private static void setUserNickname(EaseUser user, String username, TextView textView) {
        if (textView == null) {
            return;
        }
        String remark = EaseUserUtils.getContactRemark(username);
        if (!TextUtils.isEmpty((CharSequence)remark)) {
            textView.setText((CharSequence)remark);
            return;
        }
        if (user == null || TextUtils.isEmpty((CharSequence)user.getNickname())) {
            textView.setText((CharSequence)username);
            return;
        }
        textView.setText((CharSequence)user.getNickname());
    }

    private static String getContactRemark(String username) {
        EaseUserProfileProvider provider = EaseIM.getInstance().getUserProvider();
        return provider == null ? null : provider.getContactRemark(username);
    }

    public static String getDisplayName(String username) {
        EaseUserProfileProvider provider = EaseIM.getInstance().getUserProvider();
        if (provider == null) {
            return username;
        }
        String contactRemark = provider.getContactRemark(username);
        if (!TextUtils.isEmpty((CharSequence)contactRemark)) {
            return contactRemark;
        }
        EaseUser user = provider.getUser(username);
        if (user == null || TextUtils.isEmpty((CharSequence)user.getNickname())) {
            return username;
        }
        return user.getNickname();
    }

    public static String getLimitName(String username) {
        int characterCount = EaseCommonUtils.getCharacterCount(username);
        if (characterCount > 32) {
            username = EaseCommonUtils.isChinese(username) ? username.substring(0, 16) + "..." : username.substring(0, 32) + "...";
        }
        return username;
    }
}

