/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules.conversation.delegate;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.widget.ImageView;
import androidx.core.content.ContextCompat;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.hyphenate.chat.EMConversation;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.easeui.EaseIM;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.manager.EaseSystemMsgManager;
import com.hyphenate.easeui.modules.conversation.delegate.EaseDefaultConversationDelegate;
import com.hyphenate.easeui.modules.conversation.model.EaseConversationInfo;
import com.hyphenate.easeui.modules.conversation.model.EaseConversationSetStyle;
import com.hyphenate.easeui.provider.EaseConversationInfoProvider;
import com.hyphenate.easeui.utils.EaseCommonUtils;
import com.hyphenate.easeui.utils.EaseDateUtils;
import com.hyphenate.easeui.utils.EaseSmileUtils;
import java.util.Date;

public class EaseSystemMsgDelegate
extends EaseDefaultConversationDelegate {
    public EaseSystemMsgDelegate(EaseConversationSetStyle setModel) {
        super(setModel);
    }

    @Override
    public boolean isForViewType(EaseConversationInfo item, int position) {
        return item != null && item.getInfo() instanceof EMConversation && EaseSystemMsgManager.getInstance().isSystemConversation((EMConversation)item.getInfo());
    }

    @Override
    protected void onBindConViewHolder(EaseDefaultConversationDelegate.ViewHolder holder, int position, EaseConversationInfo bean) {
        EMMessage lastMessage;
        Drawable avatar;
        EMConversation item = (EMConversation)bean.getInfo();
        Context context = holder.itemView.getContext();
        String username = item.conversationId();
        holder.listIteaseLayout.setBackground(!TextUtils.isEmpty((CharSequence)item.getExtField()) ? ContextCompat.getDrawable((Context)context, (int)R.drawable.ease_conversation_top_bg) : null);
        holder.mentioned.setVisibility(8);
        EaseConversationInfoProvider infoProvider = EaseIM.getInstance().getConversationInfoProvider();
        holder.avatar.setImageResource(R.drawable.em_system_nofinication);
        holder.name.setText((CharSequence)holder.mContext.getString(R.string.ease_conversation_system_message));
        if (infoProvider != null && (avatar = infoProvider.getDefaultTypeAvatar("em_system_type")) != null) {
            ((RequestBuilder)Glide.with((Context)holder.mContext).load(avatar).error(R.drawable.em_system_nofinication)).into((ImageView)holder.avatar);
        }
        if (!this.setModel.isHideUnreadDot()) {
            this.showUnreadNum(holder, item.getUnreadMsgCount());
        }
        if ((lastMessage = item.getLastMessage()) != null) {
            holder.message.setText((CharSequence)EaseSmileUtils.getSmiledText(context, EaseCommonUtils.getMessageDigest(lastMessage, context)));
            holder.time.setText((CharSequence)EaseDateUtils.getTimestampString(holder.itemView.getContext(), new Date(lastMessage.getMsgTime())));
        }
    }
}

