/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules.chat.presenter;

import android.net.Uri;
import androidx.annotation.NonNull;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMConversation;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMMessageBody;
import com.hyphenate.easeui.modules.EaseBasePresenter;
import com.hyphenate.easeui.modules.ILoadDataView;
import com.hyphenate.easeui.modules.chat.presenter.IHandleMessageView;
import com.hyphenate.easeui.utils.EaseCommonUtils;

public abstract class EaseHandleMessagePresenter
extends EaseBasePresenter {
    protected IHandleMessageView mView;
    protected int chatType;
    protected String toChatUsername;
    protected EMConversation conversation;

    @Override
    public void attachView(ILoadDataView view) {
        this.mView = (IHandleMessageView)view;
    }

    @Override
    public void detachView() {
        this.mView = null;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.detachView();
    }

    public void setupWithToUser(int chatType, @NonNull String toChatUsername) {
        this.chatType = chatType;
        this.toChatUsername = toChatUsername;
        this.conversation = EMClient.getInstance().chatManager().getConversation(toChatUsername, EaseCommonUtils.getConversationType(chatType), true);
    }

    public abstract void sendTextMessage(String var1);

    public abstract void sendTextMessage(String var1, boolean var2);

    public abstract void sendAtMessage(String var1);

    public abstract void sendBigExpressionMessage(String var1, String var2);

    public abstract void sendVoiceMessage(Uri var1, int var2);

    public abstract void sendImageMessage(Uri var1);

    public abstract void sendImageMessage(Uri var1, boolean var2);

    public abstract void sendLocationMessage(double var1, double var3, String var5, String var6);

    public abstract void sendVideoMessage(Uri var1, int var2);

    public abstract void sendFileMessage(Uri var1);

    public abstract void addMessageAttributes(EMMessage var1);

    public abstract void sendMessage(EMMessage var1);

    public abstract void sendCmdMessage(String var1);

    public abstract void resendMessage(EMMessage var1);

    public abstract void deleteMessage(EMMessage var1);

    public abstract void recallMessage(EMMessage var1);

    public abstract void modifyMessage(String var1, EMMessageBody var2);

    public boolean isGroupChat() {
        return this.chatType == 2;
    }

    public abstract void translateMessage(EMMessage var1, String var2, boolean var3);

    public abstract void hideTranslate(EMMessage var1);
}

