/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules.chat;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.domain.EaseEmojicon;
import com.hyphenate.easeui.modules.chat.EaseChatExtendMenu;
import com.hyphenate.easeui.modules.chat.EaseChatPrimaryMenu;
import com.hyphenate.easeui.modules.chat.EaseEmojiconMenu;
import com.hyphenate.easeui.modules.chat.interfaces.ChatInputMenuListener;
import com.hyphenate.easeui.modules.chat.interfaces.EaseChatExtendMenuItemClickListener;
import com.hyphenate.easeui.modules.chat.interfaces.EaseChatPrimaryMenuListener;
import com.hyphenate.easeui.modules.chat.interfaces.EaseEmojiconMenuListener;
import com.hyphenate.easeui.modules.chat.interfaces.IChatEmojiconMenu;
import com.hyphenate.easeui.modules.chat.interfaces.IChatExtendMenu;
import com.hyphenate.easeui.modules.chat.interfaces.IChatInputMenu;
import com.hyphenate.easeui.modules.chat.interfaces.IChatPrimaryMenu;
import com.hyphenate.easeui.utils.EaseSmileUtils;
import com.hyphenate.util.EMLog;

public class EaseChatInputMenu
extends LinearLayout
implements IChatInputMenu,
EaseChatPrimaryMenuListener,
EaseEmojiconMenuListener,
EaseChatExtendMenuItemClickListener {
    private static final String TAG = EaseChatInputMenu.class.getSimpleName();
    private LinearLayout chatMenuContainer;
    private FrameLayout primaryMenuContainer;
    private FrameLayout extendMenuContainer;
    private IChatPrimaryMenu primaryMenu;
    private IChatEmojiconMenu emojiconMenu;
    private IChatExtendMenu extendMenu;
    private ChatInputMenuListener menuListener;

    public EaseChatInputMenu(Context context) {
        this(context, null);
    }

    public EaseChatInputMenu(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EaseChatInputMenu(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.ease_widget_chat_input_menu_container, (ViewGroup)this);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.chatMenuContainer = (LinearLayout)this.findViewById(R.id.chat_menu_container);
        this.primaryMenuContainer = (FrameLayout)this.findViewById(R.id.primary_menu_container);
        this.extendMenuContainer = (FrameLayout)this.findViewById(R.id.extend_menu_container);
        this.init();
    }

    private void init() {
        this.showPrimaryMenu();
        if (this.extendMenu == null) {
            this.extendMenu = new EaseChatExtendMenu(this.getContext());
            ((EaseChatExtendMenu)this.extendMenu).init();
        }
        if (this.emojiconMenu == null) {
            this.emojiconMenu = new EaseEmojiconMenu(this.getContext());
            ((EaseEmojiconMenu)this.emojiconMenu).init();
        }
    }

    @Override
    public void setCustomPrimaryMenu(IChatPrimaryMenu menu) {
        this.primaryMenu = menu;
        this.showPrimaryMenu();
    }

    @Override
    public void setCustomEmojiconMenu(IChatEmojiconMenu menu) {
        this.emojiconMenu = menu;
    }

    @Override
    public void setCustomExtendMenu(IChatExtendMenu menu) {
        this.extendMenu = menu;
    }

    @Override
    public void hideExtendContainer() {
        this.primaryMenu.showNormalStatus();
        this.extendMenuContainer.setVisibility(8);
    }

    @Override
    public void showEmojiconMenu(boolean show) {
        if (show) {
            this.showEmojiconMenu();
        } else {
            this.extendMenuContainer.setVisibility(8);
        }
    }

    @Override
    public void showExtendMenu(boolean show) {
        if (show) {
            this.showExtendMenu();
        } else {
            this.extendMenuContainer.setVisibility(8);
            if (this.primaryMenu != null) {
                this.primaryMenu.hideExtendStatus();
            }
        }
    }

    @Override
    public void hideSoftKeyboard() {
        if (this.primaryMenu != null) {
            this.primaryMenu.hideSoftKeyboard();
        }
    }

    @Override
    public void setChatInputMenuListener(ChatInputMenuListener listener) {
        this.menuListener = listener;
    }

    @Override
    public IChatPrimaryMenu getPrimaryMenu() {
        return this.primaryMenu;
    }

    @Override
    public IChatEmojiconMenu getEmojiconMenu() {
        return this.emojiconMenu;
    }

    @Override
    public IChatExtendMenu getChatExtendMenu() {
        return this.extendMenu;
    }

    @Override
    public boolean onBackPressed() {
        if (this.extendMenuContainer.getVisibility() == 0) {
            this.extendMenuContainer.setVisibility(8);
            return false;
        }
        return true;
    }

    private void showPrimaryMenu() {
        if (this.primaryMenu == null) {
            this.primaryMenu = new EaseChatPrimaryMenu(this.getContext());
        }
        if (this.primaryMenu instanceof View) {
            this.primaryMenuContainer.removeAllViews();
            this.primaryMenuContainer.addView((View)this.primaryMenu);
            this.primaryMenu.setEaseChatPrimaryMenuListener(this);
        }
        if (this.primaryMenu instanceof Fragment && this.getContext() instanceof AppCompatActivity) {
            FragmentManager manager = ((AppCompatActivity)this.getContext()).getSupportFragmentManager();
            manager.beginTransaction().replace(R.id.primary_menu_container, (Fragment)this.primaryMenu).commitAllowingStateLoss();
            this.primaryMenu.setEaseChatPrimaryMenuListener(this);
        }
    }

    private void showExtendMenu() {
        if (this.extendMenu == null) {
            this.extendMenu = new EaseChatExtendMenu(this.getContext());
            ((EaseChatExtendMenu)this.extendMenu).init();
        }
        if (this.extendMenu instanceof View) {
            this.extendMenuContainer.setVisibility(0);
            this.extendMenuContainer.removeAllViews();
            this.extendMenuContainer.addView((View)this.extendMenu);
            this.extendMenu.addEaseChatExtendMenuItemClickListener(this);
        }
        if (this.extendMenu instanceof Fragment && this.getContext() instanceof AppCompatActivity) {
            this.extendMenuContainer.setVisibility(0);
            FragmentManager manager = ((AppCompatActivity)this.getContext()).getSupportFragmentManager();
            manager.beginTransaction().replace(R.id.extend_menu_container, (Fragment)this.extendMenu).commitAllowingStateLoss();
            this.extendMenu.addEaseChatExtendMenuItemClickListener(this);
        }
    }

    private void showEmojiconMenu() {
        if (this.emojiconMenu == null) {
            this.emojiconMenu = new EaseEmojiconMenu(this.getContext());
            ((EaseEmojiconMenu)this.emojiconMenu).init();
        }
        if (this.emojiconMenu instanceof View) {
            this.extendMenuContainer.setVisibility(0);
            this.extendMenuContainer.removeAllViews();
            this.extendMenuContainer.addView((View)this.emojiconMenu);
            this.emojiconMenu.setEmojiconMenuListener(this);
        }
        if (this.emojiconMenu instanceof Fragment && this.getContext() instanceof AppCompatActivity) {
            this.extendMenuContainer.setVisibility(0);
            FragmentManager manager = ((AppCompatActivity)this.getContext()).getSupportFragmentManager();
            manager.beginTransaction().replace(R.id.extend_menu_container, (Fragment)this.emojiconMenu).commitAllowingStateLoss();
            this.emojiconMenu.setEmojiconMenuListener(this);
        }
    }

    @Override
    public void onSendBtnClicked(String content) {
        EMLog.i((String)TAG, (String)("onSendBtnClicked content:" + content));
        if (this.menuListener != null) {
            this.menuListener.onSendMessage(content);
        }
    }

    @Override
    public void showCustomQuote(EMMessage message) {
        if (this.menuListener != null) {
            this.menuListener.showCustomQuote(message);
        }
    }

    @Override
    public void onTyping(CharSequence s, int start, int before, int count) {
        EMLog.i((String)TAG, (String)("onTyping: s = " + s));
        if (this.menuListener != null) {
            this.menuListener.onTyping(s, start, before, count);
        }
    }

    @Override
    public boolean onPressToSpeakBtnTouch(View v, MotionEvent event) {
        if (this.menuListener != null) {
            return this.menuListener.onPressToSpeakBtnTouch(v, event);
        }
        return false;
    }

    @Override
    public void onToggleVoiceBtnClicked() {
        Log.e((String)"TAG", (String)"onToggleVoiceBtnClicked");
        this.showExtendMenu(false);
    }

    @Override
    public void onToggleTextBtnClicked() {
        EMLog.i((String)TAG, (String)"onToggleTextBtnClicked");
        this.showExtendMenu(false);
    }

    @Override
    public void onToggleExtendClicked(boolean extend) {
        EMLog.i((String)TAG, (String)("onToggleExtendClicked extend:" + extend));
        this.showExtendMenu(extend);
    }

    @Override
    public void onToggleEmojiconClicked(boolean extend) {
        EMLog.i((String)TAG, (String)("onToggleEmojiconClicked extend:" + extend));
        this.showEmojiconMenu(extend);
    }

    @Override
    public void onEditTextClicked() {
        EMLog.i((String)TAG, (String)"onEditTextClicked");
    }

    @Override
    public void onEditTextHasFocus(boolean hasFocus) {
        EMLog.i((String)TAG, (String)("onEditTextHasFocus: hasFocus = " + hasFocus));
    }

    @Override
    public void onExpressionClicked(Object emojicon) {
        EMLog.i((String)TAG, (String)"onExpressionClicked");
        if (emojicon instanceof EaseEmojicon) {
            EaseEmojicon easeEmojicon = (EaseEmojicon)emojicon;
            if (easeEmojicon.getType() != EaseEmojicon.Type.BIG_EXPRESSION) {
                if (easeEmojicon.getEmojiText() != null) {
                    this.primaryMenu.onEmojiconInputEvent((CharSequence)EaseSmileUtils.getSmiledText(this.getContext(), easeEmojicon.getEmojiText()));
                }
            } else if (this.menuListener != null) {
                this.menuListener.onExpressionClicked(emojicon);
            }
        } else if (this.menuListener != null) {
            this.menuListener.onExpressionClicked(emojicon);
        }
    }

    @Override
    public void onDeleteImageClicked() {
        EMLog.i((String)TAG, (String)"onDeleteImageClicked");
        this.primaryMenu.onEmojiconDeleteEvent();
    }

    @Override
    public void onChatExtendMenuItemClick(int itemId, View view) {
        EMLog.i((String)TAG, (String)("onChatExtendMenuItemClick itemId = " + itemId));
        if (this.menuListener != null) {
            this.menuListener.onChatExtendMenuItemClick(itemId, view);
        }
    }
}

