/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.model;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.media.AudioManager;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Vibrator;
import android.text.TextUtils;
import androidx.core.app.NotificationCompat;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.easeui.EaseIM;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.provider.EaseSettingsProvider;
import com.hyphenate.easeui.utils.EaseCommonUtils;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.EasyUtils;
import java.util.HashSet;
import java.util.List;

public class EaseNotifier {
    private static final String TAG = "EaseNotifier";
    protected static int NOTIFY_ID = 341;
    protected static final String CHANNEL_ID = "hyphenate_chatuidemo_notification";
    protected static final long[] VIBRATION_PATTERN = new long[]{0L, 180L, 80L, 120L};
    protected NotificationManager notificationManager = null;
    protected HashSet<String> fromUsers = new HashSet();
    protected int notificationNum = 0;
    protected Context appContext;
    protected String packageName;
    protected String msg;
    protected long lastNotifyTime;
    protected Ringtone ringtone = null;
    protected AudioManager audioManager;
    protected Vibrator vibrator;
    protected EaseNotificationInfoProvider notificationInfoProvider;

    public EaseNotifier(Context context) {
        this.appContext = context.getApplicationContext();
        this.notificationManager = (NotificationManager)context.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(CHANNEL_ID, (CharSequence)"hyphenate chatuidemo message default channel.", 3);
            channel.setVibrationPattern(VIBRATION_PATTERN);
            this.notificationManager.createNotificationChannel(channel);
        }
        this.packageName = this.appContext.getApplicationInfo().packageName;
        this.msg = context.getString(R.string.contact_send_message);
        this.audioManager = (AudioManager)this.appContext.getSystemService("audio");
        this.vibrator = (Vibrator)this.appContext.getSystemService("vibrator");
    }

    public void reset() {
        this.resetNotificationCount();
        this.cancelNotification();
    }

    void resetNotificationCount() {
        this.notificationNum = 0;
        this.fromUsers.clear();
    }

    void cancelNotification() {
        if (this.notificationManager != null) {
            this.notificationManager.cancel(NOTIFY_ID);
        }
    }

    public synchronized void notify(EMMessage message) {
        if (EaseCommonUtils.isSilentMessage(message)) {
            return;
        }
        EaseSettingsProvider settingsProvider = EaseIM.getInstance().getSettingsProvider();
        if (!settingsProvider.isMsgNotifyAllowed(message)) {
            return;
        }
        if (!EasyUtils.isAppRunningForeground((Context)this.appContext)) {
            EMLog.d((String)TAG, (String)"app is running in background");
            ++this.notificationNum;
            this.fromUsers.add(message.getFrom());
            this.handleMessage(message);
        }
    }

    public synchronized void notify(List<EMMessage> messages) {
        if (EaseCommonUtils.isSilentMessage(messages.get(messages.size() - 1))) {
            return;
        }
        EaseSettingsProvider settingsProvider = EaseIM.getInstance().getSettingsProvider();
        if (!settingsProvider.isMsgNotifyAllowed(null)) {
            return;
        }
        if (!EasyUtils.isAppRunningForeground((Context)this.appContext)) {
            EMLog.d((String)TAG, (String)"app is running in background");
            for (EMMessage message : messages) {
                ++this.notificationNum;
                this.fromUsers.add(message.getFrom());
            }
            this.handleMessage(messages.get(messages.size() - 1));
        }
    }

    public synchronized void notify(String content) {
        if (!EasyUtils.isAppRunningForeground((Context)this.appContext)) {
            try {
                NotificationCompat.Builder builder = this.generateBaseBuilder(content);
                Notification notification = builder.build();
                this.notificationManager.notify(NOTIFY_ID, notification);
                if (Build.VERSION.SDK_INT < 26) {
                    this.vibrateAndPlayTone(null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void notify(Intent fullScreenIntent, String title, String content) {
        if (!EasyUtils.isAppRunningForeground((Context)this.appContext)) {
            try {
                NotificationCompat.Builder builder = this.generateBaseFullIntentBuilder(fullScreenIntent, content);
                if (!TextUtils.isEmpty((CharSequence)title)) {
                    builder.setContentTitle((CharSequence)title);
                }
                Notification notification = builder.build();
                this.notificationManager.notify(NOTIFY_ID, notification);
                if (Build.VERSION.SDK_INT < 26) {
                    this.vibrateAndPlayTone(null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void handleMessage(EMMessage message) {
        try {
            int fromUsersNum = this.fromUsers.size();
            String notifyText = String.format(this.msg, fromUsersNum, this.notificationNum);
            NotificationCompat.Builder builder = this.generateBaseBuilder(notifyText);
            if (this.notificationInfoProvider != null) {
                int smallIcon;
                Intent i;
                String contentTitle = this.notificationInfoProvider.getTitle(message);
                if (contentTitle != null) {
                    builder.setContentTitle((CharSequence)contentTitle);
                }
                if ((notifyText = this.notificationInfoProvider.getDisplayedText(message)) != null) {
                    builder.setTicker((CharSequence)notifyText);
                }
                if ((i = this.notificationInfoProvider.getLaunchIntent(message)) != null) {
                    PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.appContext, (int)NOTIFY_ID, (Intent)i, (int)0x8000000);
                    builder.setContentIntent(pendingIntent);
                }
                if ((notifyText = this.notificationInfoProvider.getLatestText(message, fromUsersNum, this.notificationNum)) != null) {
                    builder.setContentText((CharSequence)notifyText);
                }
                if ((smallIcon = this.notificationInfoProvider.getSmallIcon(message)) != 0) {
                    builder.setSmallIcon(smallIcon);
                }
            }
            Notification notification = builder.build();
            this.notificationManager.notify(NOTIFY_ID, notification);
            if (Build.VERSION.SDK_INT < 26) {
                this.vibrateAndPlayTone(message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private NotificationCompat.Builder generateBaseBuilder(String content) {
        PackageManager pm = this.appContext.getPackageManager();
        String title = pm.getApplicationLabel(this.appContext.getApplicationInfo()).toString();
        Intent i = this.appContext.getPackageManager().getLaunchIntentForPackage(this.packageName);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.appContext, (int)NOTIFY_ID, (Intent)i, (int)0x8000000);
        return new NotificationCompat.Builder(this.appContext, CHANNEL_ID).setSmallIcon(this.appContext.getApplicationInfo().icon).setContentTitle((CharSequence)title).setTicker((CharSequence)content).setContentText((CharSequence)content).setWhen(System.currentTimeMillis()).setAutoCancel(true).setContentIntent(pendingIntent);
    }

    private NotificationCompat.Builder generateBaseFullIntentBuilder(Intent fullScreenIntent, String content) {
        PackageManager pm = this.appContext.getPackageManager();
        String title = pm.getApplicationLabel(this.appContext.getApplicationInfo()).toString();
        PendingIntent fullScreenPendingIntent = PendingIntent.getActivity((Context)this.appContext, (int)NOTIFY_ID, (Intent)fullScreenIntent, (int)0x8000000);
        return new NotificationCompat.Builder(this.appContext, CHANNEL_ID).setSmallIcon(this.appContext.getApplicationInfo().icon).setContentTitle((CharSequence)title).setTicker((CharSequence)content).setContentText((CharSequence)content).setPriority(1).setCategory("call").setWhen(System.currentTimeMillis()).setAutoCancel(true).setFullScreenIntent(fullScreenPendingIntent, true);
    }

    public void vibrateAndPlayTone(EMMessage message) {
        if (message != null && EaseCommonUtils.isSilentMessage(message)) {
            return;
        }
        EaseSettingsProvider settingsProvider = EaseIM.getInstance().getSettingsProvider();
        if (!settingsProvider.isMsgNotifyAllowed(null)) {
            return;
        }
        if (System.currentTimeMillis() - this.lastNotifyTime < 1000L) {
            return;
        }
        try {
            this.lastNotifyTime = System.currentTimeMillis();
            if (this.audioManager.getRingerMode() == 0) {
                EMLog.e((String)TAG, (String)"in silent mode now");
                return;
            }
            if (settingsProvider.isMsgVibrateAllowed(message)) {
                this.vibrator.vibrate(VIBRATION_PATTERN, -1);
            }
            if (settingsProvider.isMsgSoundAllowed(message)) {
                if (this.ringtone == null) {
                    Uri notificationUri = RingtoneManager.getDefaultUri((int)2);
                    this.ringtone = RingtoneManager.getRingtone((Context)this.appContext, (Uri)notificationUri);
                    if (this.ringtone == null) {
                        EMLog.d((String)TAG, (String)("cant find ringtone at:" + notificationUri.getPath()));
                        return;
                    }
                }
                if (!this.ringtone.isPlaying()) {
                    String vendor = Build.MANUFACTURER;
                    this.ringtone.play();
                    if (vendor != null && vendor.toLowerCase().contains("samsung")) {
                        Thread ctlThread = new Thread(){

                            @Override
                            public void run() {
                                try {
                                    Thread.sleep(3000L);
                                    if (EaseNotifier.this.ringtone.isPlaying()) {
                                        EaseNotifier.this.ringtone.stop();
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        };
                        ctlThread.run();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setNotificationInfoProvider(EaseNotificationInfoProvider provider) {
        this.notificationInfoProvider = provider;
    }

    public static interface EaseNotificationInfoProvider {
        public String getDisplayedText(EMMessage var1);

        public String getLatestText(EMMessage var1, int var2, int var3);

        public String getTitle(EMMessage var1);

        public int getSmallIcon(EMMessage var1);

        public Intent getLaunchIntent(EMMessage var1);
    }
}

