/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.adapter;

import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.adapter.EaseAdapterDelegate;
import com.hyphenate.easeui.adapter.EaseBaseDelegateAdapter;
import com.hyphenate.easeui.adapter.EaseBaseRecyclerViewAdapter;
import com.hyphenate.easeui.delegate.EaseMessageAdapterDelegate;
import com.hyphenate.easeui.interfaces.MessageListItemClickListener;
import com.hyphenate.easeui.model.styles.EaseMessageListItemStyle;

public class EaseMessageAdapter
extends EaseBaseDelegateAdapter<EMMessage> {
    public MessageListItemClickListener itemClickListener;
    private int highlightPosition = -1;

    @Override
    public int getEmptyLayoutId() {
        return R.layout.ease_layout_empty_list_invisible;
    }

    @Override
    public EaseBaseRecyclerViewAdapter.ViewHolder getViewHolder(ViewGroup parent, int viewType) {
        EaseAdapterDelegate delegate = this.getAdapterDelegate(viewType);
        if (delegate instanceof EaseMessageAdapterDelegate) {
            ((EaseMessageAdapterDelegate)delegate).setListItemClickListener(this.itemClickListener);
        }
        return super.getViewHolder(parent, viewType);
    }

    @Override
    public EaseBaseDelegateAdapter addDelegate(EaseAdapterDelegate delegate) {
        EaseAdapterDelegate clone = null;
        try {
            clone = (EaseAdapterDelegate)delegate.clone();
            clone.setTag(EMMessage.Direct.RECEIVE.name());
            if (clone instanceof EaseMessageAdapterDelegate) {
                ((EaseMessageAdapterDelegate)clone).setListItemClickListener(this.itemClickListener);
            }
            super.addDelegate(clone);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        delegate.setTag(EMMessage.Direct.SEND.name());
        if (delegate instanceof EaseMessageAdapterDelegate) {
            ((EaseMessageAdapterDelegate)delegate).setListItemClickListener(this.itemClickListener);
        }
        return super.addDelegate(delegate);
    }

    @Override
    public EaseBaseDelegateAdapter setFallbackDelegate(EaseAdapterDelegate delegate) {
        EaseAdapterDelegate clone = null;
        try {
            clone = (EaseAdapterDelegate)delegate.clone();
            clone.setTag(EMMessage.Direct.RECEIVE.name());
            if (clone instanceof EaseMessageAdapterDelegate) {
                ((EaseMessageAdapterDelegate)clone).setListItemClickListener(this.itemClickListener);
            }
            super.setFallbackDelegate(clone);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        delegate.setTag(EMMessage.Direct.SEND.name());
        if (delegate instanceof EaseMessageAdapterDelegate) {
            ((EaseMessageAdapterDelegate)delegate).setListItemClickListener(this.itemClickListener);
        }
        return super.setFallbackDelegate(delegate);
    }

    @Override
    public void onBindViewHolder(@NonNull EaseBaseRecyclerViewAdapter.ViewHolder holder, int position) {
        super.onBindViewHolder(holder, position);
        if (position == this.highlightPosition) {
            View outLayout = holder.itemView.findViewById(R.id.rl_bubble_out);
            if (outLayout != null) {
                this.startAnimator(outLayout);
            } else {
                this.startAnimator(holder.itemView);
            }
            this.highlightPosition = -1;
        }
    }

    private void startAnimator(final View view) {
        final Drawable background = view.getBackground();
        final int darkColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.ease_chat_item_bg_dark);
        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{0, darkColor});
        colorAnimation.setDuration(500L);
        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                view.setBackgroundColor(((Integer)animator.getAnimatedValue()).intValue());
                if ((Integer)animator.getAnimatedValue() == darkColor) {
                    view.setBackground(background);
                } else if ((Integer)animator.getAnimatedValue() == 0) {
                    view.setBackground(null);
                }
            }
        });
        colorAnimation.start();
    }

    private EMMessage getItemMessage(int position) {
        if (this.mData != null && !this.mData.isEmpty()) {
            return (EMMessage)this.mData.get(position);
        }
        return null;
    }

    public EaseMessageListItemStyle createDefaultItemStyle() {
        EaseMessageListItemStyle.Builder builder = new EaseMessageListItemStyle.Builder();
        builder.showAvatar(true).showUserNick(false);
        return builder.build();
    }

    public void setListItemClickListener(MessageListItemClickListener itemClickListener) {
        this.itemClickListener = itemClickListener;
    }

    public void highlightItem(int position) {
        this.highlightPosition = position;
        this.notifyItemChanged(position);
    }
}

