/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.IdRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.adapter.EaseBaseAdapter;
import com.hyphenate.easeui.interfaces.OnItemClickListener;
import com.hyphenate.easeui.interfaces.OnItemLongClickListener;
import com.hyphenate.util.EMLog;
import java.util.ArrayList;
import java.util.List;

public abstract class EaseBaseRecyclerViewAdapter<T>
extends EaseBaseAdapter<ViewHolder> {
    public static final int VIEW_TYPE_EMPTY = -1;
    public static final int VIEW_TYPE_ITEM = 0;
    private OnItemClickListener mOnItemClickListener;
    private OnItemLongClickListener mOnItemLongClickListener;
    public Context mContext;
    public List<T> mData;
    private boolean hideEmptyView;
    private View emptyView;
    private int emptyViewId;

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        EMLog.i((String)"adapter", (String)"onCreateViewHolder()");
        this.mContext = parent.getContext();
        if (viewType == -1) {
            return this.getEmptyViewHolder(parent);
        }
        final ViewHolder holder = this.getViewHolder(parent, viewType);
        if (this.isItemClickEnable()) {
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    EaseBaseRecyclerViewAdapter.this.itemClickAction(v, holder.getBindingAdapterPosition());
                }
            });
        }
        if (this.isItemLongClickEnable()) {
            holder.itemView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    return EaseBaseRecyclerViewAdapter.this.itemLongClickAction(v, holder.getBindingAdapterPosition());
                }
            });
        }
        return holder;
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        holder.setAdapter(this);
        if (this.isEmptyViewType(position)) {
            return;
        }
        if (this.mData == null || this.mData.isEmpty()) {
            return;
        }
        T item = this.getItem(position);
        holder.setData(item, position);
        holder.setDataList(this.mData, position);
    }

    public boolean isEmptyViewType(int position) {
        int viewType = this.getItemViewType(position);
        return viewType == -1;
    }

    public boolean itemLongClickAction(View v, int position) {
        if (this.mOnItemLongClickListener != null) {
            return this.mOnItemLongClickListener.onItemLongClick(v, position);
        }
        return false;
    }

    public int getItemCount() {
        return this.mData == null || this.mData.isEmpty() ? 1 : this.mData.size();
    }

    public int getItemViewType(int position) {
        return this.mData == null || this.mData.isEmpty() ? -1 : 0;
    }

    public long getItemId(int position) {
        return position;
    }

    public boolean isItemClickEnable() {
        return true;
    }

    public boolean isItemLongClickEnable() {
        return true;
    }

    public void itemClickAction(View v, int position) {
        if (this.mOnItemClickListener != null) {
            this.mOnItemClickListener.onItemClick(v, position);
        }
    }

    private ViewHolder getEmptyViewHolder(ViewGroup parent) {
        View emptyView = this.getEmptyView(parent);
        if (this.emptyView != null) {
            emptyView = this.emptyView;
        }
        if (this.emptyViewId > 0) {
            emptyView = LayoutInflater.from((Context)this.mContext).inflate(this.emptyViewId, parent, false);
        }
        if (this.hideEmptyView) {
            emptyView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.ease_layout_no_data_show_nothing, parent, false);
        }
        return new ViewHolder<T>(emptyView){

            @Override
            public void initView(View itemView) {
            }

            @Override
            public void setData(T item, int position) {
            }
        };
    }

    public void hideEmptyView(boolean hide) {
        this.hideEmptyView = hide;
        this.notifyDataSetChanged();
    }

    public void setEmptyView(View emptyView) {
        this.emptyView = emptyView;
        this.notifyDataSetChanged();
    }

    public void setEmptyView(@LayoutRes int emptyViewId) {
        this.emptyViewId = emptyViewId;
        this.notifyDataSetChanged();
    }

    private View getEmptyView(ViewGroup parent) {
        return LayoutInflater.from((Context)this.mContext).inflate(this.getEmptyLayoutId(), parent, false);
    }

    public abstract ViewHolder getViewHolder(ViewGroup var1, int var2);

    @Override
    public synchronized T getItem(int position) {
        return this.mData == null ? null : (this.mData.size() <= position ? null : this.mData.get(position));
    }

    public synchronized void setData(List<T> data) {
        this.mData = data;
        this.notifyDataSetChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(T item) {
        Class<EaseBaseRecyclerViewAdapter> clazz = EaseBaseRecyclerViewAdapter.class;
        synchronized (EaseBaseRecyclerViewAdapter.class) {
            if (this.mData == null) {
                this.mData = new ArrayList<T>();
            }
            this.mData.add(item);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.notifyDataSetChanged();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(List<T> data) {
        Class<EaseBaseRecyclerViewAdapter> clazz = EaseBaseRecyclerViewAdapter.class;
        synchronized (EaseBaseRecyclerViewAdapter.class) {
            if (data == null || data.isEmpty()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.mData == null) {
                this.mData = data;
            } else {
                this.mData.addAll(data);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.notifyDataSetChanged();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(int position, List<T> data) {
        Class<EaseBaseRecyclerViewAdapter> clazz = EaseBaseRecyclerViewAdapter.class;
        synchronized (EaseBaseRecyclerViewAdapter.class) {
            if (data == null || data.isEmpty()) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            if (this.mData == null) {
                this.mData = data;
            } else {
                this.mData.addAll(position, data);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.notifyDataSetChanged();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(int position, List<T> data, boolean refresh) {
        Class<EaseBaseRecyclerViewAdapter> clazz = EaseBaseRecyclerViewAdapter.class;
        synchronized (EaseBaseRecyclerViewAdapter.class) {
            if (data == null || data.isEmpty()) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            if (this.mData == null) {
                this.mData = data;
            } else {
                this.mData.addAll(position, data);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (refresh) {
                this.notifyDataSetChanged();
            }
            return;
        }
    }

    public synchronized List<T> getData() {
        return this.mData;
    }

    public synchronized void clearData() {
        if (this.mData != null) {
            this.mData.clear();
            this.notifyDataSetChanged();
        }
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener longClickListener) {
        this.mOnItemLongClickListener = longClickListener;
    }

    public int getEmptyLayoutId() {
        return R.layout.ease_layout_default_no_data;
    }

    public static abstract class ViewHolder<T>
    extends RecyclerView.ViewHolder {
        private EaseBaseAdapter adapter;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            this.initView(itemView);
        }

        public abstract void initView(View var1);

        public abstract void setData(T var1, int var2);

        public <E extends View> E findViewById(@IdRes int id) {
            return (E)this.itemView.findViewById(id);
        }

        public void setDataList(List<T> data, int position) {
        }

        private void setAdapter(EaseBaseRecyclerViewAdapter adapter) {
            this.adapter = adapter;
        }

        public EaseBaseAdapter getAdapter() {
            return this.adapter;
        }
    }
}

