/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMOptions;
import com.hyphenate.easeui.domain.EaseAvatarOptions;
import com.hyphenate.easeui.manager.EaseChatPresenter;
import com.hyphenate.easeui.manager.EaseConfigsManager;
import com.hyphenate.easeui.model.EaseNotifier;
import com.hyphenate.easeui.provider.EaseConversationInfoProvider;
import com.hyphenate.easeui.provider.EaseEmojiconInfoProvider;
import com.hyphenate.easeui.provider.EaseSettingsProvider;
import com.hyphenate.easeui.provider.EaseUserProfileProvider;
import java.lang.reflect.Method;

public class EaseIM {
    private static final String TAG = EaseIM.class.getSimpleName();
    private static EaseIM instance;
    private EaseSettingsProvider settingsProvider;
    private EaseEmojiconInfoProvider mEmojiconInfoProvider;
    private EaseUserProfileProvider userProvider;
    private EaseConversationInfoProvider conversationInfoProvider;
    private EaseAvatarOptions avatarOptions;
    private Context appContext = null;
    private EaseNotifier notifier = null;
    private boolean sdkInited = false;
    public boolean isVoiceCalling;
    public boolean isVideoCalling;
    private EaseChatPresenter presenter;
    private EaseConfigsManager configsManager;

    private EaseIM() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EaseIM getInstance() {
        if (instance != null) return instance;
        Class<EaseIM> clazz = EaseIM.class;
        synchronized (EaseIM.class) {
            if (instance != null) return instance;
            instance = new EaseIM();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized boolean init(Context context, EMOptions options) {
        if (this.sdkInited) {
            return true;
        }
        this.appContext = context.getApplicationContext();
        if (!this.isMainProcess(this.appContext)) {
            Log.e((String)TAG, (String)"enter the service process!");
            return false;
        }
        if (options == null) {
            options = this.initChatOptions();
        }
        this.configsManager = new EaseConfigsManager(context);
        EMClient.getInstance().init(context, options);
        this.initNotifier();
        this.presenter = new EaseChatPresenter();
        this.presenter.attachApp(this.appContext);
        this.sdkInited = true;
        return true;
    }

    protected EMOptions initChatOptions() {
        Log.d((String)TAG, (String)"init HuanXin Options");
        EMOptions options = new EMOptions();
        options.setAcceptInvitationAlways(false);
        options.setRequireAck(true);
        options.setRequireDeliveryAck(false);
        return options;
    }

    public boolean isMainProcess(Context context) {
        String processName = Build.VERSION.SDK_INT >= 28 ? this.getProcessNameByApplication() : this.getProcessNameByReflection();
        return context.getApplicationInfo().packageName.equals(processName);
    }

    private String getProcessNameByReflection() {
        String processName = null;
        try {
            Method declaredMethod = Class.forName("android.app.ActivityThread", false, Application.class.getClassLoader()).getDeclaredMethod("currentProcessName", new Class[0]);
            declaredMethod.setAccessible(true);
            Object invoke = declaredMethod.invoke(null, new Object[0]);
            if (invoke instanceof String) {
                processName = (String)invoke;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return processName;
    }

    @RequiresApi(api=28)
    private String getProcessNameByApplication() {
        return Application.getProcessName();
    }

    private void initNotifier() {
        this.notifier = new EaseNotifier(this.appContext);
    }

    public void addChatPresenter(EaseChatPresenter presenter) {
        this.presenter = presenter;
        this.presenter.attachApp(this.appContext);
    }

    public EaseChatPresenter getChatPresenter() {
        return this.presenter;
    }

    public EaseConfigsManager getConfigsManager() {
        return this.configsManager;
    }

    public EaseEmojiconInfoProvider getEmojiconInfoProvider() {
        return this.mEmojiconInfoProvider;
    }

    public EaseIM setEmojiconInfoProvider(EaseEmojiconInfoProvider emojiconInfoProvider) {
        this.mEmojiconInfoProvider = emojiconInfoProvider;
        return this;
    }

    public EaseSettingsProvider getSettingsProvider() {
        if (this.settingsProvider == null) {
            this.settingsProvider = this.getDefaultSettingsProvider();
        }
        return this.settingsProvider;
    }

    public EaseIM setSettingsProvider(EaseSettingsProvider settingsProvider) {
        this.settingsProvider = settingsProvider;
        return this;
    }

    public EaseUserProfileProvider getUserProvider() {
        return this.userProvider;
    }

    public EaseNotifier getNotifier() {
        return this.notifier;
    }

    public EaseIM setUserProvider(EaseUserProfileProvider userProvider) {
        this.userProvider = userProvider;
        return this;
    }

    public EaseAvatarOptions getAvatarOptions() {
        return this.avatarOptions;
    }

    public EaseIM setAvatarOptions(EaseAvatarOptions avatarOptions) {
        this.avatarOptions = avatarOptions;
        return this;
    }

    public EaseConversationInfoProvider getConversationInfoProvider() {
        return this.conversationInfoProvider;
    }

    public EaseIM setConversationInfoProvider(EaseConversationInfoProvider provider) {
        this.conversationInfoProvider = provider;
        return this;
    }

    public Context getContext() {
        return this.appContext;
    }

    private EaseSettingsProvider getDefaultSettingsProvider() {
        return new EaseSettingsProvider(){

            @Override
            public boolean isMsgNotifyAllowed(EMMessage message) {
                return false;
            }

            @Override
            public boolean isMsgSoundAllowed(EMMessage message) {
                return false;
            }

            @Override
            public boolean isMsgVibrateAllowed(EMMessage message) {
                return false;
            }

            @Override
            public boolean isSpeakerOpened() {
                return false;
            }
        };
    }
}

