/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.widget.chatrow;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMFileMessageBody;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMVoiceMessageBody;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.utils.EaseVoiceLengthUtils;
import com.hyphenate.easeui.widget.chatrow.EaseChatRowFile;
import com.hyphenate.easeui.widget.chatrow.EaseChatRowVoicePlayer;
import com.hyphenate.util.EMLog;

public class EaseChatRowVoice
extends EaseChatRowFile {
    private static final String TAG = EaseChatRowVoice.class.getSimpleName();
    private ImageView voiceImageView;
    private TextView voiceLengthView;
    private ImageView readStatusView;
    private AnimationDrawable voiceAnimation;

    public EaseChatRowVoice(Context context, boolean isSender) {
        super(context, isSender);
    }

    public EaseChatRowVoice(Context context, EMMessage message, int position, Object adapter) {
        super(context, message, position, adapter);
    }

    @Override
    protected void onInflateView() {
        this.inflater.inflate(!this.showSenderType ? R.layout.ease_row_received_voice : R.layout.ease_row_sent_voice, (ViewGroup)this);
    }

    @Override
    protected void onFindViewById() {
        this.voiceImageView = (ImageView)this.findViewById(R.id.iv_voice);
        this.voiceLengthView = (TextView)this.findViewById(R.id.tv_length);
        this.readStatusView = (ImageView)this.findViewById(R.id.iv_unread_voice);
    }

    @Override
    protected void onSetUpView() {
        EaseChatRowVoicePlayer voicePlayer;
        EMVoiceMessageBody voiceBody = (EMVoiceMessageBody)this.message.getBody();
        int len = voiceBody.getLength();
        int padding = 0;
        if (len > 0) {
            padding = EaseVoiceLengthUtils.getVoiceLength(this.getContext(), len);
            this.voiceLengthView.setText((CharSequence)(voiceBody.getLength() + "\""));
            this.voiceLengthView.setVisibility(0);
        } else {
            this.voiceLengthView.setVisibility(4);
        }
        if (!this.showSenderType) {
            this.voiceImageView.setImageResource(R.drawable.ease_chatfrom_voice_playing);
            this.voiceLengthView.setPadding(padding, 0, 0, 0);
        } else {
            this.voiceImageView.setImageResource(R.drawable.ease_chatto_voice_playing);
            this.voiceLengthView.setPadding(0, 0, padding, 0);
        }
        if (this.message.direct() == EMMessage.Direct.RECEIVE) {
            if (this.readStatusView != null) {
                if (this.message.isListened()) {
                    this.readStatusView.setVisibility(4);
                } else {
                    this.readStatusView.setVisibility(0);
                }
            }
            EMLog.d((String)TAG, (String)"it is receive msg");
            if (this.progressBar != null) {
                if (voiceBody.downloadStatus() == EMFileMessageBody.EMDownloadStatus.DOWNLOADING || voiceBody.downloadStatus() == EMFileMessageBody.EMDownloadStatus.PENDING) {
                    if (EMClient.getInstance().getOptions().getAutodownloadThumbnail()) {
                        this.progressBar.setVisibility(0);
                    } else {
                        this.progressBar.setVisibility(4);
                    }
                } else {
                    this.progressBar.setVisibility(4);
                }
            }
        } else {
            this.readStatusView.setVisibility(4);
        }
        if ((voicePlayer = EaseChatRowVoicePlayer.getInstance(this.getContext())).isPlaying() && this.message.getMsgId().equals(voicePlayer.getCurrentPlayingId())) {
            this.startVoicePlayAnimation();
        }
    }

    @Override
    protected void onViewUpdate(EMMessage msg) {
        super.onViewUpdate(msg);
        if (this.message.direct() == EMMessage.Direct.SEND) {
            return;
        }
        if (this.progressBar != null) {
            EMVoiceMessageBody voiceBody = (EMVoiceMessageBody)msg.getBody();
            if (voiceBody.downloadStatus() == EMFileMessageBody.EMDownloadStatus.DOWNLOADING || voiceBody.downloadStatus() == EMFileMessageBody.EMDownloadStatus.PENDING) {
                this.progressBar.setVisibility(0);
            } else {
                this.progressBar.setVisibility(4);
            }
        }
    }

    public void startVoicePlayAnimation() {
        if (this.message.direct() == EMMessage.Direct.RECEIVE) {
            this.voiceImageView.setImageResource(R.anim.voice_from_icon);
        } else {
            this.voiceImageView.setImageResource(R.anim.voice_to_icon);
        }
        this.voiceAnimation = (AnimationDrawable)this.voiceImageView.getDrawable();
        this.voiceAnimation.start();
        if (this.message.direct() == EMMessage.Direct.RECEIVE) {
            this.readStatusView.setVisibility(4);
        }
    }

    public void stopVoicePlayAnimation() {
        if (this.voiceAnimation != null) {
            this.voiceAnimation.stop();
        }
        if (this.message.direct() == EMMessage.Direct.RECEIVE) {
            this.voiceImageView.setImageResource(R.drawable.ease_chatfrom_voice_playing);
        } else {
            this.voiceImageView.setImageResource(R.drawable.ease_chatto_voice_playing);
        }
    }
}

