/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.widget.chatrow;

import android.content.Context;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.style.URLSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMTextMessageBody;
import com.hyphenate.chat.EMTranslationResult;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.manager.EaseDingMessageHelper;
import com.hyphenate.easeui.utils.EaseSmileUtils;
import com.hyphenate.easeui.widget.EaseChatQuoteView;
import com.hyphenate.easeui.widget.chatrow.AutolinkSpan;
import com.hyphenate.easeui.widget.chatrow.EaseChatRow;
import com.hyphenate.util.EMLog;
import org.json.JSONException;
import org.json.JSONObject;

public class EaseChatRowText
extends EaseChatRow {
    private TextView contentView;
    private TextView translationContentView;
    private ImageView translationStatusView;
    private View translationContainer;
    private EaseChatQuoteView quoteView;
    private EaseDingMessageHelper.IAckUserUpdateListener userUpdateListener = list -> this.onAckUserUpdate(list.size());

    public EaseChatRowText(Context context, boolean isSender) {
        super(context, isSender);
    }

    public EaseChatRowText(Context context, EMMessage message, int position, Object adapter) {
        super(context, message, position, adapter);
    }

    @Override
    protected void onInflateView() {
        this.inflater.inflate(!this.showSenderType ? R.layout.ease_row_received_message : R.layout.ease_row_sent_message, (ViewGroup)this);
    }

    @Override
    protected void onFindViewById() {
        this.contentView = (TextView)this.findViewById(R.id.tv_chatcontent);
        this.translationContentView = (TextView)this.findViewById(R.id.tv_subContent);
        this.translationStatusView = (ImageView)this.findViewById(R.id.translation_status);
        this.translationContainer = this.findViewById(R.id.subBubble);
        this.quoteView = (EaseChatQuoteView)this.findViewById(R.id.chat_quote_view);
    }

    @Override
    public void onSetUpView() {
        EMTextMessageBody txtBody = (EMTextMessageBody)this.message.getBody();
        if (txtBody != null) {
            Spannable span = EaseSmileUtils.getSmiledText(this.context, txtBody.getMessage());
            this.contentView.setText((CharSequence)span, TextView.BufferType.SPANNABLE);
            this.contentView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    EaseChatRowText.this.contentView.setTag(R.id.action_chat_long_click, (Object)true);
                    if (EaseChatRowText.this.itemClickListener != null) {
                        return EaseChatRowText.this.itemClickListener.onBubbleLongClick(v, EaseChatRowText.this.message);
                    }
                    return false;
                }
            });
            this.replaceSpan();
            EMTranslationResult result = EMClient.getInstance().translationManager().getTranslationResult(this.message.getMsgId());
            if (result != null) {
                if (result.showTranslation()) {
                    this.translationContainer.setVisibility(0);
                    this.translationContentView.setText((CharSequence)result.translatedText());
                    this.translationContainer.setOnLongClickListener(new View.OnLongClickListener(){

                        public boolean onLongClick(View v) {
                            EaseChatRowText.this.contentView.setTag(R.id.action_chat_long_click, (Object)true);
                            if (EaseChatRowText.this.itemClickListener != null) {
                                return EaseChatRowText.this.itemClickListener.onBubbleLongClick(v, EaseChatRowText.this.message);
                            }
                            return false;
                        }
                    });
                    this.translationStatusView.setImageResource(R.drawable.translation_success);
                } else {
                    this.translationContainer.setVisibility(8);
                }
            } else {
                this.translationContainer.setVisibility(8);
            }
        }
        this.quoteView.setVisibility(8);
        this.quoteView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (EaseChatRowText.this.itemClickListener == null) {
                    return;
                }
                String msgQuote = EaseChatRowText.this.message.getStringAttribute("msgQuote", "");
                if (!TextUtils.isEmpty((CharSequence)msgQuote)) {
                    try {
                        JSONObject jsonObject = new JSONObject(msgQuote);
                        String quoteMsgID = jsonObject.getString("msgID");
                        EMMessage showMsg = EMClient.getInstance().chatManager().getMessage(quoteMsgID);
                        if (showMsg == null) {
                            EaseChatRowText.this.itemClickListener.onMessageError(null, 1, EaseChatRowText.this.context.getString(R.string.ease_error_message_not_exist));
                            return;
                        }
                        EaseChatRowText.this.itemClickListener.onQuoteViewClick(showMsg);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.quoteView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (EaseChatRowText.this.itemClickListener != null) {
                    return EaseChatRowText.this.itemClickListener.onQuoteViewLongClick(v, EaseChatRowText.this.message);
                }
                return false;
            }
        });
        this.onSetUpQuoteView(this.message);
    }

    private void replaceSpan() {
        Spannable spannable = (Spannable)this.contentView.getText();
        URLSpan[] spans = (URLSpan[])spannable.getSpans(0, spannable.length(), URLSpan.class);
        for (int i = 0; i < spans.length; ++i) {
            String url = spans[i].getURL();
            int index = spannable.toString().indexOf(url);
            int end = index + url.length();
            if (index == -1) {
                if (url.contains("http://")) {
                    url = url.replace("http://", "");
                } else if (url.contains("https://")) {
                    url = url.replace("https://", "");
                } else if (url.contains("rtsp://")) {
                    url = url.replace("rtsp://", "");
                }
                index = spannable.toString().indexOf(url);
                end = index + url.length();
            }
            if (index == -1) continue;
            spannable.removeSpan((Object)spans[i]);
            spannable.setSpan((Object)new AutolinkSpan(spans[i].getURL()), index, end, 18);
        }
    }

    @Override
    protected void onMessageCreate() {
        this.setStatus(0, 8);
    }

    @Override
    protected void onMessageSuccess() {
        this.setStatus(8, 8);
        if (this.isSender() && EaseDingMessageHelper.get().isDingMessage(this.message) && this.ackedView != null) {
            this.ackedView.setVisibility(0);
            int count = this.message.groupAckCount();
            this.ackedView.setText((CharSequence)String.format(this.getContext().getString(R.string.group_ack_read_count), count));
        }
    }

    @Override
    protected void onMessageError() {
        super.onMessageError();
        this.setStatus(8, 0);
    }

    @Override
    protected void onMessageInProgress() {
        this.setStatus(0, 8);
    }

    public void onSetUpQuoteView(EMMessage message) {
        if (this.quoteView == null) {
            EMLog.e((String)TAG, (String)"view is null, don't setup quote view");
            return;
        }
        this.quoteView.setVisibility(8);
        this.quoteView.clear();
        this.quoteView.updateMessageInfo(message);
    }

    private void setStatus(int progressVisible, int statusVisible) {
        if (this.progressBar != null) {
            this.progressBar.setVisibility(progressVisible);
        }
        if (this.statusView != null) {
            this.statusView.setVisibility(statusVisible);
        }
    }

    public void onAckUserUpdate(int count) {
        if (this.ackedView == null) {
            return;
        }
        this.ackedView.post(() -> {
            if (this.isSender()) {
                this.ackedView.setVisibility(0);
                this.ackedView.setText((CharSequence)String.format(this.getContext().getString(R.string.group_ack_read_count), count));
            }
        });
    }
}

