/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.viewholder;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.easeui.adapter.EaseBaseRecyclerViewAdapter;
import com.hyphenate.easeui.interfaces.MessageListItemClickListener;
import com.hyphenate.easeui.widget.chatrow.EaseChatRow;
import java.util.List;

public class EaseChatRowViewHolder
extends EaseBaseRecyclerViewAdapter.ViewHolder<EMMessage>
implements EaseChatRow.EaseChatRowActionCallback {
    private static final String TAG = EaseChatRowViewHolder.class.getSimpleName();
    private Context context;
    private EaseChatRow chatRow;
    private EMMessage message;
    private MessageListItemClickListener mItemClickListener;

    public EaseChatRowViewHolder(@NonNull View itemView, MessageListItemClickListener itemClickListener) {
        super(itemView);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -2);
        itemView.setLayoutParams(params);
        this.context = itemView.getContext();
        this.mItemClickListener = itemClickListener;
    }

    @Override
    public void initView(View itemView) {
        this.chatRow = (EaseChatRow)itemView;
    }

    @Override
    public void setData(EMMessage item, int position) {
        this.chatRow.resetViewState();
        this.message = item;
        this.chatRow.setUpView(item, position, this.mItemClickListener, this);
        this.handleMessage();
    }

    @Override
    public void setDataList(List<EMMessage> data, int position) {
        super.setDataList(data, position);
        this.chatRow.setTimestamp(position == 0 ? null : data.get(position - 1));
    }

    @Override
    public void onResendClick(EMMessage message) {
    }

    @Override
    public void onBubbleClick(EMMessage message) {
    }

    @Override
    public void onDetachedFromWindow() {
    }

    private void handleMessage() {
        if (this.message.direct() == EMMessage.Direct.SEND) {
            this.handleSendMessage(this.message);
        } else if (this.message.direct() == EMMessage.Direct.RECEIVE) {
            this.handleReceiveMessage(this.message);
        }
    }

    protected void handleSendMessage(EMMessage message) {
        this.getChatRow().updateView(message);
    }

    protected void handleReceiveMessage(EMMessage message) {
    }

    public Context getContext() {
        return this.context;
    }

    public EaseChatRow getChatRow() {
        return this.chatRow;
    }
}

