/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.utils;

import android.content.Context;
import android.net.Uri;
import android.text.Spannable;
import android.text.style.ImageSpan;
import com.hyphenate.easeui.EaseIM;
import com.hyphenate.easeui.domain.EaseEmojicon;
import com.hyphenate.easeui.model.EaseDefaultEmojiconDatas;
import com.hyphenate.easeui.provider.EaseEmojiconInfoProvider;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EaseSmileUtils {
    public static final String DELETE_KEY = "em_delete_delete_expression";
    public static final String ee_1 = "[):]";
    public static final String ee_2 = "[:D]";
    public static final String ee_3 = "[;)]";
    public static final String ee_4 = "[:-o]";
    public static final String ee_5 = "[:p]";
    public static final String ee_6 = "[(H)]";
    public static final String ee_7 = "[:@]";
    public static final String ee_8 = "[:s]";
    public static final String ee_9 = "[:$]";
    public static final String ee_10 = "[:(]";
    public static final String ee_11 = "[:'(]";
    public static final String ee_12 = "[:|]";
    public static final String ee_13 = "[(a)]";
    public static final String ee_14 = "[8o|]";
    public static final String ee_15 = "[8-|]";
    public static final String ee_16 = "[+o(]";
    public static final String ee_17 = "[<o)]";
    public static final String ee_18 = "[|-)]";
    public static final String ee_19 = "[*-)]";
    public static final String ee_20 = "[:-#]";
    public static final String ee_21 = "[:-*]";
    public static final String ee_22 = "[^o)]";
    public static final String ee_23 = "[8-)]";
    public static final String ee_24 = "[(|)]";
    public static final String ee_25 = "[(u)]";
    public static final String ee_26 = "[(S)]";
    public static final String ee_27 = "[(*)]";
    public static final String ee_28 = "[(#)]";
    public static final String ee_29 = "[(R)]";
    public static final String ee_30 = "[({)]";
    public static final String ee_31 = "[(})]";
    public static final String ee_32 = "[(k)]";
    public static final String ee_33 = "[(F)]";
    public static final String ee_34 = "[(W)]";
    public static final String ee_35 = "[(D)]";
    public static final String e_1 = "\ud83d\ude0a";
    public static final String e_2 = "\ud83d\ude03";
    public static final String e_3 = "\ud83d\ude09";
    public static final String e_4 = "\ud83d\ude2e";
    public static final String e_5 = "\ud83d\ude0b";
    public static final String e_6 = "\ud83d\ude0e";
    public static final String e_7 = "\ud83d\ude21";
    public static final String e_8 = "\ud83d\ude16";
    public static final String e_9 = "\ud83d\ude33";
    public static final String e_10 = "\ud83d\ude1e";
    public static final String e_11 = "\ud83d\ude2d";
    public static final String e_12 = "\ud83d\ude10";
    public static final String e_13 = "\ud83d\ude07";
    public static final String e_14 = "\ud83d\ude2c";
    public static final String e_15 = "\ud83d\ude06";
    public static final String e_16 = "\ud83d\ude31";
    public static final String e_17 = "\ud83c\udf85";
    public static final String e_18 = "\ud83d\ude34";
    public static final String e_19 = "\ud83d\ude15";
    public static final String e_20 = "\ud83d\ude37";
    public static final String e_21 = "\ud83d\ude2f";
    public static final String e_22 = "\ud83d\ude0f";
    public static final String e_23 = "\ud83d\ude11";
    public static final String e_24 = "\ud83d\udc96";
    public static final String e_25 = "\ud83d\udc94";
    public static final String e_26 = "\ud83c\udf19";
    public static final String e_27 = "\ud83c\udf1f";
    public static final String e_28 = "\ud83c\udf1e";
    public static final String e_29 = "\ud83c\udf08";
    public static final String e_30 = "\ud83d\ude0d";
    public static final String e_31 = "\ud83d\ude1a";
    public static final String e_32 = "\ud83d\udc8b";
    public static final String e_33 = "\ud83c\udf39";
    public static final String e_34 = "\ud83c\udf42";
    public static final String e_35 = "\ud83d\udc4d";
    private static final Spannable.Factory spannableFactory;
    private static final Map<Pattern, Object> emoticons;

    public static void addPattern(String emojiText, Object icon) {
        emoticons.put(Pattern.compile(Pattern.quote(emojiText)), icon);
    }

    public static boolean addSmiles(Context context, Spannable spannable) {
        boolean hasChanges = false;
        for (Map.Entry<Pattern, Object> entry : emoticons.entrySet()) {
            Matcher matcher = entry.getKey().matcher((CharSequence)spannable);
            while (matcher.find()) {
                boolean set = true;
                for (ImageSpan span : (ImageSpan[])spannable.getSpans(matcher.start(), matcher.end(), ImageSpan.class)) {
                    if (spannable.getSpanStart((Object)span) < matcher.start() || spannable.getSpanEnd((Object)span) > matcher.end()) {
                        set = false;
                        break;
                    }
                    spannable.removeSpan((Object)span);
                }
                if (!set) continue;
                hasChanges = true;
                Object value = entry.getValue();
                if (value instanceof String && !((String)value).startsWith("http")) {
                    File file = new File((String)value);
                    if (!file.exists() || file.isDirectory()) {
                        return false;
                    }
                    spannable.setSpan((Object)new ImageSpan(context, Uri.fromFile((File)file)), matcher.start(), matcher.end(), 33);
                    continue;
                }
                spannable.setSpan((Object)new ImageSpan(context, ((Integer)value).intValue()), matcher.start(), matcher.end(), 33);
            }
        }
        return hasChanges;
    }

    public static Spannable getSmiledText(Context context, CharSequence text) {
        Spannable spannable = spannableFactory.newSpannable(text);
        EaseSmileUtils.addSmiles(context, spannable);
        return spannable;
    }

    public static boolean containsKey(String key) {
        boolean b = false;
        for (Map.Entry<Pattern, Object> entry : emoticons.entrySet()) {
            Matcher matcher = entry.getKey().matcher(key);
            if (!matcher.find()) continue;
            b = true;
            break;
        }
        return b;
    }

    public static int getSmilesSize() {
        return emoticons.size();
    }

    static {
        EaseEmojicon[] emojicons;
        spannableFactory = Spannable.Factory.getInstance();
        emoticons = new HashMap<Pattern, Object>();
        for (EaseEmojicon emojicon : emojicons = EaseDefaultEmojiconDatas.getDefaultData()) {
            EaseSmileUtils.addPattern(emojicon.getEmojiText(), emojicon.getIcon());
        }
        EaseEmojiconInfoProvider emojiconInfoProvider = EaseIM.getInstance().getEmojiconInfoProvider();
        if (emojiconInfoProvider != null && emojiconInfoProvider.getTextEmojiconMapping() != null) {
            for (Map.Entry<String, Object> entry : emojiconInfoProvider.getTextEmojiconMapping().entrySet()) {
                EaseSmileUtils.addPattern(entry.getKey(), entry.getValue());
            }
        }
    }
}

