/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import android.widget.ProgressBar;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.utils.EaseImageCache;
import com.hyphenate.easeui.widget.photoview.EasePhotoView;
import com.hyphenate.util.ImageUtils;

public class EaseLoadLocalBigImgTask
extends AsyncTask<Void, Void, Bitmap> {
    private ProgressBar pb;
    private EasePhotoView photoView;
    private String path;
    private int width;
    private int height;
    private Context context;

    public EaseLoadLocalBigImgTask(Context context, String path, EasePhotoView photoView, ProgressBar pb, int width, int height) {
        this.context = context;
        this.path = path;
        this.photoView = photoView;
        this.pb = pb;
        this.width = width;
        this.height = height;
    }

    protected void onPreExecute() {
        super.onPreExecute();
        int degree = ImageUtils.readPictureDegree((String)this.path);
        if (degree != 0) {
            this.pb.setVisibility(0);
            this.photoView.setVisibility(4);
        } else {
            this.pb.setVisibility(4);
            this.photoView.setVisibility(0);
        }
    }

    protected Bitmap doInBackground(Void ... params) {
        Bitmap bitmap = ImageUtils.decodeScaleImage((String)this.path, (int)this.width, (int)this.height);
        return bitmap;
    }

    protected void onPostExecute(Bitmap result) {
        super.onPostExecute((Object)result);
        this.pb.setVisibility(4);
        this.photoView.setVisibility(0);
        if (result != null) {
            EaseImageCache.getInstance().put(this.path, result);
        } else {
            result = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)R.drawable.ease_default_image);
        }
        this.photoView.setImageBitmap(result);
    }
}

