/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.ui;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.Toast;
import androidx.fragment.app.FragmentActivity;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.hyphenate.EMCallBack;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMImageMessageBody;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.easeui.EaseIM;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.domain.EaseEmojicon;
import com.hyphenate.easeui.ui.base.EaseBaseActivity;
import com.hyphenate.easeui.utils.EaseFileUtils;
import com.hyphenate.easeui.widget.photoview.EasePhotoView;
import com.hyphenate.util.EMLog;

public class EaseShowBigImageActivity
extends EaseBaseActivity {
    private static final String TAG = "ShowBigImage";
    private ProgressDialog pd;
    private EasePhotoView image;
    private int default_res = R.drawable.ease_default_image;
    private String filename;
    private Bitmap bitmap;
    private String emojiIconId = "";
    private boolean isDownloaded;

    @Override
    @SuppressLint(value={"NewApi"})
    protected void onCreate(Bundle savedInstanceState) {
        this.setContentView(R.layout.ease_activity_show_big_image);
        super.onCreate(savedInstanceState);
        this.setFitSystemForTheme(true, R.color.black, false);
        this.image = (EasePhotoView)this.findViewById(R.id.image);
        ProgressBar loadLocalPb = (ProgressBar)this.findViewById(R.id.pb_load_local);
        this.default_res = this.getIntent().getIntExtra("default_image", R.drawable.ease_default_avatar);
        Uri uri = (Uri)this.getIntent().getParcelableExtra("uri");
        this.filename = this.getIntent().getExtras().getString("filename");
        String msgId = this.getIntent().getExtras().getString("messageId");
        if (this.getIntent().hasExtra("em_expression_id")) {
            this.emojiIconId = this.getIntent().getExtras().getString("em_expression_id");
        }
        EMLog.d((String)TAG, (String)("show big msgId:" + msgId));
        if (EaseFileUtils.isFileExistByUri((Context)this, uri)) {
            Glide.with((FragmentActivity)this).load(uri).into((ImageView)this.image);
        } else if (!TextUtils.isEmpty((CharSequence)this.emojiIconId)) {
            this.showBigExpression(this.emojiIconId);
        } else if (msgId != null) {
            EMMessage msg = EMClient.getInstance().chatManager().getMessage(msgId);
            if (msg == null && (msg = (EMMessage)this.getIntent().getParcelableExtra("msg")) == null) {
                EMLog.e((String)TAG, (String)("message is null, messageId: " + msgId));
                this.finish();
                return;
            }
            EMImageMessageBody body = (EMImageMessageBody)msg.getBody();
            if (EaseFileUtils.isFileExistByUri((Context)this, body.getLocalUri())) {
                Glide.with((FragmentActivity)this).load(body.getLocalUri()).into((ImageView)this.image);
            } else {
                this.downloadImage(msg);
            }
        } else {
            this.image.setImageResource(this.default_res);
        }
    }

    private void showBigExpression(String emojiIconId) {
        EaseEmojicon emojiIcon = null;
        if (EaseIM.getInstance().getEmojiconInfoProvider() != null && (emojiIcon = EaseIM.getInstance().getEmojiconInfoProvider().getEmojiconInfo(emojiIconId)) != null) {
            if (emojiIcon.getBigIcon() != 0) {
                Glide.with((FragmentActivity)this).load(Integer.valueOf(emojiIcon.getBigIcon())).apply((BaseRequestOptions)RequestOptions.placeholderOf((int)R.drawable.ease_default_expression)).into((ImageView)this.image);
            } else if (emojiIcon.getBigIconPath() != null) {
                Glide.with((FragmentActivity)this).load(emojiIcon.getBigIconPath()).apply((BaseRequestOptions)RequestOptions.placeholderOf((int)R.drawable.ease_default_expression)).into((ImageView)this.image);
            } else {
                this.image.setImageResource(R.drawable.ease_default_expression);
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    private void downloadImage(final EMMessage msg) {
        EMLog.e((String)TAG, (String)("download with messageId: " + msg.getMsgId()));
        String str1 = this.getResources().getString(R.string.Download_the_pictures);
        this.pd = new ProgressDialog((Context)this);
        this.pd.setProgressStyle(0);
        this.pd.setCanceledOnTouchOutside(false);
        this.pd.setMessage((CharSequence)str1);
        this.pd.show();
        EMCallBack callback = new EMCallBack(){

            public void onSuccess() {
                EMLog.e((String)EaseShowBigImageActivity.TAG, (String)"onSuccess");
                EaseShowBigImageActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!EaseShowBigImageActivity.this.isFinishing() && !EaseShowBigImageActivity.this.isDestroyed()) {
                            if (EaseShowBigImageActivity.this.pd != null) {
                                EaseShowBigImageActivity.this.pd.dismiss();
                            }
                            EaseShowBigImageActivity.this.isDownloaded = true;
                            Uri localUrlUri = ((EMImageMessageBody)msg.getBody()).getLocalUri();
                            Glide.with((FragmentActivity)EaseShowBigImageActivity.this).load(localUrlUri).apply(new RequestOptions().error(EaseShowBigImageActivity.this.default_res)).into((ImageView)EaseShowBigImageActivity.this.image);
                        }
                    }
                });
            }

            public void onError(final int error, String message) {
                EMLog.e((String)EaseShowBigImageActivity.TAG, (String)("offline file transfer error:" + message));
                EaseShowBigImageActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (EaseShowBigImageActivity.this.isFinishing() || EaseShowBigImageActivity.this.isDestroyed()) {
                            return;
                        }
                        EaseShowBigImageActivity.this.image.setImageResource(EaseShowBigImageActivity.this.default_res);
                        EaseShowBigImageActivity.this.pd.dismiss();
                        if (error == 400) {
                            Toast.makeText((Context)EaseShowBigImageActivity.this.getApplicationContext(), (int)R.string.Image_expired, (int)0).show();
                        }
                    }
                });
            }

            public void onProgress(final int progress, String status) {
                EMLog.d((String)EaseShowBigImageActivity.TAG, (String)("Progress: " + progress));
                final String str2 = EaseShowBigImageActivity.this.getResources().getString(R.string.Download_the_pictures_new);
                EaseShowBigImageActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (EaseShowBigImageActivity.this.isFinishing() || EaseShowBigImageActivity.this.isDestroyed()) {
                            return;
                        }
                        EaseShowBigImageActivity.this.pd.setMessage((CharSequence)(str2 + progress + "%"));
                    }
                });
            }
        };
        msg.setMessageStatusCallback(callback);
        EMClient.getInstance().chatManager().downloadAttachment(msg);
    }

    public void onBackPressed() {
        if (this.isDownloaded) {
            this.setResult(-1);
        }
        this.finish();
    }
}

