/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules.chat;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMTextMessageBody;
import com.hyphenate.chat.EMVoiceMessageBody;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.domain.EaseUser;
import com.hyphenate.easeui.modules.chat.EaseInputEditText;
import com.hyphenate.easeui.modules.chat.EaseInputMenuStyle;
import com.hyphenate.easeui.modules.chat.interfaces.EaseChatPrimaryMenuListener;
import com.hyphenate.easeui.modules.chat.interfaces.IChatPrimaryMenu;
import com.hyphenate.easeui.utils.EaseSmileUtils;
import com.hyphenate.easeui.utils.EaseUserUtils;

public class EaseChatPrimaryMenu
extends RelativeLayout
implements IChatPrimaryMenu,
View.OnClickListener,
EaseInputEditText.OnEditTextChangeListener,
TextWatcher {
    private LinearLayout rlBottom;
    private ImageView buttonSetModeVoice;
    private ImageView buttonSetModeKeyboard;
    private FrameLayout buttonPressToSpeak;
    private FrameLayout edittext_layout;
    private EaseInputEditText editText;
    private RelativeLayout faceLayout;
    private ImageView faceNormal;
    private ImageView faceChecked;
    private CheckBox buttonMore;
    private Button buttonSend;
    private ConstraintLayout quoteLayout;
    private ImageView cancelSelect;
    private TextView quoteTitle;
    private EaseChatPrimaryMenuListener listener;
    private EaseInputMenuStyle menuType = EaseInputMenuStyle.All;
    protected InputMethodManager inputManager;
    protected Context activity;
    private boolean isShowDefaultQuote = true;

    public EaseChatPrimaryMenu(Context context) {
        this(context, null);
    }

    public EaseChatPrimaryMenu(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EaseChatPrimaryMenu(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.ease_widget_chat_primary_menu, (ViewGroup)this);
        this.activity = context;
        this.inputManager = (InputMethodManager)context.getSystemService("input_method");
        this.initViews();
    }

    private void initViews() {
        this.rlBottom = (LinearLayout)this.findViewById(R.id.rl_bottom);
        this.buttonSetModeVoice = (ImageView)this.findViewById(R.id.btn_set_mode_voice);
        this.buttonSetModeKeyboard = (ImageView)this.findViewById(R.id.btn_set_mode_keyboard);
        this.buttonPressToSpeak = (FrameLayout)this.findViewById(R.id.btn_press_to_speak);
        this.edittext_layout = (FrameLayout)this.findViewById(R.id.edittext_layout);
        this.editText = (EaseInputEditText)this.findViewById(R.id.et_sendmessage);
        this.faceLayout = (RelativeLayout)this.findViewById(R.id.rl_face);
        this.faceNormal = (ImageView)this.findViewById(R.id.iv_face_normal);
        this.faceChecked = (ImageView)this.findViewById(R.id.iv_face_checked);
        this.buttonMore = (CheckBox)this.findViewById(R.id.btn_more);
        this.buttonSend = (Button)this.findViewById(R.id.btn_send);
        this.quoteLayout = (ConstraintLayout)this.findViewById(R.id.quote_layout);
        this.cancelSelect = (ImageView)this.findViewById(R.id.cancel_select);
        this.quoteTitle = (TextView)this.findViewById(R.id.quote_title);
        this.editText.requestFocus();
        this.showNormalStatus();
        this.initListener();
    }

    private void initListener() {
        this.buttonSend.setOnClickListener((View.OnClickListener)this);
        this.buttonSetModeKeyboard.setOnClickListener((View.OnClickListener)this);
        this.buttonSetModeVoice.setOnClickListener((View.OnClickListener)this);
        this.buttonMore.setOnClickListener((View.OnClickListener)this);
        this.faceLayout.setOnClickListener((View.OnClickListener)this);
        this.editText.setOnClickListener(this);
        this.editText.setOnEditTextChangeListener(this);
        this.editText.addTextChangedListener(this);
        this.cancelSelect.setOnClickListener((View.OnClickListener)this);
        this.buttonPressToSpeak.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (EaseChatPrimaryMenu.this.listener != null) {
                    return EaseChatPrimaryMenu.this.listener.onPressToSpeakBtnTouch(v, event);
                }
                return false;
            }
        });
    }

    private void checkSendButton() {
        if (TextUtils.isEmpty((CharSequence)this.editText.getText().toString().trim())) {
            this.buttonMore.setVisibility(0);
            this.buttonSend.setVisibility(8);
        } else {
            this.buttonMore.setVisibility(8);
            this.buttonSend.setVisibility(0);
        }
    }

    @Override
    public ConstraintLayout getQuoteLayout() {
        return this.quoteLayout;
    }

    @Override
    public void setShowDefaultQuote(boolean isShowDefaultQuote) {
        this.isShowDefaultQuote = isShowDefaultQuote;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.editText.removeTextChangedListener(this);
    }

    @Override
    public void setMenuShowType(EaseInputMenuStyle style) {
        this.menuType = style;
        this.checkMenuType();
    }

    @Override
    public void showNormalStatus() {
        this.hideSoftKeyboard();
        this.buttonSetModeVoice.setVisibility(0);
        this.buttonSetModeKeyboard.setVisibility(8);
        this.edittext_layout.setVisibility(0);
        this.buttonPressToSpeak.setVisibility(8);
        this.hideExtendStatus();
        this.checkSendButton();
        this.checkMenuType();
    }

    @Override
    public void showTextStatus() {
        this.buttonSetModeVoice.setVisibility(0);
        this.buttonSetModeKeyboard.setVisibility(8);
        this.edittext_layout.setVisibility(0);
        this.buttonPressToSpeak.setVisibility(8);
        this.hideExtendStatus();
        this.showSoftKeyboard(this.editText);
        this.checkSendButton();
        this.checkMenuType();
        if (this.listener != null) {
            this.listener.onToggleTextBtnClicked();
        }
    }

    @Override
    public void showVoiceStatus() {
        this.hideSoftKeyboard();
        this.buttonSetModeVoice.setVisibility(8);
        this.buttonSetModeKeyboard.setVisibility(0);
        this.edittext_layout.setVisibility(8);
        this.buttonPressToSpeak.setVisibility(0);
        this.hideExtendStatus();
        this.checkMenuType();
        if (this.listener != null) {
            this.listener.onToggleVoiceBtnClicked();
        }
    }

    @Override
    public void showEmojiconStatus() {
        this.buttonSetModeVoice.setVisibility(0);
        this.buttonSetModeKeyboard.setVisibility(8);
        this.edittext_layout.setVisibility(0);
        this.buttonPressToSpeak.setVisibility(8);
        this.buttonMore.setChecked(false);
        if (this.faceNormal.getVisibility() == 0) {
            this.hideSoftKeyboard();
            this.showSelectedFaceImage();
        } else {
            this.showSoftKeyboard(this.editText);
            this.showNormalFaceImage();
        }
        this.checkMenuType();
        if (this.listener != null) {
            this.listener.onToggleEmojiconClicked(this.faceChecked.getVisibility() == 0);
        }
    }

    @Override
    public void showMoreStatus() {
        if (this.buttonMore.isChecked()) {
            this.hideSoftKeyboard();
            this.buttonSetModeVoice.setVisibility(0);
            this.buttonSetModeKeyboard.setVisibility(8);
            this.edittext_layout.setVisibility(0);
            this.buttonPressToSpeak.setVisibility(8);
            this.showNormalFaceImage();
        } else {
            this.showTextStatus();
        }
        this.checkMenuType();
        if (this.listener != null) {
            this.listener.onToggleExtendClicked(this.buttonMore.isChecked());
        }
    }

    @Override
    public void hideExtendStatus() {
        this.buttonMore.setChecked(false);
        this.showNormalFaceImage();
    }

    @Override
    public void onEmojiconInputEvent(CharSequence emojiContent) {
        this.editText.append(emojiContent);
    }

    @Override
    public void onEmojiconDeleteEvent() {
        if (!TextUtils.isEmpty((CharSequence)this.editText.getText())) {
            KeyEvent event = new KeyEvent(0L, 0L, 0, 67, 0, 0, 0, 0, 6);
            this.editText.dispatchKeyEvent(event);
        }
    }

    @Override
    public void onTextInsert(CharSequence text) {
        int start = this.editText.getSelectionStart();
        Editable editable = this.editText.getEditableText();
        editable.insert(start, text);
        this.showTextStatus();
    }

    @Override
    public EditText getEditText() {
        return this.editText;
    }

    @Override
    public void setMenuBackground(Drawable bg) {
        this.rlBottom.setBackground(bg);
    }

    @Override
    public void setSendButtonBackground(Drawable bg) {
        this.buttonSend.setBackground(bg);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btn_send) {
            if (this.listener != null) {
                String s = this.editText.getText().toString();
                this.editText.setText("");
                this.listener.onSendBtnClicked(s);
            }
        } else if (id2 == R.id.btn_set_mode_voice) {
            this.showVoiceStatus();
        } else if (id2 == R.id.btn_set_mode_keyboard) {
            this.showTextStatus();
        } else if (id2 == R.id.btn_more) {
            this.showMoreStatus();
        } else if (id2 == R.id.et_sendmessage) {
            this.showTextStatus();
        } else if (id2 == R.id.rl_face) {
            this.showEmojiconStatus();
        } else if (id2 == R.id.cancel_select) {
            this.cancelQuote();
        }
    }

    private void cancelQuote() {
        this.quoteLayout.setVisibility(8);
        this.quoteTitle.setText((CharSequence)"");
    }

    public void showDefaultQuote(EMMessage message) {
        Spannable span = null;
        EaseUser user = EaseUserUtils.getUserInfo(message.getFrom());
        String from = "";
        from = user == null ? message.getFrom() : (TextUtils.isEmpty((CharSequence)user.getNickname()) ? user.getUsername() : user.getNickname());
        from = EaseUserUtils.getLimitName(from);
        switch (message.getType()) {
            case TXT: {
                if (message.getBooleanAttribute("em_is_big_expression", false)) {
                    span = Spannable.Factory.getInstance().newSpannable((CharSequence)(from + ": " + this.getResources().getString(R.string.quote_emoji)));
                    break;
                }
                EMTextMessageBody textBody = (EMTextMessageBody)message.getBody();
                span = EaseSmileUtils.getSmiledText(this.activity, textBody != null ? from + ": " + textBody.getMessage() : "");
                break;
            }
            case VOICE: {
                EMVoiceMessageBody voiceBody = (EMVoiceMessageBody)message.getBody();
                String voiceContent = from + ": " + this.getResources().getString(R.string.quote_voice) + " " + (voiceBody != null && voiceBody.getLength() > 0 ? voiceBody.getLength() : 0) + "\"";
                span = Spannable.Factory.getInstance().newSpannable((CharSequence)voiceContent);
                break;
            }
            case VIDEO: {
                span = Spannable.Factory.getInstance().newSpannable((CharSequence)(from + ": " + this.getResources().getString(R.string.quote_video)));
                break;
            }
            case FILE: {
                span = Spannable.Factory.getInstance().newSpannable((CharSequence)(from + ": " + this.getResources().getString(R.string.quote_file)));
                break;
            }
            case IMAGE: {
                span = Spannable.Factory.getInstance().newSpannable((CharSequence)(from + ": " + this.getResources().getString(R.string.quote_image)));
                break;
            }
            case LOCATION: {
                span = Spannable.Factory.getInstance().newSpannable((CharSequence)(from + ": " + this.getResources().getString(R.string.quote_location)));
                break;
            }
            case CUSTOM: {
                span = Spannable.Factory.getInstance().newSpannable((CharSequence)(from + ": " + this.getResources().getString(R.string.quote_card)));
                break;
            }
        }
        SpannableString spannableString = new SpannableString(span);
        this.quoteTitle.setText((CharSequence)spannableString);
        this.quoteTitle.setEllipsize(TextUtils.TruncateAt.END);
        this.quoteTitle.setMaxLines(1);
        this.quoteLayout.setVisibility(0);
    }

    @Override
    public void onClickKeyboardSendBtn(String content) {
        if (this.listener != null) {
            this.listener.onSendBtnClicked(content);
        }
    }

    @Override
    public void onEditTextHasFocus(boolean hasFocus) {
        if (this.listener != null) {
            this.listener.onEditTextHasFocus(hasFocus);
        }
    }

    private void checkMenuType() {
        if (this.menuType == EaseInputMenuStyle.DISABLE_VOICE) {
            this.buttonSetModeVoice.setVisibility(8);
            this.buttonSetModeKeyboard.setVisibility(8);
            this.buttonPressToSpeak.setVisibility(8);
        } else if (this.menuType == EaseInputMenuStyle.DISABLE_EMOJICON) {
            this.faceLayout.setVisibility(8);
        } else if (this.menuType == EaseInputMenuStyle.DISABLE_VOICE_EMOJICON) {
            this.buttonSetModeVoice.setVisibility(8);
            this.buttonSetModeKeyboard.setVisibility(8);
            this.buttonPressToSpeak.setVisibility(8);
            this.faceLayout.setVisibility(8);
        } else if (this.menuType == EaseInputMenuStyle.ONLY_TEXT) {
            this.buttonSetModeVoice.setVisibility(8);
            this.buttonSetModeKeyboard.setVisibility(8);
            this.buttonPressToSpeak.setVisibility(8);
            this.faceLayout.setVisibility(8);
            this.buttonMore.setVisibility(8);
        }
    }

    private void showSendButton(CharSequence s) {
        if (!TextUtils.isEmpty((CharSequence)s)) {
            this.buttonMore.setVisibility(8);
            this.buttonSend.setVisibility(0);
        } else {
            this.buttonMore.setVisibility(0);
            this.buttonSend.setVisibility(8);
        }
        this.checkMenuType();
    }

    private void showNormalFaceImage() {
        this.faceNormal.setVisibility(0);
        this.faceChecked.setVisibility(4);
    }

    private void showSelectedFaceImage() {
        this.faceNormal.setVisibility(4);
        this.faceChecked.setVisibility(0);
    }

    @Override
    public void hideSoftKeyboard() {
        if (this.editText == null) {
            return;
        }
        this.editText.requestFocus();
        if (this.activity instanceof Activity && ((Activity)this.activity).getWindow().getAttributes().softInputMode != 2 && ((Activity)this.activity).getCurrentFocus() != null) {
            this.inputManager.hideSoftInputFromWindow(((Activity)this.activity).getCurrentFocus().getWindowToken(), 2);
        }
    }

    private void showSoftKeyboard(EditText et) {
        if (et == null) {
            return;
        }
        et.requestFocus();
        this.inputManager.showSoftInput((View)et, 1);
    }

    @Override
    public void setEaseChatPrimaryMenuListener(EaseChatPrimaryMenuListener listener) {
        this.listener = listener;
    }

    @Override
    public void primaryStartQuote(EMMessage message) {
        if (this.isShowDefaultQuote) {
            this.showTextStatus();
            this.showDefaultQuote(message);
            this.quoteLayout.postDelayed(() -> this.showSoftKeyboard(this.editText), 100L);
        } else if (this.listener != null) {
            this.listener.showCustomQuote(message);
        }
    }

    @Override
    public void hideQuoteSelect() {
        this.cancelQuote();
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        Log.e((String)"TAG", (String)(this.getClass().getSimpleName() + " onTextChanged s:" + s));
        this.showSendButton(s);
        if (this.listener != null) {
            this.listener.onTyping(s, start, before, count);
        }
    }

    public void afterTextChanged(Editable s) {
        Log.e((String)"TAG", (String)(this.getClass().getSimpleName() + " afterTextChanged s:" + s));
    }
}

