/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules.chat;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleObserver;
import androidx.recyclerview.widget.ConcatAdapter;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.hyphenate.EMCallBack;
import com.hyphenate.chat.EMChatRoom;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMConversation;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.adapter.EaseMessageAdapter;
import com.hyphenate.easeui.interfaces.MessageListItemClickListener;
import com.hyphenate.easeui.interfaces.OnItemClickListener;
import com.hyphenate.easeui.manager.EaseMessageTypeSetManager;
import com.hyphenate.easeui.manager.EaseThreadManager;
import com.hyphenate.easeui.modules.chat.interfaces.IChatMessageItemSet;
import com.hyphenate.easeui.modules.chat.interfaces.IChatMessageListLayout;
import com.hyphenate.easeui.modules.chat.interfaces.IRecyclerViewHandle;
import com.hyphenate.easeui.modules.chat.model.EaseChatItemStyleHelper;
import com.hyphenate.easeui.modules.chat.presenter.EaseChatMessagePresenter;
import com.hyphenate.easeui.modules.chat.presenter.EaseChatMessagePresenterImpl;
import com.hyphenate.easeui.modules.chat.presenter.IChatMessageListView;
import com.hyphenate.easeui.utils.EaseCommonUtils;
import com.hyphenate.util.EMLog;
import java.util.List;

public class EaseChatMessageListLayout
extends RelativeLayout
implements IChatMessageListView,
IRecyclerViewHandle,
IChatMessageItemSet,
IChatMessageListLayout {
    private static final int DEFAULT_PAGE_SIZE = 10;
    private static final String TAG = EaseChatMessageListLayout.class.getSimpleName();
    private EaseChatMessagePresenter presenter;
    private EaseMessageAdapter messageAdapter;
    private ConcatAdapter baseAdapter;
    private LoadDataType loadDataType;
    private String msgId;
    private int pageSize = 10;
    private RecyclerView rvList;
    private SwipeRefreshLayout srlRefresh;
    private LinearLayoutManager layoutManager;
    private EMConversation conversation;
    private EMConversation.EMConversationType conType;
    private String username;
    private boolean canUseRefresh = true;
    private LoadMoreStatus loadMoreStatus;
    private OnMessageTouchListener messageTouchListener;
    private OnChatErrorListener errorListener;
    private int recyclerViewLastHeight;
    private MessageListItemClickListener messageListItemClickListener;
    private EaseChatItemStyleHelper chatSetHelper;

    public EaseChatMessageListLayout(@NonNull Context context) {
        this(context, null);
    }

    public EaseChatMessageListLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EaseChatMessageListLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.ease_chat_message_list, (ViewGroup)this);
        EaseChatItemStyleHelper.getInstance().clear();
        this.chatSetHelper = EaseChatItemStyleHelper.getInstance();
        this.presenter = new EaseChatMessagePresenterImpl();
        if (context instanceof AppCompatActivity) {
            ((AppCompatActivity)context).getLifecycle().addObserver((LifecycleObserver)this.presenter);
        }
        this.initAttrs(context, attrs);
        this.initViews();
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.EaseChatMessageListLayout);
            float textSize = a.getDimension(R.styleable.EaseChatMessageListLayout_ease_chat_item_text_size, 0.0f);
            this.chatSetHelper.setTextSize((int)textSize);
            int textColorRes = a.getResourceId(R.styleable.EaseChatMessageListLayout_ease_chat_item_text_color, -1);
            int textColor = textColorRes != -1 ? ContextCompat.getColor((Context)context, (int)textColorRes) : a.getColor(R.styleable.EaseChatMessageListLayout_ease_chat_item_text_color, 0);
            this.chatSetHelper.setTextColor(textColor);
            float itemMinHeight = a.getDimension(R.styleable.EaseChatMessageListLayout_ease_chat_item_min_height, 0.0f);
            this.chatSetHelper.setItemMinHeight((int)itemMinHeight);
            float timeTextSize = a.getDimension(R.styleable.EaseChatMessageListLayout_ease_chat_item_time_text_size, 0.0f);
            this.chatSetHelper.setTimeTextSize((int)timeTextSize);
            int timeTextColorRes = a.getResourceId(R.styleable.EaseChatMessageListLayout_ease_chat_item_time_text_color, -1);
            int timeTextColor = timeTextColorRes != -1 ? ContextCompat.getColor((Context)context, (int)textColorRes) : a.getColor(R.styleable.EaseChatMessageListLayout_ease_chat_item_time_text_color, 0);
            this.chatSetHelper.setTimeTextColor(timeTextColor);
            this.chatSetHelper.setTimeBgDrawable(a.getDrawable(R.styleable.EaseChatMessageListLayout_ease_chat_item_time_background));
            Drawable avatarDefaultDrawable = a.getDrawable(R.styleable.EaseChatMessageListLayout_ease_chat_item_avatar_default_src);
            int shapeType = a.getInteger(R.styleable.EaseChatMessageListLayout_ease_chat_item_avatar_shape_type, 0);
            this.chatSetHelper.setAvatarDefaultSrc(avatarDefaultDrawable);
            this.chatSetHelper.setShapeType(shapeType);
            this.chatSetHelper.setReceiverBgDrawable(a.getDrawable(R.styleable.EaseChatMessageListLayout_ease_chat_item_receiver_background));
            this.chatSetHelper.setSenderBgDrawable(a.getDrawable(R.styleable.EaseChatMessageListLayout_ease_chat_item_sender_background));
            this.chatSetHelper.setShowNickname(a.getBoolean(R.styleable.EaseChatMessageListLayout_ease_chat_item_show_nickname, false));
            this.chatSetHelper.setItemShowType(a.getInteger(R.styleable.EaseChatMessageListLayout_ease_chat_item_show_type, 0));
            a.recycle();
        }
    }

    private void initViews() {
        this.presenter.attachView(this);
        this.rvList = (RecyclerView)this.findViewById(R.id.message_list);
        this.srlRefresh = (SwipeRefreshLayout)this.findViewById(R.id.srl_refresh);
        this.srlRefresh.setEnabled(this.canUseRefresh);
        this.layoutManager = new LinearLayoutManager(this.getContext());
        this.rvList.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.baseAdapter = new ConcatAdapter(new RecyclerView.Adapter[0]);
        this.messageAdapter = new EaseMessageAdapter();
        this.baseAdapter.addAdapter((RecyclerView.Adapter)this.messageAdapter);
        this.rvList.setAdapter((RecyclerView.Adapter)this.baseAdapter);
        this.registerChatType();
        this.initListener();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.conversation != null) {
            this.conversation.markAllMessagesAsRead();
        }
        EaseChatItemStyleHelper.getInstance().clear();
        EaseMessageTypeSetManager.getInstance().release();
    }

    private void registerChatType() {
        try {
            EaseMessageTypeSetManager.getInstance().registerMessageType(this.messageAdapter);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void init(LoadDataType loadDataType, String username, int chatType) {
        this.username = username;
        this.loadDataType = loadDataType;
        this.conType = EaseCommonUtils.getConversationType(chatType);
        this.conversation = EMClient.getInstance().chatManager().getConversation(username, this.conType, true);
        this.presenter.setupWithConversation(this.conversation);
    }

    public void init(String username, int chatType) {
        this.init(LoadDataType.LOCAL, username, chatType);
    }

    public void loadDefaultData() {
        this.loadData(this.pageSize, null);
    }

    public void loadData(String msgId) {
        this.loadData(this.pageSize, msgId);
    }

    public void loadData(int pageSize, String msgId) {
        this.pageSize = pageSize;
        this.msgId = msgId;
        this.checkConType();
    }

    private void checkConType() {
        if (this.isChatRoomCon()) {
            this.presenter.joinChatRoom(this.username);
        } else {
            this.loadData();
        }
    }

    private void loadData() {
        if (!this.isSingleChat()) {
            this.chatSetHelper.setShowNickname(true);
        }
        this.conversation.markAllMessagesAsRead();
        if (this.loadDataType == LoadDataType.ROAM) {
            this.presenter.loadServerMessages(this.pageSize);
        } else if (this.loadDataType == LoadDataType.HISTORY) {
            this.presenter.loadMoreLocalHistoryMessages(this.msgId, this.pageSize, EMConversation.EMSearchDirection.DOWN);
        } else {
            this.presenter.loadLocalMessages(this.pageSize);
        }
    }

    public void loadMorePreviousData() {
        String msgId = this.getListFirstMessageId();
        if (this.loadDataType == LoadDataType.ROAM) {
            this.presenter.loadMoreServerMessages(msgId, this.pageSize);
        } else if (this.loadDataType == LoadDataType.HISTORY) {
            this.presenter.loadMoreLocalHistoryMessages(msgId, this.pageSize, EMConversation.EMSearchDirection.UP);
        } else {
            this.presenter.loadMoreLocalMessages(msgId, this.pageSize, true);
        }
    }

    public void loadMorePreviousData(int pageSize, EMCallBack callBack) {
        this.pageSize = pageSize;
        String msgId = this.getListFirstMessageId();
        this.presenter.loadMoreLocalMessages(msgId, pageSize, false, callBack);
    }

    public void loadMoreHistoryData() {
        String msgId = this.getListLastMessageId();
        if (this.loadDataType == LoadDataType.HISTORY) {
            this.loadMoreStatus = LoadMoreStatus.HAS_MORE;
            this.presenter.loadMoreLocalHistoryMessages(msgId, this.pageSize, EMConversation.EMSearchDirection.DOWN);
        }
    }

    private String getListFirstMessageId() {
        EMMessage message = null;
        try {
            message = (EMMessage)this.messageAdapter.getData().get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message == null ? null : message.getMsgId();
    }

    private String getListLastMessageId() {
        EMMessage message = null;
        try {
            message = (EMMessage)this.messageAdapter.getData().get(this.messageAdapter.getData().size() - 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message == null ? null : message.getMsgId();
    }

    public boolean isChatRoomCon() {
        return this.conType == EMConversation.EMConversationType.ChatRoom;
    }

    public boolean isGroupChat() {
        return this.conType == EMConversation.EMConversationType.GroupChat;
    }

    private boolean isSingleChat() {
        return this.conType == EMConversation.EMConversationType.Chat;
    }

    private void initListener() {
        this.srlRefresh.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                EaseChatMessageListLayout.this.loadMorePreviousData();
            }
        });
        this.rvList.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                if (newState == 0) {
                    if (EaseChatMessageListLayout.this.loadDataType == LoadDataType.HISTORY && EaseChatMessageListLayout.this.loadMoreStatus == LoadMoreStatus.HAS_MORE && EaseChatMessageListLayout.this.layoutManager.findLastVisibleItemPosition() != 0 && EaseChatMessageListLayout.this.layoutManager.findLastVisibleItemPosition() == EaseChatMessageListLayout.this.layoutManager.getItemCount() - 1) {
                        EaseChatMessageListLayout.this.loadMoreHistoryData();
                    }
                } else if (EaseChatMessageListLayout.this.messageTouchListener != null) {
                    EaseChatMessageListLayout.this.messageTouchListener.onViewDragging();
                }
            }
        });
        this.rvList.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                int height = EaseChatMessageListLayout.this.rvList.getHeight();
                if (EaseChatMessageListLayout.this.recyclerViewLastHeight == 0) {
                    EaseChatMessageListLayout.this.recyclerViewLastHeight = height;
                }
                if (EaseChatMessageListLayout.this.recyclerViewLastHeight != height && EaseChatMessageListLayout.this.messageAdapter.getData() != null && !EaseChatMessageListLayout.this.messageAdapter.getData().isEmpty()) {
                    EaseChatMessageListLayout.this.post(() -> EaseChatMessageListLayout.this.smoothSeekToPosition(EaseChatMessageListLayout.this.messageAdapter.getData().size() - 1));
                }
                EaseChatMessageListLayout.this.recyclerViewLastHeight = height;
            }
        });
        this.messageAdapter.setOnItemClickListener(new OnItemClickListener(){

            @Override
            public void onItemClick(View view, int position) {
                if (EaseChatMessageListLayout.this.messageTouchListener != null) {
                    EaseChatMessageListLayout.this.messageTouchListener.onTouchItemOutside(view, position);
                }
            }
        });
        this.messageAdapter.setListItemClickListener(new MessageListItemClickListener(){

            @Override
            public boolean onBubbleClick(EMMessage message) {
                if (EaseChatMessageListLayout.this.messageListItemClickListener != null) {
                    return EaseChatMessageListLayout.this.messageListItemClickListener.onBubbleClick(message);
                }
                return false;
            }

            @Override
            public boolean onResendClick(EMMessage message) {
                if (EaseChatMessageListLayout.this.messageListItemClickListener != null) {
                    return EaseChatMessageListLayout.this.messageListItemClickListener.onResendClick(message);
                }
                return false;
            }

            @Override
            public boolean onBubbleLongClick(View v, EMMessage message) {
                if (EaseChatMessageListLayout.this.messageListItemClickListener != null) {
                    return EaseChatMessageListLayout.this.messageListItemClickListener.onBubbleLongClick(v, message);
                }
                return false;
            }

            @Override
            public void onQuoteViewClick(EMMessage message) {
                EMLog.e((String)"apex", (String)("onQuoteViewClick1: " + message));
                if (EaseChatMessageListLayout.this.messageListItemClickListener != null) {
                    EaseChatMessageListLayout.this.messageListItemClickListener.onQuoteViewClick(message);
                }
            }

            @Override
            public boolean onQuoteViewLongClick(View v, EMMessage message) {
                if (EaseChatMessageListLayout.this.messageListItemClickListener != null) {
                    return EaseChatMessageListLayout.this.messageListItemClickListener.onQuoteViewLongClick(v, message);
                }
                return false;
            }

            @Override
            public void onUserAvatarClick(String username) {
                if (EaseChatMessageListLayout.this.messageListItemClickListener != null) {
                    EaseChatMessageListLayout.this.messageListItemClickListener.onUserAvatarClick(username);
                }
            }

            @Override
            public void onUserAvatarLongClick(String username) {
                if (EaseChatMessageListLayout.this.messageListItemClickListener != null) {
                    EaseChatMessageListLayout.this.messageListItemClickListener.onUserAvatarLongClick(username);
                }
            }

            @Override
            public void onMessageCreate(EMMessage message) {
                if (EaseChatMessageListLayout.this.messageListItemClickListener != null) {
                    EaseChatMessageListLayout.this.messageListItemClickListener.onMessageCreate(message);
                }
            }

            @Override
            public void onMessageSuccess(EMMessage message) {
                if (EaseChatMessageListLayout.this.messageListItemClickListener != null) {
                    EaseChatMessageListLayout.this.messageListItemClickListener.onMessageSuccess(message);
                }
            }

            @Override
            public void onMessageError(EMMessage message, int code, String error) {
                if (EaseChatMessageListLayout.this.messageListItemClickListener != null) {
                    EaseChatMessageListLayout.this.messageListItemClickListener.onMessageError(message, code, error);
                }
            }

            @Override
            public void onMessageInProgress(EMMessage message, int progress) {
                if (EaseChatMessageListLayout.this.messageListItemClickListener != null) {
                    EaseChatMessageListLayout.this.messageListItemClickListener.onMessageInProgress(message, progress);
                }
            }
        });
    }

    private void finishRefresh() {
        if (this.presenter.isActive()) {
            this.runOnUi(() -> {
                if (this.srlRefresh != null) {
                    this.srlRefresh.setRefreshing(false);
                }
            });
        }
    }

    private void notifyDataSetChanged() {
        this.messageAdapter.notifyDataSetChanged();
    }

    public void setData(List<EMMessage> data) {
        this.messageAdapter.setData(data);
    }

    public void addData(List<EMMessage> data) {
        this.messageAdapter.addData(data);
    }

    @Override
    public Context context() {
        return this.getContext();
    }

    @Override
    public EMConversation getCurrentConversation() {
        return this.conversation;
    }

    @Override
    public void joinChatRoomSuccess(EMChatRoom value) {
        this.loadData();
    }

    @Override
    public void joinChatRoomFail(int error, String errorMsg) {
        if (this.presenter.isActive()) {
            this.runOnUi(() -> {
                if (this.errorListener != null) {
                    this.errorListener.onChatError(error, errorMsg);
                }
            });
        }
    }

    @Override
    public void loadMsgFail(int error, String message) {
        this.finishRefresh();
        if (this.errorListener != null) {
            this.errorListener.onChatError(error, message);
        }
    }

    @Override
    public void loadLocalMsgSuccess(List<EMMessage> data) {
        this.refreshToLatest();
    }

    @Override
    public void loadNoLocalMsg() {
    }

    @Override
    public void loadMoreLocalMsgSuccess(List<EMMessage> data, boolean isJumpFirst) {
        this.finishRefresh();
        this.presenter.refreshCurrentConversation();
        if (isJumpFirst) {
            this.post(() -> this.smoothSeekToPosition(data.size() - 1));
        }
    }

    @Override
    public void loadNoMoreLocalMsg() {
        this.finishRefresh();
    }

    @Override
    public void loadMoreLocalHistoryMsgSuccess(List<EMMessage> data, EMConversation.EMSearchDirection direction) {
        if (direction == EMConversation.EMSearchDirection.UP) {
            this.finishRefresh();
            this.messageAdapter.addData(0, data);
        } else {
            this.messageAdapter.addData(data);
            this.loadMoreStatus = data.size() >= this.pageSize ? LoadMoreStatus.HAS_MORE : LoadMoreStatus.NO_MORE_DATA;
        }
    }

    @Override
    public void loadNoMoreLocalHistoryMsg() {
        this.finishRefresh();
    }

    @Override
    public void loadServerMsgSuccess(List<EMMessage> data) {
        this.presenter.refreshToLatest();
    }

    @Override
    public void loadMoreServerMsgSuccess(List<EMMessage> data) {
        this.finishRefresh();
        this.presenter.refreshCurrentConversation();
        this.post(() -> this.smoothSeekToPosition(data.size() - 1));
    }

    @Override
    public void refreshCurrentConSuccess(List<EMMessage> data, boolean toLatest) {
        this.messageAdapter.setData(data);
        if (toLatest) {
            this.seekToPosition(data.size() - 1);
        }
    }

    @Override
    public void canUseDefaultRefresh(boolean canUseRefresh) {
        this.canUseRefresh = canUseRefresh;
        this.srlRefresh.setEnabled(canUseRefresh);
    }

    @Override
    public void refreshMessages() {
        this.presenter.refreshCurrentConversation();
    }

    @Override
    public void refreshToLatest() {
        this.presenter.refreshToLatest();
    }

    @Override
    public void refreshMessage(EMMessage message) {
        int position = this.messageAdapter.getData().lastIndexOf(message);
        if (position != -1) {
            this.runOnUi(() -> this.messageAdapter.notifyItemChanged(position));
        }
    }

    @Override
    public void removeMessage(EMMessage message) {
        if (message == null || this.messageAdapter.getData() == null) {
            return;
        }
        this.conversation.removeMessage(message.getMsgId());
        EMClient.getInstance().translationManager().removeTranslationResult(message.getMsgId());
        this.runOnUi(() -> {
            List messages;
            int position;
            if (this.presenter.isActive() && (position = (messages = this.messageAdapter.getData()).lastIndexOf(message)) != -1) {
                messages.remove(position);
                this.messageAdapter.notifyItemRemoved(position);
                this.messageAdapter.notifyItemChanged(position);
            }
        });
    }

    @Override
    public void moveToPosition(int position) {
        this.seekToPosition(position);
    }

    @Override
    public void lastMsgScrollToBottom(EMMessage message) {
        List messages = this.messageAdapter.getData();
        int position = messages.lastIndexOf(message);
        if (position != -1) {
            this.messageAdapter.notifyItemChanged(position);
            boolean isNoBottom = this.rvList.canScrollVertically(1);
            if (!isNoBottom) {
                View oldView = this.rvList.getLayoutManager().findViewByPosition(this.messageAdapter.getItemCount() - 1);
                int oldHeight = 0;
                if (oldView != null) {
                    oldHeight = oldView.getMeasuredHeight();
                }
                final int finalOldHeight = oldHeight;
                this.rvList.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        View v = EaseChatMessageListLayout.this.rvList.getLayoutManager().findViewByPosition(EaseChatMessageListLayout.this.messageAdapter.getItemCount() - 1);
                        int height = 0;
                        if (v != null) {
                            height = v.getMeasuredHeight();
                        }
                        EaseChatMessageListLayout.this.rvList.smoothScrollBy(0, height - finalOldHeight);
                    }
                }, 500L);
            }
        }
    }

    @Override
    public void highlightItem(int position) {
        this.runOnUi(() -> {
            if (this.messageAdapter != null) {
                this.messageAdapter.highlightItem(position);
            }
        });
    }

    @Override
    public void showNickname(boolean showNickname) {
        this.chatSetHelper.setShowNickname(showNickname);
        this.notifyDataSetChanged();
    }

    @Override
    public void setItemSenderBackground(Drawable bgDrawable) {
        this.chatSetHelper.setSenderBgDrawable(bgDrawable);
        this.notifyDataSetChanged();
    }

    @Override
    public void setItemReceiverBackground(Drawable bgDrawable) {
        this.chatSetHelper.setReceiverBgDrawable(bgDrawable);
        this.notifyDataSetChanged();
    }

    @Override
    public void setItemTextSize(int textSize) {
        this.chatSetHelper.setTextSize(textSize);
        this.notifyDataSetChanged();
    }

    @Override
    public void setItemTextColor(int textColor) {
        this.chatSetHelper.setTextColor(textColor);
        this.notifyDataSetChanged();
    }

    @Override
    public void setTimeTextSize(int textSize) {
        this.chatSetHelper.setTimeTextSize(textSize);
        this.notifyDataSetChanged();
    }

    @Override
    public void setTimeTextColor(int textColor) {
        this.chatSetHelper.setTimeTextColor(textColor);
        this.notifyDataSetChanged();
    }

    @Override
    public void setTimeBackground(Drawable bgDrawable) {
        this.chatSetHelper.setTimeBgDrawable(bgDrawable);
        this.notifyDataSetChanged();
    }

    @Override
    public void setItemShowType(ShowType type) {
        if (!this.isSingleChat()) {
            this.chatSetHelper.setItemShowType(type.ordinal());
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void setAvatarDefaultSrc(Drawable src) {
        this.chatSetHelper.setAvatarDefaultSrc(src);
        this.notifyDataSetChanged();
    }

    @Override
    public void setAvatarShapeType(int shapeType) {
        this.chatSetHelper.setShapeType(shapeType);
        this.notifyDataSetChanged();
    }

    @Override
    public void addHeaderAdapter(RecyclerView.Adapter adapter) {
        this.baseAdapter.addAdapter(0, adapter);
    }

    @Override
    public void addFooterAdapter(RecyclerView.Adapter adapter) {
        this.baseAdapter.addAdapter(adapter);
    }

    @Override
    public void removeAdapter(RecyclerView.Adapter adapter) {
        this.baseAdapter.removeAdapter(adapter);
    }

    @Override
    public void addRVItemDecoration(@NonNull RecyclerView.ItemDecoration decor) {
        this.rvList.addItemDecoration(decor);
    }

    @Override
    public void removeRVItemDecoration(@NonNull RecyclerView.ItemDecoration decor) {
        this.rvList.removeItemDecoration(decor);
    }

    public boolean haveNewMessages() {
        if (this.messageAdapter == null || this.messageAdapter.getData() == null || this.messageAdapter.getData().isEmpty() || this.conversation == null || this.conversation.getLastMessage() == null) {
            return false;
        }
        return this.conversation.getLastMessage().getMsgTime() > ((EMMessage)this.messageAdapter.getData().get(this.messageAdapter.getData().size() - 1)).getMsgTime();
    }

    private void seekToPosition(int position) {
        RecyclerView.LayoutManager manager;
        if (this.presenter.isDestroy() || this.rvList == null) {
            return;
        }
        if (position < 0) {
            position = 0;
        }
        if ((manager = this.rvList.getLayoutManager()) instanceof LinearLayoutManager) {
            ((LinearLayoutManager)manager).scrollToPositionWithOffset(position, 0);
        }
    }

    private void smoothSeekToPosition(int position) {
        RecyclerView.LayoutManager manager;
        if (this.presenter.isDestroy() || this.rvList == null) {
            return;
        }
        if (position < 0) {
            position = 0;
        }
        if ((manager = this.rvList.getLayoutManager()) instanceof LinearLayoutManager) {
            ((LinearLayoutManager)manager).scrollToPositionWithOffset(position, 0);
        }
    }

    private void setMoveAnimation(final RecyclerView.LayoutManager manager, int position) {
        final int prePosition = position > 0 ? position - 1 : position;
        View view = manager.findViewByPosition(0);
        int height = view != null ? view.getHeight() : 200;
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{-height, 0});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int value = (Integer)animation.getAnimatedValue();
                ((LinearLayoutManager)manager).scrollToPositionWithOffset(prePosition, value);
            }
        });
        animator.setDuration(800L);
        animator.start();
    }

    @Override
    public void setPresenter(EaseChatMessagePresenter presenter) {
        this.presenter = presenter;
        if (this.getContext() instanceof AppCompatActivity) {
            ((AppCompatActivity)this.getContext()).getLifecycle().addObserver((LifecycleObserver)presenter);
        }
        this.presenter.attachView(this);
        this.presenter.setupWithConversation(this.conversation);
    }

    @Override
    public EaseMessageAdapter getMessageAdapter() {
        return this.messageAdapter;
    }

    @Override
    public RecyclerView getListView() {
        return this.rvList;
    }

    @Override
    public void setOnMessageTouchListener(OnMessageTouchListener listener) {
        this.messageTouchListener = listener;
    }

    @Override
    public void setOnChatErrorListener(OnChatErrorListener listener) {
        this.errorListener = listener;
    }

    @Override
    public void setMessageListItemClickListener(MessageListItemClickListener listener) {
        this.messageListItemClickListener = listener;
    }

    public static boolean isVisibleBottom(RecyclerView recyclerView) {
        LinearLayoutManager layoutManager = (LinearLayoutManager)recyclerView.getLayoutManager();
        int lastVisibleItemPosition = layoutManager.findLastVisibleItemPosition();
        int visibleItemCount = layoutManager.getChildCount();
        int totalItemCount = layoutManager.getItemCount();
        int state = recyclerView.getScrollState();
        if (visibleItemCount > 0 && lastVisibleItemPosition == totalItemCount - 1) {
            if (state == 0) {
                return true;
            }
        }
        return false;
    }

    public void runOnUi(Runnable runnable) {
        EaseThreadManager.getInstance().runOnMainThread(runnable);
    }

    public static enum ShowType {
        NORMAL,
        LEFT;

    }

    public static enum LoadMoreStatus {
        IS_LOADING,
        HAS_MORE,
        NO_MORE_DATA;

    }

    public static enum LoadDataType {
        LOCAL,
        ROAM,
        HISTORY;

    }

    public static interface OnChatErrorListener {
        public void onChatError(int var1, String var2);
    }

    public static interface OnMessageTouchListener {
        public void onTouchItemOutside(View var1, int var2);

        public void onViewDragging();
    }
}

