/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules.chat;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.ConcatAdapter;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.RecyclerView;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.adapter.EaseChatExtendMenuAdapter;
import com.hyphenate.easeui.adapter.EaseChatExtendMenuIndicatorAdapter;
import com.hyphenate.easeui.interfaces.OnItemClickListener;
import com.hyphenate.easeui.modules.chat.interfaces.EaseChatExtendMenuItemClickListener;
import com.hyphenate.easeui.modules.chat.interfaces.IChatExtendMenu;
import com.hyphenate.easeui.widget.chatextend.HorizontalPageLayoutManager;
import com.hyphenate.easeui.widget.chatextend.PagingScrollHelper;
import com.hyphenate.util.DensityUtil;
import com.hyphenate.util.EMLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EaseChatExtendMenu
extends FrameLayout
implements PagingScrollHelper.onPageChangeListener,
IChatExtendMenu,
OnItemClickListener {
    private final String TAG = this.getClass().getSimpleName();
    protected Context context;
    private RecyclerView rvExtendMenu;
    private RecyclerView rvIndicator;
    private List<ChatMenuItemModel> itemModels = new ArrayList<ChatMenuItemModel>();
    private Map<Integer, ChatMenuItemModel> itemMap = new HashMap<Integer, ChatMenuItemModel>();
    private EaseChatExtendMenuAdapter adapter;
    private int numColumns;
    private int numRows;
    private int currentPosition;
    private PagingScrollHelper helper;
    private EaseChatExtendMenuIndicatorAdapter indicatorAdapter;
    private List<EaseChatExtendMenuItemClickListener> itemListeners;
    private int[] itemStrings = new int[]{R.string.attach_take_pic, R.string.attach_picture, R.string.attach_location, R.string.attach_video, R.string.attach_file};
    private int[] itemdrawables = new int[]{R.drawable.ease_chat_takepic_selector, R.drawable.ease_chat_image_selector, R.drawable.ease_chat_location_selector, R.drawable.em_chat_video_selector, R.drawable.em_chat_file_selector};
    private int[] itemIds = new int[]{R.id.extend_item_take_picture, R.id.extend_item_picture, R.id.extend_item_location, R.id.extend_item_video, R.id.extend_item_file};

    public EaseChatExtendMenu(Context context) {
        this(context, null);
    }

    public EaseChatExtendMenu(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EaseChatExtendMenu(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
        this.initLayout();
    }

    private void init(Context context, AttributeSet attrs) {
        this.context = context;
        this.itemListeners = new ArrayList<EaseChatExtendMenuItemClickListener>();
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.EaseChatExtendMenu);
        this.numColumns = ta.getInt(R.styleable.EaseChatExtendMenu_numColumns, 4);
        this.numRows = ta.getInt(R.styleable.EaseChatExtendMenu_numRows, 2);
        ta.recycle();
    }

    private void initLayout() {
        LayoutInflater.from((Context)this.context).inflate(R.layout.ease_layout_chat_extend_menu, (ViewGroup)this);
        this.rvExtendMenu = (RecyclerView)this.findViewById(R.id.rv_extend_menu);
        this.rvIndicator = (RecyclerView)this.findViewById(R.id.rv_indicator);
    }

    public void init() {
        this.initChatExtendMenu();
        this.initChatExtendMenuIndicator();
        this.addDefaultData();
    }

    private void initChatExtendMenu() {
        HorizontalPageLayoutManager manager = new HorizontalPageLayoutManager(this.numRows, this.numColumns);
        manager.setItemHeight(DensityUtil.dip2px((Context)this.context, (float)90.0f));
        this.rvExtendMenu.setLayoutManager((RecyclerView.LayoutManager)manager);
        this.rvExtendMenu.setHasFixedSize(true);
        ConcatAdapter concatAdapter = new ConcatAdapter(new RecyclerView.Adapter[0]);
        this.adapter = new EaseChatExtendMenuAdapter();
        concatAdapter.addAdapter((RecyclerView.Adapter)this.adapter);
        this.rvExtendMenu.setAdapter((RecyclerView.Adapter)concatAdapter);
        this.adapter.setData(this.itemModels);
        this.helper = new PagingScrollHelper();
        this.helper.setUpRecycleView(this.rvExtendMenu);
        this.helper.updateLayoutManger();
        this.helper.scrollToPosition(0);
        this.setHorizontalFadingEdgeEnabled(true);
        this.helper.setOnPageChangeListener(this);
        this.adapter.setOnItemClickListener(this);
    }

    private void initChatExtendMenuIndicator() {
        this.indicatorAdapter = new EaseChatExtendMenuIndicatorAdapter();
        this.rvIndicator.setAdapter((RecyclerView.Adapter)this.indicatorAdapter);
        DividerItemDecoration itemDecoration = new DividerItemDecoration(this.context, 0);
        itemDecoration.setDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.ease_chat_extend_menu_indicator_divider));
        this.rvIndicator.addItemDecoration((RecyclerView.ItemDecoration)itemDecoration);
        this.indicatorAdapter.setSelectedPosition(this.currentPosition);
    }

    private void addDefaultData() {
        for (int i = 0; i < this.itemStrings.length; ++i) {
            this.registerMenuItem(this.itemStrings[i], this.itemdrawables[i], this.itemIds[i], null);
        }
    }

    @Override
    public void clear() {
        this.itemModels.clear();
        this.itemMap.clear();
        this.adapter.notifyDataSetChanged();
        this.indicatorAdapter.setPageCount(0);
    }

    @Override
    public void setMenuOrder(int itemId, int order) {
        ChatMenuItemModel model;
        if (this.itemMap.containsKey(itemId) && (model = this.itemMap.get(itemId)) != null) {
            model.order = order;
            this.sortByOrder(this.itemModels);
            this.adapter.notifyDataSetChanged();
        }
    }

    public void registerMenuItem(String name, int drawableRes, int itemId, EaseChatExtendMenuItemClickListener listener) {
        if (!this.itemMap.containsKey(itemId)) {
            ChatMenuItemModel item = new ChatMenuItemModel();
            item.name = name;
            item.image = drawableRes;
            item.id = itemId;
            item.clickListener = listener;
            this.itemMap.put(itemId, item);
            this.itemModels.add(item);
            this.adapter.notifyItemInserted(this.itemModels.size() - 1);
            this.indicatorAdapter.setPageCount((int)Math.ceil((float)this.itemModels.size() * 1.0f / (float)(this.numColumns * this.numRows)));
        }
    }

    public void registerMenuItem(String name, int drawableRes, int itemId, int order, EaseChatExtendMenuItemClickListener listener) {
        if (!this.itemMap.containsKey(itemId)) {
            ChatMenuItemModel item = new ChatMenuItemModel();
            item.name = name;
            item.image = drawableRes;
            item.id = itemId;
            item.order = order;
            item.clickListener = listener;
            this.itemMap.put(itemId, item);
            this.itemModels.add(item);
            this.sortByOrder(this.itemModels);
            this.adapter.notifyDataSetChanged();
            this.indicatorAdapter.setPageCount((int)Math.ceil((float)this.itemModels.size() * 1.0f / (float)(this.numColumns * this.numRows)));
        }
    }

    public void registerMenuItem(int nameRes, int drawableRes, int itemId, EaseChatExtendMenuItemClickListener listener) {
        this.registerMenuItem(this.context.getString(nameRes), drawableRes, itemId, listener);
    }

    public void registerMenuItem(int nameRes, int drawableRes, int itemId, int order, EaseChatExtendMenuItemClickListener listener) {
        this.registerMenuItem(this.context.getString(nameRes), drawableRes, itemId, order, listener);
    }

    private void sortByOrder(List<ChatMenuItemModel> itemModels) {
        Collections.sort(itemModels, new Comparator<ChatMenuItemModel>(){

            @Override
            public int compare(ChatMenuItemModel o1, ChatMenuItemModel o2) {
                int val = o1.order - o2.order;
                if (val > 0) {
                    return 1;
                }
                if (val == 0) {
                    return 0;
                }
                return -1;
            }
        });
    }

    @Override
    public void onPageChange(int index) {
        this.currentPosition = index;
        this.indicatorAdapter.setSelectedPosition(index);
    }

    @Override
    public void onItemClick(View view, int position) {
        ChatMenuItemModel itemModel = this.itemModels.get(position);
        for (int i = 0; i < this.itemListeners.size(); ++i) {
            EaseChatExtendMenuItemClickListener itemListener = this.itemListeners.get(i);
            try {
                if (itemListener == null) continue;
                itemListener.onChatExtendMenuItemClick(itemModel.id, view);
                continue;
            }
            catch (Exception e) {
                EMLog.e((String)this.TAG, (String)("onItemClick Exception:" + e.getMessage()));
            }
        }
    }

    @Override
    public void registerMenuItem(String name, int drawableRes, int itemId) {
        this.registerMenuItem(name, drawableRes, itemId, null);
    }

    @Override
    public void registerMenuItem(String name, int drawableRes, int itemId, int order) {
        this.registerMenuItem(name, drawableRes, itemId, order, null);
    }

    @Override
    public void registerMenuItem(int nameRes, int drawableRes, int itemId) {
        this.registerMenuItem(nameRes, drawableRes, itemId, null);
    }

    @Override
    public void registerMenuItem(int nameRes, int drawableRes, int itemId, int order) {
        this.registerMenuItem(nameRes, drawableRes, itemId, order, null);
    }

    @Override
    public void setEaseChatExtendMenuItemClickListener(EaseChatExtendMenuItemClickListener listener) {
        this.addEaseChatExtendMenuItemClickListener(listener);
    }

    @Override
    public void addEaseChatExtendMenuItemClickListener(EaseChatExtendMenuItemClickListener listener) {
        if (listener == null) {
            EMLog.e((String)this.TAG, (String)"addEaseChatExtendMenuItemClickListener()  param listener is null");
            return;
        }
        if (this.itemListeners != null && !this.itemListeners.contains(listener)) {
            this.itemListeners.add(listener);
        }
    }

    @Override
    public void removeEaseChatExtendMenuItemClickListener(EaseChatExtendMenuItemClickListener listener) {
        if (listener == null) {
            EMLog.e((String)this.TAG, (String)"removeEaseChatExtendMenuItemClickListener()  param listener is null");
            return;
        }
        if (this.itemListeners != null) {
            this.itemListeners.remove(listener);
        }
    }

    @Override
    public void clearEaseChatExtendMenuItemClickListener() {
        if (this.itemListeners != null) {
            this.itemListeners.clear();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.helper != null && this.rvExtendMenu != null) {
            this.helper.scrollToPosition(0);
            this.helper.checkCurrentStatus();
        }
    }

    class ChatMenuItem
    extends LinearLayout {
        private ImageView imageView;
        private TextView textView;

        public ChatMenuItem(Context context, AttributeSet attrs, int defStyle) {
            this(context, attrs);
        }

        public ChatMenuItem(Context context, AttributeSet attrs) {
            super(context, attrs);
            this.init(context, attrs);
        }

        public ChatMenuItem(Context context) {
            super(context);
            this.init(context, null);
        }

        private void init(Context context, AttributeSet attrs) {
            LayoutInflater.from((Context)context).inflate(R.layout.ease_chat_menu_item, (ViewGroup)this);
            this.imageView = (ImageView)this.findViewById(R.id.image);
            this.textView = (TextView)this.findViewById(R.id.text);
        }

        public void setImage(int resid) {
            this.imageView.setBackgroundResource(resid);
        }

        public void setText(int resid) {
            this.textView.setText(resid);
        }

        public void setText(String text) {
            this.textView.setText((CharSequence)text);
        }
    }

    public static class ChatMenuItemModel {
        public String name;
        public int image;
        public int id;
        public int order;
        public EaseChatExtendMenuItemClickListener clickListener;
    }
}

