/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.manager;

import android.text.TextUtils;
import com.hyphenate.easeui.interfaces.IUIKitInterface;
import com.hyphenate.util.EMLog;
import java.util.HashMap;
import java.util.Map;

public class EaseChatInterfaceManager {
    private static final String TAG = EaseChatInterfaceManager.class.getSimpleName();
    private static EaseChatInterfaceManager mInstance;
    private Map<String, IUIKitInterface> interfaceMap = new HashMap<String, IUIKitInterface>();

    private EaseChatInterfaceManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EaseChatInterfaceManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<EaseChatInterfaceManager> clazz = EaseChatInterfaceManager.class;
        synchronized (EaseChatInterfaceManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new EaseChatInterfaceManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void setInterface(String tag, IUIKitInterface iuiKitInterface) {
        if (TextUtils.isEmpty((CharSequence)tag)) {
            EMLog.e((String)TAG, (String)"tag should not be null");
            return;
        }
        this.interfaceMap.put(tag, iuiKitInterface);
    }

    public IUIKitInterface getInterface(String tag) {
        if (!this.interfaceMap.containsKey(tag)) {
            EMLog.e((String)TAG, (String)("Do not have interface with tag: " + tag));
            return null;
        }
        return this.interfaceMap.get(tag);
    }

    public boolean removeInterface(String tag) {
        if (TextUtils.isEmpty((CharSequence)tag)) {
            return false;
        }
        return this.interfaceMap.remove(tag) != null;
    }

    public void clear() {
        this.interfaceMap.clear();
    }
}

