/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.widget.chatextend;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.view.MotionEvent;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;

public class PagingScrollHelper {
    RecyclerView mRecyclerView = null;
    private PageOnScrollListener mOnScrollListener = new PageOnScrollListener();
    private PageOnFlingListener mOnFlingListener = new PageOnFlingListener();
    private int offsetY = 0;
    private int offsetX = 0;
    int startY = 0;
    int startX = 0;
    ValueAnimator mAnimator = null;
    private MyOnTouchListener mOnTouchListener = new MyOnTouchListener();
    private boolean firstTouch = true;
    private onPageChangeListener mOnPageChangeListener;
    private int lastPageIndex;
    private ORIENTATION mOrientation = ORIENTATION.HORIZONTAL;
    private int currentPosition;

    public void setUpRecycleView(RecyclerView recycleView) {
        if (recycleView == null) {
            throw new IllegalArgumentException("recycleView must be not null");
        }
        this.mRecyclerView = recycleView;
        recycleView.setOnFlingListener((RecyclerView.OnFlingListener)this.mOnFlingListener);
        recycleView.addOnScrollListener((RecyclerView.OnScrollListener)this.mOnScrollListener);
        recycleView.setOnTouchListener((View.OnTouchListener)this.mOnTouchListener);
        this.updateLayoutManger();
    }

    public void updateLayoutManger() {
        RecyclerView.LayoutManager layoutManager = this.mRecyclerView.getLayoutManager();
        if (layoutManager != null) {
            this.mOrientation = layoutManager.canScrollVertically() ? ORIENTATION.VERTICAL : (layoutManager.canScrollHorizontally() ? ORIENTATION.HORIZONTAL : ORIENTATION.NULL);
            if (this.mAnimator != null) {
                this.mAnimator.cancel();
            }
            this.startX = 0;
            this.startY = 0;
            this.offsetX = 0;
            this.offsetY = 0;
        }
    }

    public int getPageCount() {
        if (this.mRecyclerView != null) {
            if (this.mOrientation == ORIENTATION.NULL) {
                return 0;
            }
            if (this.mOrientation == ORIENTATION.VERTICAL && this.mRecyclerView.computeVerticalScrollExtent() != 0) {
                return this.mRecyclerView.computeVerticalScrollRange() / this.mRecyclerView.computeVerticalScrollExtent();
            }
            if (this.mRecyclerView.computeHorizontalScrollExtent() != 0) {
                return this.mRecyclerView.computeHorizontalScrollRange() / this.mRecyclerView.computeHorizontalScrollExtent();
            }
        }
        return 0;
    }

    public void scrollToPosition(int position) {
        this.currentPosition = position;
        if (this.mAnimator == null) {
            this.mOnFlingListener.onFling(0, 0);
        }
        if (this.mAnimator != null) {
            int startPoint = this.mOrientation == ORIENTATION.VERTICAL ? this.offsetY : this.offsetX;
            int endPoint = 0;
            endPoint = this.mOrientation == ORIENTATION.VERTICAL ? this.mRecyclerView.getHeight() * position : this.mRecyclerView.getWidth() * position;
            if (startPoint != endPoint) {
                this.mAnimator.setIntValues(new int[]{startPoint, endPoint});
                this.mAnimator.start();
            }
        }
    }

    public void checkCurrentStatus() {
        if (this.mOrientation == ORIENTATION.VERTICAL) {
            if (this.mRecyclerView != null && this.offsetY != this.mRecyclerView.getHeight() * this.currentPosition) {
                this.offsetX = this.mRecyclerView.getHeight() * this.currentPosition;
                this.mRecyclerView.scrollTo(0, this.offsetY);
            }
        } else if (this.mRecyclerView != null && this.offsetX != this.mRecyclerView.getWidth() * this.currentPosition) {
            this.offsetX = this.mRecyclerView.getWidth() * this.currentPosition;
            this.mRecyclerView.scrollTo(this.offsetX, 0);
        }
    }

    private int getPageIndex() {
        int p = 0;
        if (this.mRecyclerView.getHeight() == 0 || this.mRecyclerView.getWidth() == 0) {
            return p;
        }
        p = this.mOrientation == ORIENTATION.VERTICAL ? this.offsetY / this.mRecyclerView.getHeight() : this.offsetX / this.mRecyclerView.getWidth();
        return p;
    }

    private int getStartPageIndex() {
        int p = 0;
        if (this.mRecyclerView.getHeight() == 0 || this.mRecyclerView.getWidth() == 0) {
            return p;
        }
        p = this.mOrientation == ORIENTATION.VERTICAL ? this.startY / this.mRecyclerView.getHeight() : this.startX / this.mRecyclerView.getWidth();
        return p;
    }

    public void setOnPageChangeListener(onPageChangeListener listener) {
        this.mOnPageChangeListener = listener;
    }

    public static interface onPageChangeListener {
        public void onPageChange(int var1);
    }

    public class MyOnTouchListener
    implements View.OnTouchListener {
        public boolean onTouch(View v, MotionEvent event) {
            if (PagingScrollHelper.this.firstTouch) {
                PagingScrollHelper.this.firstTouch = false;
                PagingScrollHelper.this.startY = PagingScrollHelper.this.offsetY;
                PagingScrollHelper.this.startX = PagingScrollHelper.this.offsetX;
            }
            if (event.getAction() == 1 || event.getAction() == 3) {
                PagingScrollHelper.this.firstTouch = true;
            }
            return false;
        }
    }

    public class PageOnScrollListener
    extends RecyclerView.OnScrollListener {
        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            if (newState == 0 && PagingScrollHelper.this.mOrientation != ORIENTATION.NULL) {
                int vX = 0;
                int vY = 0;
                if (PagingScrollHelper.this.mOrientation == ORIENTATION.VERTICAL) {
                    int absY = Math.abs(PagingScrollHelper.this.offsetY - PagingScrollHelper.this.startY);
                    boolean move = absY > recyclerView.getHeight() / 2;
                    vY = 0;
                    if (move) {
                        vY = PagingScrollHelper.this.offsetY - PagingScrollHelper.this.startY < 0 ? -1000 : 1000;
                    }
                } else {
                    boolean move;
                    int absX = Math.abs(PagingScrollHelper.this.offsetX - PagingScrollHelper.this.startX);
                    boolean bl = move = absX > recyclerView.getWidth() / 2;
                    if (move) {
                        vX = PagingScrollHelper.this.offsetX - PagingScrollHelper.this.startX < 0 ? -1000 : 1000;
                    }
                }
                PagingScrollHelper.this.mOnFlingListener.onFling(vX, vY);
            }
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            PagingScrollHelper.this.offsetY = PagingScrollHelper.this.offsetY + dy;
            PagingScrollHelper.this.offsetX = PagingScrollHelper.this.offsetX + dx;
        }
    }

    public class PageOnFlingListener
    extends RecyclerView.OnFlingListener {
        public boolean onFling(int velocityX, int velocityY) {
            if (PagingScrollHelper.this.mOrientation == ORIENTATION.NULL) {
                return false;
            }
            int p = PagingScrollHelper.this.getStartPageIndex();
            int endPoint = 0;
            int startPoint = 0;
            if (PagingScrollHelper.this.mOrientation == ORIENTATION.VERTICAL) {
                startPoint = PagingScrollHelper.this.offsetY;
                if (velocityY < 0) {
                    --p;
                } else if (velocityY > 0) {
                    ++p;
                }
                endPoint = p * PagingScrollHelper.this.mRecyclerView.getHeight();
            } else {
                startPoint = PagingScrollHelper.this.offsetX;
                if (velocityX < 0) {
                    --p;
                } else if (velocityX > 0) {
                    ++p;
                }
                endPoint = p * PagingScrollHelper.this.mRecyclerView.getWidth();
            }
            if (endPoint < 0) {
                endPoint = 0;
            }
            if (PagingScrollHelper.this.mAnimator == null) {
                PagingScrollHelper.this.mAnimator = ValueAnimator.ofInt((int[])new int[]{startPoint, endPoint});
                PagingScrollHelper.this.mAnimator.setDuration(200L);
                PagingScrollHelper.this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        int nowPoint = (Integer)animation.getAnimatedValue();
                        if (PagingScrollHelper.this.mOrientation == ORIENTATION.VERTICAL) {
                            int dy = nowPoint - PagingScrollHelper.this.offsetY;
                            PagingScrollHelper.this.mRecyclerView.scrollBy(0, dy);
                        } else {
                            int dx = nowPoint - PagingScrollHelper.this.offsetX;
                            PagingScrollHelper.this.mRecyclerView.scrollBy(dx, 0);
                        }
                    }
                });
                PagingScrollHelper.this.mAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        int pageIndex = PagingScrollHelper.this.getPageIndex();
                        if (PagingScrollHelper.this.lastPageIndex != pageIndex) {
                            if (null != PagingScrollHelper.this.mOnPageChangeListener) {
                                PagingScrollHelper.this.mOnPageChangeListener.onPageChange(pageIndex);
                            }
                            PagingScrollHelper.this.lastPageIndex = pageIndex;
                        }
                        PagingScrollHelper.this.mRecyclerView.stopScroll();
                        PagingScrollHelper.this.startY = PagingScrollHelper.this.offsetY;
                        PagingScrollHelper.this.startX = PagingScrollHelper.this.offsetX;
                    }
                });
            } else {
                PagingScrollHelper.this.mAnimator.cancel();
                PagingScrollHelper.this.mAnimator.setIntValues(new int[]{startPoint, endPoint});
            }
            PagingScrollHelper.this.mAnimator.start();
            return true;
        }
    }

    static enum ORIENTATION {
        HORIZONTAL,
        VERTICAL,
        NULL;

    }
}

