/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.hyphenate.easeui.R;

public class EaseSidebar
extends View {
    private Paint paint;
    private float ItemHeight;
    private Context context;
    private OnTouchEventListener mListener;
    private String[] sections = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "#"};
    private String topText;
    private int mTextColor;
    private static final String DEFAULT_COLOR = "#8C8C8C";
    private static final float DEFAULT_TEXT_SIZE = 10.0f;
    private float mTextSize;
    private int mBgColor;
    private int mWidth;
    private int mHeight;
    private float mTextCoefficient = 1.0f;

    public EaseSidebar(Context context) {
        this(context, null);
    }

    public EaseSidebar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EaseSidebar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.initAttrs(attrs);
        this.init();
    }

    private void initAttrs(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = this.context.obtainStyledAttributes(attrs, R.styleable.EaseSidebar);
            int topTextId = a.getResourceId(R.styleable.EaseSidebar_ease_side_bar_top_text, -1);
            this.topText = topTextId != -1 ? this.context.getResources().getString(topTextId) : a.getString(R.styleable.EaseSidebar_ease_side_bar_top_text);
            int textColorId = a.getResourceId(R.styleable.EaseSidebar_ease_side_bar_text_color, -1);
            this.mTextColor = textColorId != -1 ? ContextCompat.getColor((Context)this.context, (int)textColorId) : a.getColor(R.styleable.EaseSidebar_ease_side_bar_text_color, Color.parseColor((String)DEFAULT_COLOR));
            this.mTextSize = a.getDimension(R.styleable.EaseSidebar_ease_side_bar_text_size, 10.0f);
            int bgId = a.getResourceId(R.styleable.EaseSidebar_ease_side_bar_background, -1);
            this.mBgColor = bgId != -1 ? ContextCompat.getColor((Context)this.context, (int)textColorId) : a.getColor(R.styleable.EaseSidebar_ease_side_bar_background, 0);
            int headArrays = a.getResourceId(R.styleable.EaseSidebar_ease_side_bar_head_arrays, -1);
            this.sections = headArrays != -1 ? this.getResources().getStringArray(headArrays) : new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "#"};
        }
    }

    private void init() {
        if (this.sections.length > 27 && !TextUtils.isEmpty((CharSequence)this.topText)) {
            this.sections[0] = this.topText;
        }
        this.paint = new Paint(1);
        this.paint.setColor(this.mTextColor);
        this.paint.setTextAlign(Paint.Align.CENTER);
        this.paint.setTextSize(this.mTextSize);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
        this.checkTextSize();
    }

    private void checkTextSize() {
        if (this.paint != null) {
            Paint.FontMetrics metrics = this.paint.getFontMetrics();
            float textItemHeight = metrics.bottom - metrics.top;
            if ((float)this.sections.length * textItemHeight > (float)this.mHeight) {
                this.mTextCoefficient = (float)this.mHeight / ((float)this.sections.length * textItemHeight);
                this.paint.setTextSize(this.paint.getTextSize() * this.mTextCoefficient);
            } else {
                this.paint.setTextSize(this.mTextSize);
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mBgColor != 0) {
            canvas.drawColor(this.mBgColor);
        }
        float center = this.getWidth() / 2;
        this.ItemHeight = this.getHeight() / this.sections.length;
        for (int i = this.sections.length - 1; i > -1; --i) {
            canvas.drawText(this.sections[i], center, this.ItemHeight * (float)(i + 1), this.paint);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        int pointer = this.sectionForPoint(event.getY());
        String section = this.sections[pointer];
        switch (event.getAction()) {
            case 0: {
                if (this.mListener != null) {
                    this.mListener.onActionDown(event, section);
                }
                return true;
            }
            case 2: {
                if (this.mListener != null) {
                    this.mListener.onActionMove(event, section);
                }
                return true;
            }
            case 1: 
            case 3: {
                if (this.mListener != null) {
                    this.mListener.onActionUp(event);
                }
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    private int sectionForPoint(float y) {
        int index = (int)(y / this.ItemHeight);
        if (index < 0) {
            index = 0;
        }
        if (index > this.sections.length - 1) {
            index = this.sections.length - 1;
        }
        return index;
    }

    public void drawBackground(@ColorRes int color2) {
        this.mBgColor = ContextCompat.getColor((Context)this.context, (int)color2);
        this.postInvalidate();
    }

    public void drawBackgroundDrawable(@DrawableRes int drawableId) {
        this.setBackground(ContextCompat.getDrawable((Context)this.context, (int)drawableId));
    }

    public void drawBackgroundDrawable(Drawable drawable2) {
        this.setBackground(drawable2);
    }

    public void setOnTouchEventListener(OnTouchEventListener listener) {
        this.mListener = listener;
    }

    public static interface OnTouchEventListener {
        public void onActionDown(MotionEvent var1, String var2);

        public void onActionMove(MotionEvent var1, String var2);

        public void onActionUp(MotionEvent var1);
    }
}

