/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.ui;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.manager.EaseDingMessageHelper;
import com.hyphenate.easeui.ui.base.EaseBaseActivity;
import com.hyphenate.easeui.widget.EaseTitleBar;
import com.hyphenate.util.EMLog;
import java.util.ArrayList;
import java.util.List;

public class EaseDingAckUserListActivity
extends EaseBaseActivity {
    private static final String TAG = "EaseDingAckUserListActi";
    private ListView ackUserListView;
    private EaseTitleBar titleBar;
    private TextView tvNoData;
    private EMMessage msg;
    private AckUserAdapter userAdapter;
    private List<String> userList;
    private EaseDingMessageHelper.IAckUserUpdateListener userUpdateListener = new EaseDingMessageHelper.IAckUserUpdateListener(){

        @Override
        public void onUpdate(List<String> list) {
            EMLog.i((String)EaseDingAckUserListActivity.TAG, (String)("onUpdate: " + list.size()));
            if (list != null && list.size() > 0) {
                EaseDingAckUserListActivity.this.runOnUiThread(() -> EaseDingAckUserListActivity.this.tvNoData.setVisibility(8));
            }
            EaseDingAckUserListActivity.this.userList.clear();
            EaseDingAckUserListActivity.this.userList.addAll(list);
            EaseDingAckUserListActivity.this.runOnUiThread(() -> EaseDingAckUserListActivity.this.userAdapter.notifyDataSetChanged());
        }
    };

    @Override
    protected void onCreate(Bundle arg0) {
        super.onCreate(arg0);
        this.setContentView(R.layout.ease_activity_ding_ack_user_list);
        this.setFitSystemForTheme(true);
        this.ackUserListView = (ListView)this.findViewById(R.id.list_view);
        this.titleBar = (EaseTitleBar)this.findViewById(R.id.title_bar);
        this.tvNoData = (TextView)this.findViewById(R.id.tv_no_data);
        this.titleBar.setTitle(this.getString(R.string.title_ack_read_list));
        this.titleBar.setLeftLayoutClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                EaseDingAckUserListActivity.this.back(v);
            }
        });
        this.msg = (EMMessage)this.getIntent().getParcelableExtra("msg");
        EMLog.i((String)TAG, (String)("Get msg from intent, msg: " + this.msg.toString()));
        this.userList = new ArrayList<String>();
        this.userAdapter = new AckUserAdapter((Context)this, this.userList);
        this.ackUserListView.setAdapter((ListAdapter)this.userAdapter);
        String msgId = this.msg.getMsgId();
        EaseDingMessageHelper.get().fetchGroupReadAck(this.msg);
    }

    @Override
    protected void onResume() {
        super.onResume();
        EaseDingMessageHelper.get().setUserUpdateListener(this.msg, this.userUpdateListener);
    }

    protected void onPause() {
        super.onPause();
        EaseDingMessageHelper.get().setUserUpdateListener(this.msg, null);
    }

    private static class AckUserAdapter
    extends BaseAdapter {
        private Context context;
        private List<String> userList;

        public AckUserAdapter(Context context, List<String> userList) {
            this.context = context;
            this.userList = userList;
        }

        public int getCount() {
            return this.userList.size();
        }

        public Object getItem(int position) {
            return this.userList.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder vh;
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)this.context).inflate(R.layout.ease_row_ding_ack_user, null);
                vh = new ViewHolder(convertView);
                convertView.setTag((Object)vh);
            } else {
                vh = (ViewHolder)convertView.getTag();
            }
            vh.nameView.setText((CharSequence)this.userList.get(position));
            return convertView;
        }

        private static class ViewHolder {
            public TextView nameView;

            public ViewHolder(View contentView) {
                this.nameView = (TextView)contentView.findViewById(R.id.username);
            }
        }
    }
}

