/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules.menu;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.appcompat.view.menu.MenuPopupHelper;
import androidx.appcompat.widget.PopupMenu;
import com.hyphenate.easeui.modules.menu.MenuItemBean;
import com.hyphenate.easeui.modules.menu.OnPopupMenuDismissListener;
import com.hyphenate.easeui.modules.menu.OnPopupMenuItemClickListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class EasePopupMenuHelper
implements PopupMenu.OnMenuItemClickListener,
PopupMenu.OnDismissListener {
    private View targetView;
    private OnPopupMenuItemClickListener itemClickListener;
    private OnPopupMenuDismissListener dismissListener;
    private List<MenuItemBean> menuItems = new ArrayList<MenuItemBean>();
    private PopupMenu pMenu;
    private Menu menu;

    public EasePopupMenuHelper() {
        this.menuItems.clear();
    }

    public void initMenu(@NonNull View view) {
        this.targetView = view;
        this.pMenu = new PopupMenu(this.targetView.getContext(), this.targetView);
        this.menu = this.pMenu.getMenu();
        this.pMenu.setOnMenuItemClickListener((PopupMenu.OnMenuItemClickListener)this);
        this.pMenu.setOnDismissListener((PopupMenu.OnDismissListener)this);
        this.addMenuItem();
    }

    private void addMenuItem() {
        if (this.menuItems.isEmpty()) {
            return;
        }
        for (MenuItemBean item : this.menuItems) {
            MenuItem menuItem = this.menu.findItem(item.getItemId());
            if (menuItem != null) continue;
            this.menu.add(item.getGroupId(), item.getItemId(), item.getOrder(), (CharSequence)item.getTitle());
        }
    }

    public void clear() {
        this.menuItems.clear();
    }

    public void addItemMenu(MenuItemBean item) {
        if (!this.menuItems.contains(item)) {
            this.menuItems.add(item);
        }
    }

    public void addItemMenu(int groupId, int itemId, int order, String title) {
        MenuItemBean item = new MenuItemBean(groupId, itemId, order, title);
        if (!this.menuItems.contains(item)) {
            this.menuItems.add(item);
        }
    }

    public void findItemVisible(int id2, boolean visible) {
        if (this.menu == null) {
            throw new NullPointerException("PopupMenu must init first!");
        }
        try {
            this.menu.findItem(id2).setVisible(visible);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void show() {
        this.show(0, 0);
    }

    @SuppressLint(value={"RestrictedApi"})
    public void show(int x, int y) {
        if (this.menu == null) {
            throw new NullPointerException("PopupMenu must init first!");
        }
        this.addMenuItem();
        try {
            Field field = this.pMenu.getClass().getDeclaredField("mPopup");
            field.setAccessible(true);
            MenuPopupHelper helper = (MenuPopupHelper)field.get(this.pMenu);
            Log.e((String)"TAG", (String)("show menu x = " + x + " y = " + y));
            helper.show(x, y);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static float dip2px(Context context, float value) {
        return TypedValue.applyDimension((int)1, (float)value, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public boolean onMenuItemClick(MenuItem item) {
        if (this.itemClickListener != null) {
            return this.itemClickListener.onMenuItemClick(item, -1);
        }
        return false;
    }

    public void setOnPopupMenuItemClickListener(OnPopupMenuItemClickListener listener) {
        this.itemClickListener = listener;
    }

    public void setOnPopupMenuDismissListener(OnPopupMenuDismissListener listener) {
        this.dismissListener = listener;
    }

    public void onDismiss(PopupMenu menu) {
        if (this.dismissListener != null) {
            this.dismissListener.onDismiss(menu);
        }
    }
}

