/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.core.content.FileProvider;
import androidx.fragment.app.Fragment;
import com.hyphenate.chat.EMClient;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.utils.EaseCommonUtils;
import com.hyphenate.easeui.utils.EaseFileUtils;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.PathUtil;
import com.hyphenate.util.VersionUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class EaseCompat {
    private static final String TAG = "EaseCompat";

    public static void openImage(Activity context, int requestCode) {
        Intent intent = EaseCompat.getOpenImageIntent((Context)context);
        context.startActivityForResult(intent, requestCode);
    }

    public static void openImage(Fragment context, int requestCode) {
        Intent intent = EaseCompat.getOpenImageIntent((Context)context.getActivity());
        context.startActivityForResult(intent, requestCode);
    }

    private static Intent getOpenImageIntent(Context context) {
        Intent intent = null;
        if (VersionUtils.isTargetQ((Context)context)) {
            intent = new Intent("android.intent.action.OPEN_DOCUMENT");
            intent.addCategory("android.intent.category.OPENABLE");
        } else if (Build.VERSION.SDK_INT < 19) {
            intent = new Intent("android.intent.action.GET_CONTENT");
            intent.addCategory("android.intent.category.OPENABLE");
        } else {
            intent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        }
        intent.addFlags(3);
        intent.setType("image/*");
        return intent;
    }

    public static File takePicture(Activity context, int requestCode) {
        if (!EaseCommonUtils.isSdcardExist()) {
            return null;
        }
        File cameraFile = EaseCompat.getCameraFile();
        Intent intent = EaseCompat.getCameraIntent((Context)context, cameraFile);
        context.startActivityForResult(intent, requestCode);
        return cameraFile;
    }

    public static File takePicture(Fragment context, int requestCode) {
        if (!EaseCommonUtils.isSdcardExist()) {
            return null;
        }
        File cameraFile = EaseCompat.getCameraFile();
        Intent intent = EaseCompat.getCameraIntent(context.getContext(), cameraFile);
        context.startActivityForResult(intent, requestCode);
        return cameraFile;
    }

    public static File takeVideo(Activity context, int requestCode) {
        if (!EaseCommonUtils.isSdcardExist()) {
            return null;
        }
        File videoFile = EaseCompat.getVideoFile();
        Intent intent = EaseCompat.getVideoIntent((Context)context, videoFile);
        context.startActivityForResult(intent, requestCode);
        return videoFile;
    }

    public static File takeVideo(Fragment context, int requestCode) {
        if (!EaseCommonUtils.isSdcardExist()) {
            return null;
        }
        File videoFile = EaseCompat.getVideoFile();
        Intent intent = EaseCompat.getVideoIntent(context.getContext(), videoFile);
        context.startActivityForResult(intent, requestCode);
        return videoFile;
    }

    private static Intent getCameraIntent(Context context, File cameraFile) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        intent.putExtra("output", (Parcelable)EaseCompat.getUriForFile(context, cameraFile));
        return intent;
    }

    private static File getCameraFile() {
        File cameraFile = new File(PathUtil.getInstance().getImagePath(), EMClient.getInstance().getCurrentUser() + System.currentTimeMillis() + ".jpg");
        cameraFile.getParentFile().mkdirs();
        return cameraFile;
    }

    private static Intent getVideoIntent(Context context, File videoFile) {
        Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
        intent.putExtra("output", (Parcelable)EaseCompat.getUriForFile(context, videoFile));
        return intent;
    }

    private static File getVideoFile() {
        File videoFile = new File(PathUtil.getInstance().getVideoPath(), System.currentTimeMillis() + ".mp4");
        videoFile.getParentFile().mkdirs();
        return videoFile;
    }

    public static void openFile(File f, Activity context) {
        EaseCompat.openFile((Context)context, f);
    }

    public static void openFile(Context context, String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath) || !new File(filePath).exists()) {
            EMLog.e((String)TAG, (String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            return;
        }
        EaseCompat.openFile(context, new File(filePath));
    }

    public static void openFile(Context context, File file) {
        if (file == null || !file.exists()) {
            EMLog.e((String)TAG, (String)("Cannot open the file, because the file is not exit, file: " + file));
            return;
        }
        String filename = file.getName();
        String mimeType = EaseCompat.getMimeType(context, file);
        Uri uri = EaseCompat.getUriForFile(context, file);
        if (EaseCompat.isVideoFile(context, filename)) {
            uri = Uri.parse((String)file.getAbsolutePath());
        }
        EaseCompat.openFile(context, uri, filename, mimeType);
    }

    public static void openFile(Context context, Uri uri) {
        if (!EaseFileUtils.isFileExistByUri(context, uri)) {
            EMLog.e((String)TAG, (String)("Cannot open the file, because the file is not exit, uri: " + uri));
            return;
        }
        String filePath = EaseFileUtils.getFilePath(context, uri);
        if (!TextUtils.isEmpty((CharSequence)filePath) && new File(filePath).exists()) {
            EaseCompat.openFile(context, new File(filePath));
            return;
        }
        String filename = EaseCompat.getFileNameByUri(context, uri);
        String mimeType = EaseCompat.getMimeType(context, filename);
        EaseCompat.openFile(context, uri, filename, mimeType);
    }

    private static void openFile(Context context, Uri uri, String filename, String mimeType) {
        if (EaseCompat.openApk(context, uri, filename)) {
            return;
        }
        EMLog.d((String)TAG, (String)("openFile filename = " + filename + " mimeType = " + mimeType));
        EMLog.d((String)TAG, (String)("openFile uri = " + (uri != null ? uri.toString() : "uri is null")));
        Intent intent = new Intent("android.intent.action.VIEW");
        EaseCompat.setIntentByType(context, filename, intent);
        intent.addFlags(1);
        intent.setDataAndType(uri, mimeType);
        try {
            context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            EMLog.e((String)TAG, (String)e.getMessage());
            Toast.makeText((Context)context, (CharSequence)context.getString(R.string.can_not_find_app_open_file), (int)1).show();
        }
    }

    public static void deleteFile(Context context, Uri uri) {
        EaseFileUtils.deleteFile(context, uri);
    }

    public static Uri getUriForFile(Context context, @NonNull File file) {
        if (Build.VERSION.SDK_INT >= 24) {
            return FileProvider.getUriForFile((Context)context, (String)(context.getPackageName() + ".fileProvider"), (File)file);
        }
        return Uri.fromFile((File)file);
    }

    public static int getSupportedWindowType() {
        if (Build.VERSION.SDK_INT >= 26) {
            return 2038;
        }
        return 2003;
    }

    public static String getVideoThumbnail(Context context, @NonNull Uri videoUri) {
        File file = new File(PathUtil.getInstance().getVideoPath(), "thvideo" + System.currentTimeMillis());
        try {
            FileOutputStream fos = new FileOutputStream(file);
            MediaMetadataRetriever media = new MediaMetadataRetriever();
            media.setDataSource(context, videoUri);
            Bitmap frameAtTime = media.getFrameAtTime();
            frameAtTime.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return file.getAbsolutePath();
    }

    public static boolean isVideoType(Context context, @NonNull Uri uri) {
        String mimeType = EaseCompat.getMimeType(context, uri);
        if (TextUtils.isEmpty((CharSequence)mimeType)) {
            return false;
        }
        return mimeType.startsWith("video");
    }

    public static boolean isImageType(Context context, @NonNull Uri uri) {
        String mimeType = EaseCompat.getMimeType(context, uri);
        if (TextUtils.isEmpty((CharSequence)mimeType)) {
            return false;
        }
        return mimeType.startsWith("image");
    }

    public static String getMimeType(Context context, @NonNull Uri uri) {
        return context.getContentResolver().getType(uri);
    }

    public static String getMimeType(Context context, @NonNull File file) {
        return EaseCompat.getMimeType(context, file.getName());
    }

    public static String getMimeType(Context context, String filename) {
        String mimeType = null;
        Resources resources = context.getResources();
        mimeType = EaseCompat.checkSuffix(filename, resources.getStringArray(R.array.ease_image_file_suffix)) ? "image/*" : (EaseCompat.checkSuffix(filename, resources.getStringArray(R.array.ease_video_file_suffix)) ? "video/*" : (EaseCompat.checkSuffix(filename, resources.getStringArray(R.array.ease_audio_file_suffix)) ? "audio/*" : (EaseCompat.checkSuffix(filename, resources.getStringArray(R.array.ease_file_file_suffix)) ? "text/plain" : (EaseCompat.checkSuffix(filename, resources.getStringArray(R.array.ease_word_file_suffix)) ? "application/msword" : (EaseCompat.checkSuffix(filename, resources.getStringArray(R.array.ease_excel_file_suffix)) ? "application/vnd.ms-excel" : (EaseCompat.checkSuffix(filename, resources.getStringArray(R.array.ease_pdf_file_suffix)) ? "application/pdf" : (EaseCompat.checkSuffix(filename, resources.getStringArray(R.array.ease_apk_file_suffix)) ? "application/vnd.android.package-archive" : "application/octet-stream")))))));
        return mimeType;
    }

    public static boolean isVideoFile(Context context, String filename) {
        return EaseCompat.checkSuffix(filename, context.getResources().getStringArray(R.array.ease_video_file_suffix));
    }

    public static void setIntentByType(Context context, String filename, Intent intent) {
        Resources rs = context.getResources();
        if (EaseCompat.checkSuffix(filename, rs.getStringArray(R.array.ease_audio_file_suffix)) || EaseCompat.checkSuffix(filename, rs.getStringArray(R.array.ease_video_file_suffix))) {
            intent.addFlags(0x4000000);
            intent.putExtra("oneshot", 0);
            intent.putExtra("configchange", 0);
        } else if (EaseCompat.checkSuffix(filename, rs.getStringArray(R.array.ease_image_file_suffix))) {
            intent.addCategory("android.intent.category.DEFAULT");
            intent.addFlags(0x10000000);
        } else if (EaseCompat.checkSuffix(filename, rs.getStringArray(R.array.ease_excel_file_suffix)) || EaseCompat.checkSuffix(filename, rs.getStringArray(R.array.ease_word_file_suffix)) || EaseCompat.checkSuffix(filename, rs.getStringArray(R.array.ease_pdf_file_suffix))) {
            intent.addCategory("android.intent.category.DEFAULT");
            intent.addFlags(0x10000000);
        } else {
            intent.addCategory("android.intent.category.DEFAULT");
            intent.addFlags(0x10000000);
        }
    }

    public static boolean openApk(Context context, Uri uri) {
        String filename = EaseCompat.getFileNameByUri(context, uri);
        return EaseCompat.openApk(context, uri, filename);
    }

    private static boolean openApk(Context context, Uri uri, @NonNull String filename) {
        if (filename.endsWith(".apk")) {
            if (Build.VERSION.SDK_INT >= 24) {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.addFlags(1);
                intent.setDataAndType(uri, EaseCompat.getMimeType(context, filename));
                context.startActivity(intent);
            } else {
                Intent installIntent = new Intent("android.intent.action.VIEW");
                installIntent.setFlags(0x10000000);
                installIntent.setDataAndType(uri, EaseCompat.getMimeType(context, filename));
                context.startActivity(installIntent);
            }
            return true;
        }
        return false;
    }

    private static boolean checkSuffix(String filename, String[] fileSuffix) {
        if (TextUtils.isEmpty((CharSequence)filename) || fileSuffix == null || fileSuffix.length <= 0) {
            return false;
        }
        for (String suffix : fileSuffix) {
            if (!filename.toLowerCase().endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static String getFileNameByUri(Context context, Uri fileUri) {
        return EaseFileUtils.getFileNameByUri(context, fileUri);
    }

    public static String getPath(Context context, Uri uri) {
        return EaseFileUtils.getFilePath(context, uri);
    }
}

