/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules.contact.presenter;

import android.text.TextUtils;
import com.hyphenate.chat.EMClient;
import com.hyphenate.easeui.EaseIM;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.domain.EaseUser;
import com.hyphenate.easeui.modules.contact.presenter.EaseContactPresenter;
import com.hyphenate.easeui.provider.EaseUserProfileProvider;
import com.hyphenate.exceptions.HyphenateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class EaseContactPresenterImpl
extends EaseContactPresenter {
    @Override
    public void loadData() {
        this.runOnIO(() -> {
            block8: {
                try {
                    List blackListFromServer;
                    List<EaseUser> easeUsers;
                    ArrayList<String> usernames = EMClient.getInstance().contactManager().getAllContactsFromServer();
                    List ids = EMClient.getInstance().contactManager().getSelfIdsOnOtherPlatform();
                    if ((usernames == null || usernames.isEmpty()) && (ids == null || ids.isEmpty())) {
                        if (!this.isDestroy()) {
                            this.runOnUI(() -> this.mView.loadContactListNoData());
                        }
                        return;
                    }
                    if (usernames == null) {
                        usernames = new ArrayList<String>();
                    }
                    if (ids != null && !ids.isEmpty()) {
                        usernames.addAll(ids);
                    }
                    if ((easeUsers = EaseUser.parse(usernames)) != null && !easeUsers.isEmpty() && (blackListFromServer = EMClient.getInstance().contactManager().getBlackListFromServer()) != null && !blackListFromServer.isEmpty()) {
                        for (EaseUser user : easeUsers) {
                            if (blackListFromServer == null || blackListFromServer.isEmpty() || !blackListFromServer.contains(user.getUsername())) continue;
                            user.setContact(1);
                        }
                    }
                    this.runOnUI(() -> {
                        if (!this.isDestroy()) {
                            this.mView.loadContactListSuccess(easeUsers);
                        }
                    });
                }
                catch (HyphenateException e) {
                    e.printStackTrace();
                    if (this.isDestroy()) break block8;
                    this.runOnUI(() -> this.mView.loadContactListFail(e.getDescription()));
                }
            }
        });
    }

    @Override
    public void sortData(List<EaseUser> data) {
        if (data != null) {
            this.checkUserProvider(data);
            this.sortList(data);
            if (!this.isDestroy()) {
                this.runOnUI(() -> this.mView.sortContactListSuccess(data));
            }
        }
    }

    private void checkUserProvider(List<EaseUser> data) {
        EaseUserProfileProvider provider = EaseIM.getInstance().getUserProvider();
        if (provider != null) {
            for (EaseUser user : data) {
                EaseUser setUser = provider.getUser(user.getUsername());
                if (setUser == null) continue;
                if (TextUtils.isEmpty((CharSequence)user.getNickname()) || TextUtils.equals((CharSequence)user.getNickname(), (CharSequence)user.getUsername())) {
                    user.setNickname(setUser.getNickname());
                }
                if (!TextUtils.isEmpty((CharSequence)user.getAvatar())) continue;
                user.setAvatar(setUser.getAvatar());
            }
        }
    }

    private void sortList(List<EaseUser> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Collections.sort(list, new Comparator<EaseUser>(){

            @Override
            public int compare(EaseUser lhs, EaseUser rhs) {
                if (lhs.getInitialLetter().equals(rhs.getInitialLetter())) {
                    return lhs.getNickname().compareTo(rhs.getNickname());
                }
                if ("#".equals(lhs.getInitialLetter())) {
                    return 1;
                }
                if ("#".equals(rhs.getInitialLetter())) {
                    return -1;
                }
                return lhs.getInitialLetter().compareTo(rhs.getInitialLetter());
            }
        });
    }

    @Override
    public void addNote(int position, EaseUser user) {
        if (!this.isDestroy()) {
            this.runOnUI(() -> this.mView.addNoteFail(position, this.mView.context().getString(R.string.ease_contact_add_note_developing)));
        }
    }
}

