/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules;

import android.util.Log;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import com.hyphenate.easeui.manager.EaseThreadManager;
import com.hyphenate.easeui.modules.ILoadDataView;

public abstract class EaseBasePresenter
implements LifecycleObserver {
    private static final String TAG = EaseBasePresenter.class.getSimpleName();
    private boolean isDestroy;

    public abstract void attachView(ILoadDataView var1);

    public abstract void detachView();

    @OnLifecycleEvent(value=Lifecycle.Event.ON_CREATE)
    public void onCreate() {
        Log.i((String)TAG, (String)(this.toString() + " onCreate"));
        this.isDestroy = false;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
    public void onStart() {
        Log.i((String)TAG, (String)(this.toString() + " onStart"));
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    public void onResume() {
        Log.i((String)TAG, (String)(this.toString() + " onResume"));
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_PAUSE)
    public void onPause() {
        Log.i((String)TAG, (String)(this.toString() + " onPause"));
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    public void onStop() {
        Log.i((String)TAG, (String)(this.toString() + " onStop"));
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void onDestroy() {
        Log.i((String)TAG, (String)(this.toString() + " onDestroy"));
        this.isDestroy = true;
    }

    public boolean isDestroy() {
        return this.isDestroy;
    }

    public boolean isActive() {
        return !this.isDestroy;
    }

    public void runOnUI(Runnable runnable) {
        EaseThreadManager.getInstance().runOnMainThread(runnable);
    }

    public void runOnIO(Runnable runnable) {
        EaseThreadManager.getInstance().runOnIOThread(runnable);
    }
}

