/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules.menu;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.adapter.EaseBaseRecyclerViewAdapter;
import com.hyphenate.easeui.interfaces.OnItemClickListener;
import com.hyphenate.easeui.modules.menu.EasePopupWindow;
import com.hyphenate.easeui.modules.menu.MenuItemBean;
import com.hyphenate.easeui.utils.EaseCommonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EasePopupWindowHelper {
    private static final int[] itemIds = new int[]{R.id.action_chat_copy, R.id.action_chat_delete, R.id.action_chat_recall, R.id.action_chat_translate, R.id.action_chat_reTranslate, R.id.action_chat_hide};
    private static final int[] titles = new int[]{R.string.action_copy, R.string.action_delete, R.string.action_recall, R.string.action_translate, R.string.action_reTranslate, R.string.action_hide};
    private static final int[] icons = new int[]{R.drawable.ease_chat_item_menu_copy, R.drawable.ease_chat_item_menu_delete, R.drawable.ease_chat_item_menu_recall, R.drawable.ease_chat_item_menu_translation, R.drawable.ease_chat_item_menu_translation, R.drawable.ease_chat_item_menu_hide};
    private static final int SPAN_COUNT = 5;
    private EasePopupWindow pMenu;
    private List<MenuItemBean> menuItems = new ArrayList<MenuItemBean>();
    private Map<Integer, MenuItemBean> menuItemMap = new HashMap<Integer, MenuItemBean>();
    private TextView tvTitle;
    private RecyclerView rvMenuList;
    private Context context;
    private MenuAdapter adapter;
    private EasePopupWindow.OnPopupWindowItemClickListener itemClickListener;
    private EasePopupWindow.OnPopupWindowDismissListener dismissListener;
    private boolean touchable;
    private Drawable background;
    private View layout;

    public EasePopupWindowHelper() {
        if (this.pMenu != null) {
            this.pMenu.dismiss();
        }
        this.menuItems.clear();
        this.menuItemMap.clear();
    }

    public void initMenu(@NonNull Context context) {
        this.context = context;
        this.pMenu = new EasePopupWindow(context, true);
        this.layout = LayoutInflater.from((Context)context).inflate(R.layout.ease_layout_menu_popupwindow, null);
        this.pMenu.setContentView(this.layout);
        this.tvTitle = (TextView)this.layout.findViewById(R.id.tv_title);
        this.rvMenuList = (RecyclerView)this.layout.findViewById(R.id.rv_menu_list);
        this.adapter = new MenuAdapter();
        this.rvMenuList.setAdapter((RecyclerView.Adapter)this.adapter);
        this.adapter.setOnItemClickListener(new OnItemClickListener(){

            @Override
            public void onItemClick(View view, int position) {
                EasePopupWindowHelper.this.dismiss();
                if (EasePopupWindowHelper.this.itemClickListener != null) {
                    EasePopupWindowHelper.this.itemClickListener.onMenuItemClick((MenuItemBean)EasePopupWindowHelper.this.adapter.getItem(position));
                }
            }
        });
    }

    public void clear() {
        this.menuItems.clear();
        this.menuItemMap.clear();
    }

    public void setDefaultMenus() {
        for (int i = 0; i < itemIds.length; ++i) {
            MenuItemBean bean = new MenuItemBean(0, itemIds[i], (i + 1) * 10, this.context.getString(titles[i]));
            bean.setResourceId(icons[i]);
            this.addItemMenu(bean);
        }
    }

    public void addItemMenu(MenuItemBean item) {
        if (!this.menuItemMap.containsKey(item.getItemId())) {
            this.menuItemMap.put(item.getItemId(), item);
        }
    }

    public void addItemMenu(int groupId, int itemId, int order, String title) {
        MenuItemBean item = new MenuItemBean(groupId, itemId, order, title);
        this.addItemMenu(item);
    }

    public MenuItemBean findItem(int id2) {
        if (this.menuItemMap.containsKey(id2)) {
            return this.menuItemMap.get(id2);
        }
        return null;
    }

    public void findItemVisible(int id2, boolean visible) {
        if (this.menuItemMap.containsKey(id2)) {
            this.menuItemMap.get(id2).setVisible(visible);
        }
    }

    public void setOutsideTouchable(boolean touchable) {
        this.touchable = touchable;
    }

    public void setBackgroundDrawable(Drawable background) {
        this.background = background;
    }

    private void showPre() {
        this.pMenu.setOutsideTouchable(this.touchable);
        this.pMenu.setBackgroundDrawable(this.background);
        this.checkIfShowItems();
        this.sortList(this.menuItems);
        this.adapter.setData(this.menuItems);
    }

    private void sortList(List<MenuItemBean> menuItems) {
        Collections.sort(menuItems, new Comparator<MenuItemBean>(){

            @Override
            public int compare(MenuItemBean o1, MenuItemBean o2) {
                int order1 = o1.getOrder();
                int order2 = o2.getOrder();
                if (order2 < order1) {
                    return 1;
                }
                if (order1 == order2) {
                    return 0;
                }
                return -1;
            }
        });
    }

    private void checkIfShowItems() {
        if (this.menuItemMap.size() > 0) {
            this.menuItems.clear();
            for (MenuItemBean item : this.menuItemMap.values()) {
                if (!item.isVisible()) continue;
                this.menuItems.add(item);
            }
        }
    }

    public void showTitle(@NonNull String title) {
        if (this.pMenu == null) {
            throw new NullPointerException("please must init first!");
        }
        this.tvTitle.setText((CharSequence)title);
        this.tvTitle.setVisibility(0);
    }

    public void show(View parent, View v) {
        this.showPre();
        if (this.menuItems.size() <= 0) {
            Log.e((String)"EasePopupWindowHelper", (String)("Span count should be at least 1. Provided " + this.menuItems.size()));
            return;
        }
        if (this.menuItems.size() < 5) {
            this.rvMenuList.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.context, this.menuItems.size(), 1, false));
        } else {
            this.rvMenuList.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.context, 5, 1, false));
        }
        this.getView().measure(0, 0);
        int popupWidth = this.getView().getMeasuredWidth();
        int popupHeight = this.getView().getMeasuredHeight();
        int[] location = new int[2];
        v.getLocationOnScreen(location);
        int[] location2 = new int[2];
        parent.getLocationOnScreen(location2);
        int margin = (int)EaseCommonUtils.dip2px(this.context, 5.0f);
        int yOffset = 0;
        yOffset = location[1] - popupHeight - margin < location2[1] ? location[1] + v.getHeight() + margin : location[1] - popupHeight - margin;
        int xOffset = 0;
        xOffset = (float)(location[0] + v.getWidth() / 2 + popupWidth / 2) + EaseCommonUtils.dip2px(this.context, 10.0f) > (float)parent.getWidth() ? (int)((float)parent.getWidth() - EaseCommonUtils.dip2px(this.context, 10.0f) - (float)popupWidth) : location[0] + v.getWidth() / 2 - popupWidth / 2;
        if ((float)xOffset < EaseCommonUtils.dip2px(this.context, 10.0f)) {
            xOffset = (int)EaseCommonUtils.dip2px(this.context, 10.0f);
        }
        this.pMenu.showAtLocation(v, 0, xOffset, yOffset);
    }

    public void dismiss() {
        if (this.pMenu == null) {
            throw new NullPointerException("please must init first!");
        }
        this.pMenu.dismiss();
        if (this.dismissListener != null) {
            this.dismissListener.onDismiss(this.pMenu);
        }
    }

    public void setOnPopupMenuItemClickListener(EasePopupWindow.OnPopupWindowItemClickListener listener) {
        this.itemClickListener = listener;
    }

    public void setOnPopupMenuDismissListener(EasePopupWindow.OnPopupWindowDismissListener listener) {
        this.dismissListener = listener;
    }

    public PopupWindow getPopupWindow() {
        return this.pMenu;
    }

    public View getView() {
        return this.layout;
    }

    private class MenuAdapter
    extends EaseBaseRecyclerViewAdapter<MenuItemBean> {
        private MenuAdapter() {
        }

        @Override
        public EaseBaseRecyclerViewAdapter.ViewHolder getViewHolder(ViewGroup parent, int viewType) {
            View view = LayoutInflater.from((Context)EasePopupWindowHelper.this.context).inflate(R.layout.ease_layout_item_menu_popupwindow, parent, false);
            return new MenuViewHolder(view);
        }

        private class MenuViewHolder
        extends EaseBaseRecyclerViewAdapter.ViewHolder<MenuItemBean> {
            private ImageView ivActionIcon;
            private TextView tvActionName;

            public MenuViewHolder(View itemView) {
                super(itemView);
            }

            @Override
            public void initView(View itemView) {
                this.ivActionIcon = (ImageView)this.findViewById(R.id.iv_action_icon);
                this.tvActionName = (TextView)this.findViewById(R.id.tv_action_name);
            }

            @Override
            public void setData(MenuItemBean item, int position) {
                String title = item.getTitle();
                if (!TextUtils.isEmpty((CharSequence)title)) {
                    this.tvActionName.setText((CharSequence)title);
                }
                if (item.getResourceId() != 0) {
                    this.ivActionIcon.setImageResource(item.getResourceId());
                }
            }
        }
    }
}

