/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.widget.photoview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import com.hyphenate.easeui.widget.photoview.Compat;
import com.hyphenate.easeui.widget.photoview.EasePhotoView;
import com.hyphenate.easeui.widget.photoview.IPhotoView;
import com.hyphenate.easeui.widget.photoview.ScrollerProxy;
import com.hyphenate.easeui.widget.photoview.VersionedGestureDetector;
import java.lang.ref.WeakReference;

class PhotoViewAttacher
implements IPhotoView,
View.OnTouchListener,
VersionedGestureDetector.OnGestureListener,
GestureDetector.OnDoubleTapListener,
ViewTreeObserver.OnGlobalLayoutListener {
    static final String LOG_TAG = "PhotoViewAttacher";
    static final boolean DEBUG = Log.isLoggable((String)"PhotoViewAttacher", (int)3);
    static final int EDGE_NONE = -1;
    static final int EDGE_LEFT = 0;
    static final int EDGE_RIGHT = 1;
    static final int EDGE_BOTH = 2;
    public static final float DEFAULT_MAX_SCALE = 2.0f;
    public static final float DEFAULT_MIN_SCALE = 1.0f;
    private float mMinScale = 1.0f;
    private float mMaxScale = 2.0f;
    private boolean mAllowParentInterceptOnEdge = true;
    private WeakReference<ImageView> mImageView;
    private ViewTreeObserver mViewTreeObserver;
    private GestureDetector mGestureDetector;
    private VersionedGestureDetector mScaleDragDetector;
    private final Matrix mBaseMatrix = new Matrix();
    private final Matrix mDrawMatrix = new Matrix();
    private final Matrix mSuppMatrix = new Matrix();
    private final RectF mDisplayRect = new RectF();
    private final float[] mMatrixValues = new float[9];
    private OnMatrixChangedListener mMatrixChangeListener;
    private OnPhotoTapListener mPhotoTapListener;
    private OnViewTapListener mViewTapListener;
    private View.OnLongClickListener mLongClickListener;
    private int mIvTop;
    private int mIvRight;
    private int mIvBottom;
    private int mIvLeft;
    private FlingRunnable mCurrentFlingRunnable;
    private int mScrollEdge = 2;
    private boolean mZoomEnabled;
    private ImageView.ScaleType mScaleType = ImageView.ScaleType.FIT_CENTER;

    private static void checkZoomLevels(float minZoom, float maxZoom) {
        if (minZoom >= maxZoom) {
            throw new IllegalArgumentException("MinZoom should be less than maxZoom");
        }
    }

    private static boolean hasDrawable(ImageView imageView) {
        return null != imageView && null != imageView.getDrawable();
    }

    private static boolean isSupportedScaleType(ImageView.ScaleType scaleType) {
        if (null == scaleType) {
            return false;
        }
        switch (scaleType) {
            case MATRIX: {
                throw new IllegalArgumentException(scaleType.name() + " is not supported in PhotoView");
            }
        }
        return true;
    }

    private static void setImageViewScaleTypeMatrix(ImageView imageView) {
        if (null != imageView && !(imageView instanceof EasePhotoView)) {
            imageView.setScaleType(ImageView.ScaleType.MATRIX);
        }
    }

    public PhotoViewAttacher(ImageView imageView) {
        this.mImageView = new WeakReference<ImageView>(imageView);
        imageView.setOnTouchListener((View.OnTouchListener)this);
        this.mViewTreeObserver = imageView.getViewTreeObserver();
        this.mViewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        PhotoViewAttacher.setImageViewScaleTypeMatrix(imageView);
        if (!imageView.isInEditMode()) {
            this.mScaleDragDetector = VersionedGestureDetector.newInstance(imageView.getContext(), this);
            this.mGestureDetector = new GestureDetector(imageView.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

                public void onLongPress(MotionEvent e) {
                    if (null != PhotoViewAttacher.this.mLongClickListener) {
                        PhotoViewAttacher.this.mLongClickListener.onLongClick((View)PhotoViewAttacher.this.mImageView.get());
                    }
                }
            });
            this.mGestureDetector.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)this);
            this.setZoomable(true);
        }
    }

    @Override
    public final boolean canZoom() {
        return this.mZoomEnabled;
    }

    @SuppressLint(value={"NewApi"})
    public final void cleanup() {
        if (Build.VERSION.SDK_INT >= 16) {
            if (null != this.mImageView) {
                ((ImageView)this.mImageView.get()).getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
            if (null != this.mViewTreeObserver && this.mViewTreeObserver.isAlive()) {
                this.mViewTreeObserver.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                this.mViewTreeObserver = null;
                this.mMatrixChangeListener = null;
                this.mPhotoTapListener = null;
                this.mViewTapListener = null;
                this.mImageView = null;
            }
        } else {
            if (null != this.mImageView) {
                ((ImageView)this.mImageView.get()).getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
            if (null != this.mViewTreeObserver && this.mViewTreeObserver.isAlive()) {
                this.mViewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                this.mViewTreeObserver = null;
                this.mMatrixChangeListener = null;
                this.mPhotoTapListener = null;
                this.mViewTapListener = null;
                this.mImageView = null;
            }
        }
    }

    @Override
    public final RectF getDisplayRect() {
        this.checkMatrixBounds();
        return this.getDisplayRect(this.getDisplayMatrix());
    }

    public final ImageView getImageView() {
        ImageView imageView = null;
        if (null != this.mImageView) {
            imageView = (ImageView)this.mImageView.get();
        }
        if (null == imageView) {
            this.cleanup();
            throw new IllegalStateException("ImageView no longer exists. You should not use this PhotoViewAttacher any more.");
        }
        return imageView;
    }

    @Override
    public float getMinScale() {
        return this.mMinScale;
    }

    @Override
    public float getMaxScale() {
        return this.mMaxScale;
    }

    @Override
    public final float getScale() {
        return this.getValue(this.mSuppMatrix, 0);
    }

    @Override
    public final ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    public final boolean onDoubleTap(MotionEvent ev) {
        try {
            float scale = this.getScale();
            float x = ev.getX();
            float y = ev.getY();
            if (scale < this.mMaxScale) {
                this.zoomTo(this.mMaxScale, x, y);
            } else {
                this.zoomTo(this.mMinScale, x, y);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return true;
    }

    public final boolean onDoubleTapEvent(MotionEvent e) {
        return false;
    }

    @Override
    public final void onDrag(float dx, float dy) {
        ImageView imageView;
        if (DEBUG) {
            Log.d((String)LOG_TAG, (String)String.format("onDrag: dx: %.2f. dy: %.2f", Float.valueOf(dx), Float.valueOf(dy)));
        }
        if (null != (imageView = this.getImageView()) && PhotoViewAttacher.hasDrawable(imageView)) {
            this.mSuppMatrix.postTranslate(dx, dy);
            this.checkAndDisplayMatrix();
            if (this.mAllowParentInterceptOnEdge && !this.mScaleDragDetector.isScaling() && (this.mScrollEdge == 2 || this.mScrollEdge == 0 && dx >= 1.0f || this.mScrollEdge == 1 && dx <= -1.0f)) {
                imageView.getParent().requestDisallowInterceptTouchEvent(false);
            }
        }
    }

    @Override
    public final void onFling(float startX, float startY, float velocityX, float velocityY) {
        ImageView imageView;
        if (DEBUG) {
            Log.d((String)LOG_TAG, (String)("onFling. sX: " + startX + " sY: " + startY + " Vx: " + velocityX + " Vy: " + velocityY));
        }
        if (PhotoViewAttacher.hasDrawable(imageView = this.getImageView())) {
            this.mCurrentFlingRunnable = new FlingRunnable(imageView.getContext());
            this.mCurrentFlingRunnable.fling(imageView.getWidth(), imageView.getHeight(), (int)velocityX, (int)velocityY);
            imageView.post((Runnable)this.mCurrentFlingRunnable);
        }
    }

    public final void onGlobalLayout() {
        ImageView imageView = this.getImageView();
        if (null != imageView && this.mZoomEnabled) {
            int top = imageView.getTop();
            int right = imageView.getRight();
            int bottom = imageView.getBottom();
            int left = imageView.getLeft();
            if (top != this.mIvTop || bottom != this.mIvBottom || left != this.mIvLeft || right != this.mIvRight) {
                this.updateBaseMatrix(imageView.getDrawable());
                this.mIvTop = top;
                this.mIvRight = right;
                this.mIvBottom = bottom;
                this.mIvLeft = left;
            }
        }
    }

    @Override
    public final void onScale(float scaleFactor, float focusX, float focusY) {
        if (DEBUG) {
            Log.d((String)LOG_TAG, (String)String.format("onScale: scale: %.2f. fX: %.2f. fY: %.2f", Float.valueOf(scaleFactor), Float.valueOf(focusX), Float.valueOf(focusY)));
        }
        if (PhotoViewAttacher.hasDrawable(this.getImageView()) && (this.getScale() < this.mMaxScale || scaleFactor < 1.0f)) {
            this.mSuppMatrix.postScale(scaleFactor, scaleFactor, focusX, focusY);
            this.checkAndDisplayMatrix();
        }
    }

    public final boolean onSingleTapConfirmed(MotionEvent e) {
        ImageView imageView = this.getImageView();
        if (null != imageView) {
            float y;
            float x;
            RectF displayRect;
            if (null != this.mPhotoTapListener && null != (displayRect = this.getDisplayRect()) && displayRect.contains(x = e.getX(), y = e.getY())) {
                float xResult = (x - displayRect.left) / displayRect.width();
                float yResult = (y - displayRect.top) / displayRect.height();
                this.mPhotoTapListener.onPhotoTap((View)imageView, xResult, yResult);
                return true;
            }
            if (null != this.mViewTapListener) {
                this.mViewTapListener.onViewTap((View)imageView, e.getX(), e.getY());
            }
        }
        return false;
    }

    public final boolean onTouch(View v, MotionEvent ev) {
        boolean handled = false;
        if (this.mZoomEnabled) {
            switch (ev.getAction()) {
                case 0: {
                    v.getParent().requestDisallowInterceptTouchEvent(true);
                    this.cancelFling();
                    break;
                }
                case 1: 
                case 3: {
                    RectF rect;
                    if (!(this.getScale() < this.mMinScale) || null == (rect = this.getDisplayRect())) break;
                    v.post((Runnable)new AnimatedZoomRunnable(this.getScale(), this.mMinScale, rect.centerX(), rect.centerY()));
                    handled = true;
                }
            }
            if (null != this.mGestureDetector && this.mGestureDetector.onTouchEvent(ev)) {
                handled = true;
            }
            if (null != this.mScaleDragDetector && this.mScaleDragDetector.onTouchEvent(ev)) {
                handled = true;
            }
        }
        return handled;
    }

    @Override
    public void setAllowParentInterceptOnEdge(boolean allow) {
        this.mAllowParentInterceptOnEdge = allow;
    }

    @Override
    public void setMinScale(float minScale) {
        PhotoViewAttacher.checkZoomLevels(minScale, this.mMaxScale);
        this.mMinScale = minScale;
    }

    @Override
    public void setMaxScale(float maxScale) {
        PhotoViewAttacher.checkZoomLevels(this.mMinScale, maxScale);
        this.mMaxScale = maxScale;
    }

    @Override
    public final void setOnLongClickListener(View.OnLongClickListener listener) {
        this.mLongClickListener = listener;
    }

    @Override
    public final void setOnMatrixChangeListener(OnMatrixChangedListener listener) {
        this.mMatrixChangeListener = listener;
    }

    @Override
    public final void setOnPhotoTapListener(OnPhotoTapListener listener) {
        this.mPhotoTapListener = listener;
    }

    @Override
    public final void setOnViewTapListener(OnViewTapListener listener) {
        this.mViewTapListener = listener;
    }

    @Override
    public final void setScaleType(ImageView.ScaleType scaleType) {
        if (PhotoViewAttacher.isSupportedScaleType(scaleType) && scaleType != this.mScaleType) {
            this.mScaleType = scaleType;
            this.update();
        }
    }

    @Override
    public final void setZoomable(boolean zoomable) {
        this.mZoomEnabled = zoomable;
        this.update();
    }

    public final void update() {
        ImageView imageView = this.getImageView();
        if (null != imageView) {
            if (this.mZoomEnabled) {
                PhotoViewAttacher.setImageViewScaleTypeMatrix(imageView);
                this.updateBaseMatrix(imageView.getDrawable());
            } else {
                this.resetMatrix();
            }
        }
    }

    @Override
    public final void zoomTo(float scale, float focalX, float focalY) {
        ImageView imageView = this.getImageView();
        if (null != imageView) {
            imageView.post((Runnable)new AnimatedZoomRunnable(this.getScale(), scale, focalX, focalY));
        }
    }

    protected Matrix getDisplayMatrix() {
        this.mDrawMatrix.set(this.mBaseMatrix);
        this.mDrawMatrix.postConcat(this.mSuppMatrix);
        return this.mDrawMatrix;
    }

    private void cancelFling() {
        if (null != this.mCurrentFlingRunnable) {
            this.mCurrentFlingRunnable.cancelFling();
            this.mCurrentFlingRunnable = null;
        }
    }

    private void checkAndDisplayMatrix() {
        this.checkMatrixBounds();
        this.setImageViewMatrix(this.getDisplayMatrix());
    }

    private void checkImageViewScaleType() {
        ImageView imageView = this.getImageView();
        if (null != imageView && !(imageView instanceof EasePhotoView) && imageView.getScaleType() != ImageView.ScaleType.MATRIX) {
            throw new IllegalStateException("The ImageView's ScaleType has been changed since attaching a PhotoViewAttacher");
        }
    }

    private void checkMatrixBounds() {
        ImageView imageView = this.getImageView();
        if (null == imageView) {
            return;
        }
        RectF rect = this.getDisplayRect(this.getDisplayMatrix());
        if (null == rect) {
            return;
        }
        float height = rect.height();
        float width = rect.width();
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        int viewHeight = imageView.getHeight();
        if (height <= (float)viewHeight) {
            switch (this.mScaleType) {
                case FIT_START: {
                    deltaY = -rect.top;
                    break;
                }
                case FIT_END: {
                    deltaY = (float)viewHeight - height - rect.top;
                    break;
                }
                default: {
                    deltaY = ((float)viewHeight - height) / 2.0f - rect.top;
                    break;
                }
            }
        } else if (rect.top > 0.0f) {
            deltaY = -rect.top;
        } else if (rect.bottom < (float)viewHeight) {
            deltaY = (float)viewHeight - rect.bottom;
        }
        int viewWidth = imageView.getWidth();
        if (width <= (float)viewWidth) {
            switch (this.mScaleType) {
                case FIT_START: {
                    deltaX = -rect.left;
                    break;
                }
                case FIT_END: {
                    deltaX = (float)viewWidth - width - rect.left;
                    break;
                }
                default: {
                    deltaX = ((float)viewWidth - width) / 2.0f - rect.left;
                }
            }
            this.mScrollEdge = 2;
        } else if (rect.left > 0.0f) {
            this.mScrollEdge = 0;
            deltaX = -rect.left;
        } else if (rect.right < (float)viewWidth) {
            deltaX = (float)viewWidth - rect.right;
            this.mScrollEdge = 1;
        } else {
            this.mScrollEdge = -1;
        }
        this.mSuppMatrix.postTranslate(deltaX, deltaY);
    }

    private RectF getDisplayRect(Matrix matrix) {
        Drawable d;
        ImageView imageView = this.getImageView();
        if (null != imageView && null != (d = imageView.getDrawable())) {
            this.mDisplayRect.set(0.0f, 0.0f, (float)d.getIntrinsicWidth(), (float)d.getIntrinsicHeight());
            matrix.mapRect(this.mDisplayRect);
            return this.mDisplayRect;
        }
        return null;
    }

    private float getValue(Matrix matrix, int whichValue) {
        matrix.getValues(this.mMatrixValues);
        return this.mMatrixValues[whichValue];
    }

    private void resetMatrix() {
        this.mSuppMatrix.reset();
        this.setImageViewMatrix(this.getDisplayMatrix());
        this.checkMatrixBounds();
    }

    private void setImageViewMatrix(Matrix matrix) {
        ImageView imageView = this.getImageView();
        if (null != imageView) {
            RectF displayRect;
            this.checkImageViewScaleType();
            imageView.setImageMatrix(matrix);
            if (null != this.mMatrixChangeListener && null != (displayRect = this.getDisplayRect(matrix))) {
                this.mMatrixChangeListener.onMatrixChanged(displayRect);
            }
        }
    }

    private void updateBaseMatrix(Drawable d) {
        ImageView imageView = this.getImageView();
        if (null == imageView || null == d) {
            return;
        }
        float viewWidth = imageView.getWidth();
        float viewHeight = imageView.getHeight();
        int drawableWidth = d.getIntrinsicWidth();
        int drawableHeight = d.getIntrinsicHeight();
        this.mBaseMatrix.reset();
        float widthScale = viewWidth / (float)drawableWidth;
        float heightScale = viewHeight / (float)drawableHeight;
        if (this.mScaleType == ImageView.ScaleType.CENTER) {
            this.mBaseMatrix.postTranslate((viewWidth - (float)drawableWidth) / 2.0f, (viewHeight - (float)drawableHeight) / 2.0f);
        } else if (this.mScaleType == ImageView.ScaleType.CENTER_CROP) {
            float scale = Math.max(widthScale, heightScale);
            this.mBaseMatrix.postScale(scale, scale);
            this.mBaseMatrix.postTranslate((viewWidth - (float)drawableWidth * scale) / 2.0f, (viewHeight - (float)drawableHeight * scale) / 2.0f);
        } else if (this.mScaleType == ImageView.ScaleType.CENTER_INSIDE) {
            float scale = Math.min(1.0f, Math.min(widthScale, heightScale));
            this.mBaseMatrix.postScale(scale, scale);
            this.mBaseMatrix.postTranslate((viewWidth - (float)drawableWidth * scale) / 2.0f, (viewHeight - (float)drawableHeight * scale) / 2.0f);
        } else {
            RectF mTempSrc = new RectF(0.0f, 0.0f, (float)drawableWidth, (float)drawableHeight);
            RectF mTempDst = new RectF(0.0f, 0.0f, viewWidth, viewHeight);
            switch (this.mScaleType) {
                case FIT_CENTER: {
                    this.mBaseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.CENTER);
                    break;
                }
                case FIT_START: {
                    this.mBaseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.START);
                    break;
                }
                case FIT_END: {
                    this.mBaseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.END);
                    break;
                }
                case FIT_XY: {
                    this.mBaseMatrix.setRectToRect(mTempSrc, mTempDst, Matrix.ScaleToFit.FILL);
                    break;
                }
            }
        }
        this.resetMatrix();
    }

    @Override
    public float getMidScale() {
        return 0.0f;
    }

    @Override
    public void setMidScale(float midScale) {
    }

    private class FlingRunnable
    implements Runnable {
        private final ScrollerProxy mScroller;
        private int mCurrentX;
        private int mCurrentY;

        public FlingRunnable(Context context) {
            this.mScroller = ScrollerProxy.getScroller(context);
        }

        public void cancelFling() {
            if (DEBUG) {
                Log.d((String)PhotoViewAttacher.LOG_TAG, (String)"Cancel Fling");
            }
            this.mScroller.forceFinished(true);
        }

        public void fling(int viewWidth, int viewHeight, int velocityX, int velocityY) {
            int maxY;
            int minY;
            int maxX;
            int minX;
            RectF rect = PhotoViewAttacher.this.getDisplayRect();
            if (null == rect) {
                return;
            }
            int startX = Math.round(-rect.left);
            if ((float)viewWidth < rect.width()) {
                minX = 0;
                maxX = Math.round(rect.width() - (float)viewWidth);
            } else {
                minX = maxX = startX;
            }
            int startY = Math.round(-rect.top);
            if ((float)viewHeight < rect.height()) {
                minY = 0;
                maxY = Math.round(rect.height() - (float)viewHeight);
            } else {
                minY = maxY = startY;
            }
            this.mCurrentX = startX;
            this.mCurrentY = startY;
            if (DEBUG) {
                Log.d((String)PhotoViewAttacher.LOG_TAG, (String)("fling. StartX:" + startX + " StartY:" + startY + " MaxX:" + maxX + " MaxY:" + maxY));
            }
            if (startX != maxX || startY != maxY) {
                this.mScroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY, 0, 0);
            }
        }

        @Override
        public void run() {
            ImageView imageView = PhotoViewAttacher.this.getImageView();
            if (null != imageView && this.mScroller.computeScrollOffset()) {
                int newX = this.mScroller.getCurrX();
                int newY = this.mScroller.getCurrY();
                if (DEBUG) {
                    Log.d((String)PhotoViewAttacher.LOG_TAG, (String)("fling run(). CurrentX:" + this.mCurrentX + " CurrentY:" + this.mCurrentY + " NewX:" + newX + " NewY:" + newY));
                }
                PhotoViewAttacher.this.mSuppMatrix.postTranslate((float)(this.mCurrentX - newX), (float)(this.mCurrentY - newY));
                PhotoViewAttacher.this.setImageViewMatrix(PhotoViewAttacher.this.getDisplayMatrix());
                this.mCurrentX = newX;
                this.mCurrentY = newY;
                Compat.postOnAnimation((View)imageView, this);
            }
        }
    }

    private class AnimatedZoomRunnable
    implements Runnable {
        static final float ANIMATION_SCALE_PER_ITERATION_IN = 1.07f;
        static final float ANIMATION_SCALE_PER_ITERATION_OUT = 0.93f;
        private final float mFocalX;
        private final float mFocalY;
        private final float mTargetZoom;
        private final float mDeltaScale;

        public AnimatedZoomRunnable(float currentZoom, float targetZoom, float focalX, float focalY) {
            this.mTargetZoom = targetZoom;
            this.mFocalX = focalX;
            this.mFocalY = focalY;
            this.mDeltaScale = currentZoom < targetZoom ? 1.07f : 0.93f;
        }

        @Override
        public void run() {
            ImageView imageView = PhotoViewAttacher.this.getImageView();
            if (null != imageView) {
                PhotoViewAttacher.this.mSuppMatrix.postScale(this.mDeltaScale, this.mDeltaScale, this.mFocalX, this.mFocalY);
                PhotoViewAttacher.this.checkAndDisplayMatrix();
                float currentScale = PhotoViewAttacher.this.getScale();
                if (this.mDeltaScale > 1.0f && currentScale < this.mTargetZoom || this.mDeltaScale < 1.0f && this.mTargetZoom < currentScale) {
                    Compat.postOnAnimation((View)imageView, this);
                } else {
                    float delta = this.mTargetZoom / currentScale;
                    PhotoViewAttacher.this.mSuppMatrix.postScale(delta, delta, this.mFocalX, this.mFocalY);
                    PhotoViewAttacher.this.checkAndDisplayMatrix();
                }
            }
        }
    }

    public static interface OnViewTapListener {
        public void onViewTap(View var1, float var2, float var3);
    }

    public static interface OnPhotoTapListener {
        public void onPhotoTap(View var1, float var2, float var3);
    }

    public static interface OnMatrixChangedListener {
        public void onMatrixChanged(RectF var1);
    }
}

