/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.widget.chatrow;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMVoiceMessageBody;
import com.hyphenate.easeui.EaseIM;
import java.io.IOException;

public class EaseChatRowVoicePlayer {
    private static final String TAG = EaseChatRowVoicePlayer.class.getSimpleName();
    private static EaseChatRowVoicePlayer instance = null;
    private AudioManager audioManager;
    private MediaPlayer mediaPlayer;
    private String playingId;
    private MediaPlayer.OnCompletionListener onCompletionListener;
    private final Context baseContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EaseChatRowVoicePlayer getInstance(Context context) {
        if (instance != null) return instance;
        Class<EaseChatRowVoicePlayer> clazz = EaseChatRowVoicePlayer.class;
        synchronized (EaseChatRowVoicePlayer.class) {
            if (instance != null) return instance;
            instance = new EaseChatRowVoicePlayer(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public MediaPlayer getPlayer() {
        return this.mediaPlayer;
    }

    public boolean isPlaying() {
        return this.mediaPlayer.isPlaying();
    }

    public String getCurrentPlayingId() {
        return this.playingId;
    }

    public void play(EMMessage msg, MediaPlayer.OnCompletionListener listener) {
        if (!(msg.getBody() instanceof EMVoiceMessageBody)) {
            return;
        }
        if (this.mediaPlayer.isPlaying()) {
            this.stop();
        }
        this.playingId = msg.getMsgId();
        this.onCompletionListener = listener;
        try {
            this.setSpeaker();
            EMVoiceMessageBody voiceBody = (EMVoiceMessageBody)msg.getBody();
            this.mediaPlayer.setDataSource(this.baseContext, voiceBody.getLocalUri());
            this.mediaPlayer.prepare();
            this.mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mp) {
                    EaseChatRowVoicePlayer.this.stop();
                    EaseChatRowVoicePlayer.this.playingId = null;
                    EaseChatRowVoicePlayer.this.onCompletionListener = null;
                }
            });
            this.mediaPlayer.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        this.mediaPlayer.stop();
        this.mediaPlayer.reset();
        if (this.onCompletionListener != null) {
            this.onCompletionListener.onCompletion(this.mediaPlayer);
        }
    }

    public void release() {
        this.onCompletionListener = null;
    }

    private EaseChatRowVoicePlayer(Context cxt) {
        this.baseContext = cxt.getApplicationContext();
        this.audioManager = (AudioManager)this.baseContext.getSystemService("audio");
        this.mediaPlayer = new MediaPlayer();
    }

    private void setSpeaker() {
        boolean speakerOn = EaseIM.getInstance().getSettingsProvider().isSpeakerOpened();
        if (speakerOn) {
            this.audioManager.setMode(0);
            this.audioManager.setSpeakerphoneOn(true);
            this.mediaPlayer.setAudioStreamType(2);
        } else {
            this.audioManager.setSpeakerphoneOn(false);
            this.audioManager.setMode(2);
            this.mediaPlayer.setAudioStreamType(0);
        }
    }
}

