/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.widget.chatrow;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.hyphenate.EMCallBack;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.easeui.EaseIM;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.adapter.EaseBaseAdapter;
import com.hyphenate.easeui.domain.EaseAvatarOptions;
import com.hyphenate.easeui.interfaces.MessageListItemClickListener;
import com.hyphenate.easeui.modules.chat.EaseChatMessageListLayout;
import com.hyphenate.easeui.modules.chat.model.EaseChatItemStyleHelper;
import com.hyphenate.easeui.modules.chat.model.EaseChatSetStyle;
import com.hyphenate.easeui.utils.EaseDateUtils;
import com.hyphenate.easeui.utils.EaseUserUtils;
import com.hyphenate.easeui.widget.EaseImageView;
import com.hyphenate.util.EMLog;
import java.util.Date;

public abstract class EaseChatRow
extends LinearLayout {
    protected static final String TAG = EaseChatRow.class.getSimpleName();
    protected LayoutInflater inflater;
    protected Context context;
    protected Object adapter;
    protected EMMessage message;
    protected int position;
    protected TextView timeStampView;
    protected ImageView userAvatarView;
    protected View bubbleLayout;
    protected TextView usernickView;
    protected TextView percentageView;
    protected ProgressBar progressBar;
    protected ImageView statusView;
    protected TextView ackedView;
    protected TextView deliveredView;
    protected boolean isSender;
    protected boolean showSenderType;
    protected EaseChatCallback chatCallback;
    private Handler mainThreadHandler;
    protected MessageListItemClickListener itemClickListener;
    private EaseChatRowActionCallback itemActionCallback;

    public EaseChatRow(Context context, boolean isSender) {
        super(context);
        this.context = context;
        this.isSender = isSender;
        this.inflater = LayoutInflater.from((Context)context);
        this.initView();
    }

    public EaseChatRow(Context context, EMMessage message, int position, Object adapter) {
        super(context);
        this.context = context;
        this.message = message;
        this.isSender = message.direct() == EMMessage.Direct.SEND;
        this.position = position;
        this.adapter = adapter;
        this.inflater = LayoutInflater.from((Context)context);
        this.initView();
    }

    protected void onDetachedFromWindow() {
        this.itemActionCallback.onDetachedFromWindow();
        super.onDetachedFromWindow();
    }

    private void initView() {
        this.showSenderType = this.isSender;
        EaseChatItemStyleHelper helper = this.getItemStyleHelper();
        if (helper != null && helper.getStyle() != null) {
            if (helper.getStyle().getItemShowType() == 1) {
                this.showSenderType = false;
            } else if (helper.getStyle().getItemShowType() == 2) {
                this.showSenderType = true;
            }
        }
        this.onInflateView();
        this.timeStampView = (TextView)this.findViewById(R.id.timestamp);
        this.userAvatarView = (ImageView)this.findViewById(R.id.iv_userhead);
        this.bubbleLayout = this.findViewById(R.id.bubble);
        this.usernickView = (TextView)this.findViewById(R.id.tv_userid);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progress_bar);
        this.statusView = (ImageView)this.findViewById(R.id.msg_status);
        this.ackedView = (TextView)this.findViewById(R.id.tv_ack);
        this.deliveredView = (TextView)this.findViewById(R.id.tv_delivered);
        this.setLayoutStyle();
        this.mainThreadHandler = new Handler(Looper.getMainLooper());
        this.onFindViewById();
    }

    protected void setLayoutStyle() {
        EaseChatItemStyleHelper helper = this.getItemStyleHelper();
        if (helper != null) {
            TextView content;
            EaseChatSetStyle itemStyle = helper.getStyle();
            if (this.bubbleLayout != null) {
                try {
                    if (this.isSender()) {
                        Drawable senderBgDrawable = itemStyle.getSenderBgDrawable();
                        if (senderBgDrawable != null) {
                            this.bubbleLayout.setBackground(senderBgDrawable.getConstantState().newDrawable());
                        }
                    } else {
                        Drawable receiverBgDrawable = itemStyle.getReceiverBgDrawable();
                        if (receiverBgDrawable != null) {
                            this.bubbleLayout.setBackground(receiverBgDrawable.getConstantState().newDrawable());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.timeStampView != null) {
                if (itemStyle.getTimeBgDrawable() != null) {
                    this.timeStampView.setBackground(itemStyle.getTimeBgDrawable().getConstantState().newDrawable());
                }
                if (itemStyle.getTimeTextSize() != 0) {
                    this.timeStampView.setTextSize(0, (float)itemStyle.getTimeTextSize());
                }
                if (itemStyle.getTimeTextColor() != 0) {
                    this.timeStampView.setTextColor(itemStyle.getTimeTextColor());
                }
            }
            if ((content = (TextView)this.findViewById(R.id.tv_chatcontent)) != null) {
                if (itemStyle.getTextSize() != 0) {
                    content.setTextSize(0, (float)itemStyle.getTextSize());
                }
                if (itemStyle.getTextColor() != 0) {
                    content.setTextColor(itemStyle.getTextColor());
                }
            }
        }
    }

    public void updateView(final EMMessage msg) {
        if (this.chatCallback == null) {
            this.chatCallback = new EaseChatCallback();
        }
        msg.setMessageStatusCallback((EMCallBack)this.chatCallback);
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                EaseChatRow.this.onViewUpdate(msg);
            }
        });
    }

    public void setUpView(EMMessage message, int position, MessageListItemClickListener itemClickListener, EaseChatRowActionCallback itemActionCallback) {
        this.message = message;
        this.position = position;
        this.itemClickListener = itemClickListener;
        this.itemActionCallback = itemActionCallback;
        this.setUpBaseView();
        this.onSetUpView();
        this.setClickListener();
    }

    private void setUpBaseView() {
        TextView timestamp = (TextView)this.findViewById(R.id.timestamp);
        if (timestamp != null) {
            this.setTimestamp(timestamp);
        }
        this.setItemStyle();
        if (this.userAvatarView != null) {
            this.setAvatarAndNick();
        }
        if (EMClient.getInstance().getOptions().getRequireDeliveryAck() && this.deliveredView != null && this.isSender()) {
            if (this.message.isDelivered()) {
                this.deliveredView.setVisibility(0);
            } else {
                this.deliveredView.setVisibility(4);
            }
        }
        if (EMClient.getInstance().getOptions().getRequireAck() && this.ackedView != null && this.isSender()) {
            if (this.message.isAcked()) {
                if (this.deliveredView != null) {
                    this.deliveredView.setVisibility(4);
                }
                this.ackedView.setVisibility(0);
            } else {
                this.ackedView.setVisibility(4);
            }
        }
    }

    private void setItemStyle() {
        EaseChatItemStyleHelper helper = this.getItemStyleHelper();
        if (helper != null) {
            EaseChatSetStyle itemStyle = helper.getStyle();
            if (this.userAvatarView != null) {
                this.setAvatarOptions(itemStyle);
            }
            if (this.usernickView != null) {
                if (itemStyle.getItemShowType() == 1 || itemStyle.getItemShowType() == 2) {
                    this.usernickView.setVisibility(0);
                } else {
                    this.usernickView.setVisibility(itemStyle.isShowNickname() && this.message.direct() == EMMessage.Direct.RECEIVE ? 0 : 8);
                }
            }
            if (this.bubbleLayout != null && this.message.getType() == EMMessage.Type.TXT && itemStyle.getItemMinHeight() != 0) {
                this.bubbleLayout.setMinimumHeight(itemStyle.getItemMinHeight());
            }
        }
    }

    private EaseChatItemStyleHelper getItemStyleHelper() {
        return EaseChatItemStyleHelper.getInstance();
    }

    protected void setAvatarOptions(EaseChatSetStyle itemStyle) {
        if (itemStyle.isShowAvatar()) {
            EaseAvatarOptions avatarOptions;
            this.userAvatarView.setVisibility(0);
            if (this.userAvatarView instanceof EaseImageView) {
                EaseImageView avatarView = (EaseImageView)this.userAvatarView;
                if (itemStyle.getAvatarDefaultSrc() != null) {
                    avatarView.setImageDrawable(itemStyle.getAvatarDefaultSrc());
                }
                avatarView.setShapeType(itemStyle.getShapeType());
                if (itemStyle.getAvatarSize() != 0.0f) {
                    ViewGroup.LayoutParams params = avatarView.getLayoutParams();
                    params.width = (int)itemStyle.getAvatarSize();
                    params.height = (int)itemStyle.getAvatarSize();
                }
                if (itemStyle.getBorderWidth() != 0.0f) {
                    avatarView.setBorderWidth((int)itemStyle.getBorderWidth());
                }
                if (itemStyle.getBorderColor() != 0) {
                    avatarView.setBorderColor(itemStyle.getBorderColor());
                }
                if (itemStyle.getAvatarRadius() != 0.0f) {
                    avatarView.setRadius((int)itemStyle.getAvatarRadius());
                }
            }
            if ((avatarOptions = this.provideAvatarOptions()) != null && this.userAvatarView instanceof EaseImageView) {
                EaseImageView avatarView = (EaseImageView)this.userAvatarView;
                if (avatarOptions.getAvatarShape() != 0) {
                    avatarView.setShapeType(avatarOptions.getAvatarShape());
                }
                if (avatarOptions.getAvatarBorderWidth() != 0) {
                    avatarView.setBorderWidth(avatarOptions.getAvatarBorderWidth());
                }
                if (avatarOptions.getAvatarBorderColor() != 0) {
                    avatarView.setBorderColor(avatarOptions.getAvatarBorderColor());
                }
                if (avatarOptions.getAvatarRadius() != 0) {
                    avatarView.setRadius(avatarOptions.getAvatarRadius());
                }
            }
        } else {
            this.userAvatarView.setVisibility(8);
        }
    }

    protected EaseAvatarOptions provideAvatarOptions() {
        return EaseIM.getInstance().getAvatarOptions();
    }

    public boolean isSender() {
        return this.isSender;
    }

    protected void setAvatarAndNick() {
        if (this.isSender()) {
            EaseUserUtils.setUserAvatar(this.context, EMClient.getInstance().getCurrentUser(), this.userAvatarView);
            if (EaseChatItemStyleHelper.getInstance().getStyle().getItemShowType() != EaseChatMessageListLayout.ShowType.NORMAL.ordinal()) {
                EaseUserUtils.setUserNick(this.message.getFrom(), this.usernickView);
            }
        } else {
            EaseUserUtils.setUserAvatar(this.context, this.message.getFrom(), this.userAvatarView);
            EaseUserUtils.setUserNick(this.message.getFrom(), this.usernickView);
        }
    }

    protected void setTimestamp(TextView timestamp) {
        if (this.adapter != null) {
            if (this.position == 0) {
                timestamp.setText((CharSequence)EaseDateUtils.getTimestampString(this.getContext(), new Date(this.message.getMsgTime())));
                timestamp.setVisibility(0);
            } else {
                EMMessage prevMessage = null;
                if (this.adapter instanceof BaseAdapter) {
                    prevMessage = (EMMessage)((BaseAdapter)this.adapter).getItem(this.position - 1);
                }
                if (this.adapter instanceof EaseBaseAdapter) {
                    prevMessage = (EMMessage)((EaseBaseAdapter)((Object)this.adapter)).getItem(this.position - 1);
                }
                if (prevMessage != null && EaseDateUtils.isCloseEnough(this.message.getMsgTime(), prevMessage.getMsgTime())) {
                    timestamp.setVisibility(8);
                } else {
                    timestamp.setText((CharSequence)EaseDateUtils.getTimestampString(this.getContext(), new Date(this.message.getMsgTime())));
                    timestamp.setVisibility(0);
                }
            }
        }
    }

    public void setTimestamp(EMMessage preMessage) {
        if (this.position == 0) {
            this.timeStampView.setText((CharSequence)EaseDateUtils.getTimestampString(this.getContext(), new Date(this.message.getMsgTime())));
            this.timeStampView.setVisibility(0);
        } else if (preMessage != null && EaseDateUtils.isCloseEnough(this.message.getMsgTime(), preMessage.getMsgTime())) {
            this.timeStampView.setVisibility(8);
        } else {
            this.timeStampView.setText((CharSequence)EaseDateUtils.getTimestampString(this.getContext(), new Date(this.message.getMsgTime())));
            this.timeStampView.setVisibility(0);
        }
    }

    private void setClickListener() {
        this.chatCallback = new EaseChatCallback();
        if (this.bubbleLayout != null) {
            this.bubbleLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (EaseChatRow.this.itemClickListener != null && EaseChatRow.this.itemClickListener.onBubbleClick(EaseChatRow.this.message)) {
                        return;
                    }
                    if (EaseChatRow.this.itemActionCallback != null) {
                        EaseChatRow.this.itemActionCallback.onBubbleClick(EaseChatRow.this.message);
                    }
                }
            });
            this.bubbleLayout.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    if (EaseChatRow.this.itemClickListener != null) {
                        return EaseChatRow.this.itemClickListener.onBubbleLongClick(v, EaseChatRow.this.message);
                    }
                    return false;
                }
            });
        }
        if (this.statusView != null) {
            this.statusView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (EaseChatRow.this.itemClickListener != null && EaseChatRow.this.itemClickListener.onResendClick(EaseChatRow.this.message)) {
                        return;
                    }
                    if (EaseChatRow.this.itemActionCallback != null) {
                        EaseChatRow.this.itemActionCallback.onResendClick(EaseChatRow.this.message);
                    }
                }
            });
        }
        if (this.userAvatarView != null) {
            this.userAvatarView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (EaseChatRow.this.itemClickListener != null) {
                        if (EaseChatRow.this.message.direct() == EMMessage.Direct.SEND) {
                            EaseChatRow.this.itemClickListener.onUserAvatarClick(EMClient.getInstance().getCurrentUser());
                        } else {
                            EaseChatRow.this.itemClickListener.onUserAvatarClick(EaseChatRow.this.message.getFrom());
                        }
                    }
                }
            });
            this.userAvatarView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    if (EaseChatRow.this.itemClickListener != null) {
                        if (EaseChatRow.this.message.direct() == EMMessage.Direct.SEND) {
                            EaseChatRow.this.itemClickListener.onUserAvatarLongClick(EMClient.getInstance().getCurrentUser());
                        } else {
                            EaseChatRow.this.itemClickListener.onUserAvatarLongClick(EaseChatRow.this.message.getFrom());
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
    }

    protected void onViewUpdate(EMMessage msg) {
        switch (msg.status()) {
            case CREATE: {
                this.onMessageCreate();
                if (this.itemClickListener == null) break;
                this.itemClickListener.onMessageCreate(msg);
                break;
            }
            case SUCCESS: {
                this.onMessageSuccess();
                break;
            }
            case FAIL: {
                this.onMessageError();
                break;
            }
            case INPROGRESS: {
                this.onMessageInProgress();
                break;
            }
            default: {
                EMLog.i((String)TAG, (String)"default");
            }
        }
    }

    protected void onMessageCreate() {
        EMLog.i((String)TAG, (String)"onMessageCreate");
    }

    protected void onMessageSuccess() {
        EMLog.i((String)TAG, (String)"onMessageSuccess");
    }

    protected void onMessageError() {
        if (this.ackedView != null) {
            this.ackedView.setVisibility(4);
        }
        if (this.deliveredView != null) {
            this.deliveredView.setVisibility(4);
        }
        EMLog.e((String)TAG, (String)"onMessageError");
    }

    protected void onMessageInProgress() {
        EMLog.i((String)TAG, (String)"onMessageInProgress");
    }

    protected abstract void onInflateView();

    protected abstract void onFindViewById();

    protected abstract void onSetUpView();

    public static interface EaseChatRowActionCallback {
        public void onResendClick(EMMessage var1);

        public void onBubbleClick(EMMessage var1);

        public void onDetachedFromWindow();
    }

    private class EaseChatCallback
    implements EMCallBack {
        private EaseChatCallback() {
        }

        public void onSuccess() {
            EaseChatRow.this.mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    EaseChatRow.this.onMessageSuccess();
                    if (EaseChatRow.this.itemClickListener != null) {
                        EaseChatRow.this.itemClickListener.onMessageSuccess(EaseChatRow.this.message);
                    }
                }
            });
        }

        public void onError(final int code, final String error) {
            EaseChatRow.this.mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    EaseChatRow.this.onMessageError();
                    if (EaseChatRow.this.itemClickListener != null) {
                        EaseChatRow.this.itemClickListener.onMessageError(EaseChatRow.this.message, code, error);
                    }
                }
            });
        }

        public void onProgress(final int progress, String status) {
            EaseChatRow.this.mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    EaseChatRow.this.onMessageInProgress();
                    if (EaseChatRow.this.itemClickListener != null) {
                        EaseChatRow.this.itemClickListener.onMessageInProgress(EaseChatRow.this.message, progress);
                    }
                }
            });
        }
    }
}

