/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.core.content.ContextCompat;
import com.hyphenate.easeui.R;

public class EaseSearchTextView
extends AppCompatTextView {
    private Context mContext;
    private float mLeftHeight;
    private float mLeftWidth;
    private float mRightHeight;
    private float mRightWidth;
    private float DEFAULT_SIZE = this.dip2px(18.0f);
    private int DEFAULT_DRAWABLE_PADDING = (int)this.dip2px(6.0f);

    public EaseSearchTextView(Context context) {
        this(context, null);
    }

    public EaseSearchTextView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EaseSearchTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.EaseSearchTextView);
            this.mLeftHeight = ta.getDimension(R.styleable.EaseSearchTextView_search_drawable_left_height, this.DEFAULT_SIZE);
            this.mLeftWidth = ta.getDimension(R.styleable.EaseSearchTextView_search_drawable_left_width, this.DEFAULT_SIZE);
            this.mRightHeight = ta.getDimension(R.styleable.EaseSearchTextView_search_drawable_right_height, 0.0f);
            this.mRightWidth = ta.getDimension(R.styleable.EaseSearchTextView_search_drawable_right_width, 0.0f);
            ta.recycle();
        }
        this.setGravity(16);
        CharSequence hint = this.getHint();
        if (TextUtils.isEmpty((CharSequence)hint)) {
            this.setHint(this.getResources().getString(R.string.ease_search_text_hint));
        }
        this.setDrawable();
    }

    private void setDrawable() {
        int drawablePadding;
        Drawable[] existingRel;
        if (Build.VERSION.SDK_INT >= 17 && ((existingRel = this.getCompoundDrawablesRelative())[0] != null || existingRel[2] != null)) {
            this.setCompoundDrawablesRelativeWithIntrinsicBounds(existingRel[0], existingRel[1], existingRel[2], existingRel[3]);
            return;
        }
        Drawable[] existingAbs = this.getCompoundDrawables();
        Drawable left = existingAbs[0];
        Drawable right = existingAbs[2];
        if (left == null) {
            left = ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.ease_search_icon);
        }
        if (left != null && this.mLeftWidth != 0.0f && this.mLeftHeight != 0.0f) {
            left.setBounds(0, 0, (int)this.mLeftWidth, (int)this.mLeftHeight);
        }
        if (right != null && this.mRightWidth != 0.0f && this.mRightHeight != 0.0f) {
            right.setBounds(0, 0, (int)this.mRightWidth, (int)this.mRightHeight);
        }
        this.setCompoundDrawables(left != null ? left : existingAbs[0], existingAbs[1], right != null ? right : existingAbs[2], existingAbs[3]);
        Drawable background = this.getBackground();
        if (background == null) {
            background = ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.ease_search_bg_shape);
            this.setBackground(background);
        }
        if ((drawablePadding = this.getCompoundDrawablePadding()) == 0) {
            drawablePadding = this.DEFAULT_DRAWABLE_PADDING;
            this.setCompoundDrawablePadding(drawablePadding);
        }
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        if (paddingLeft == 0 || paddingRight == 0) {
            this.setPadding((int)this.dip2px(16.0f), paddingTop, (int)this.dip2px(16.0f), paddingBottom);
        }
    }

    private float dip2px(float value) {
        return TypedValue.applyDimension((int)1, (float)value, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
    }
}

