/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.EditText;
import com.hyphenate.easeui.R;

public class EaseSearchEditText
extends EditText {
    private float mLeftHeight;
    private float mLeftWidth;
    private float mRightHeight;
    private float mRightWidth;

    public EaseSearchEditText(Context context) {
        this(context, null);
    }

    public EaseSearchEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EaseSearchEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.EaseSearchEditText);
            this.mLeftHeight = ta.getDimension(R.styleable.EaseSearchEditText_search_edit_drawable_left_height, 0.0f);
            this.mLeftWidth = ta.getDimension(R.styleable.EaseSearchEditText_search_edit_drawable_left_width, 0.0f);
            this.mRightHeight = ta.getDimension(R.styleable.EaseSearchEditText_search_edit_drawable_right_height, 0.0f);
            this.mRightWidth = ta.getDimension(R.styleable.EaseSearchEditText_search_edit_drawable_right_width, 0.0f);
            ta.recycle();
        }
        this.requestFocus();
        this.setDrawables();
    }

    private void setDrawables() {
        Drawable[] existingAbs = this.getCompoundDrawables();
        Drawable left = existingAbs[0];
        Drawable right = existingAbs[2];
        if (left != null && this.mLeftWidth != 0.0f && this.mLeftHeight != 0.0f) {
            left.setBounds(0, 0, (int)this.mLeftWidth, (int)this.mLeftHeight);
        }
        if (right != null) {
            right.setBounds(0, 0, 0, 0);
        }
        this.setCompoundDrawables(left != null ? left : existingAbs[0], existingAbs[1], right != null ? right : existingAbs[2], existingAbs[3]);
    }
}

