/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMImageMessageBody;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMMessageBody;
import com.hyphenate.chat.EMVideoMessageBody;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.utils.EaseCommonUtils;
import com.hyphenate.easeui.utils.EaseFileUtils;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.ImageUtils;
import com.hyphenate.util.PathUtil;

public class EaseImageUtils
extends ImageUtils {
    public static String getImagePath(String remoteUrl) {
        String imageName = remoteUrl.substring(remoteUrl.lastIndexOf("/") + 1, remoteUrl.length());
        String path = PathUtil.getInstance().getImagePath() + "/" + imageName;
        EMLog.d((String)"msg", (String)("image path:" + path));
        return path;
    }

    public static String getImagePathByFileName(String filename) {
        String path = PathUtil.getInstance().getImagePath() + "/" + filename;
        EMLog.d((String)"msg", (String)("image path:" + path));
        return path;
    }

    public static String getThumbnailImagePath(String thumbRemoteUrl) {
        String thumbImageName = thumbRemoteUrl.substring(thumbRemoteUrl.lastIndexOf("/") + 1, thumbRemoteUrl.length());
        String path = PathUtil.getInstance().getImagePath() + "/th" + thumbImageName;
        EMLog.d((String)"msg", (String)("thum image path:" + path));
        return path;
    }

    public static String getThumbnailImagePathByName(String filename) {
        String path = PathUtil.getInstance().getImagePath() + "/th" + filename;
        EMLog.d((String)"msg", (String)("thum image dgdfg path:" + path));
        return path;
    }

    public static int[] getImageMaxSize(Context context) {
        float[] screenInfo = EaseCommonUtils.getScreenInfo(context);
        int[] maxSize = new int[2];
        if (screenInfo != null) {
            maxSize[0] = (int)(screenInfo[0] / 3.0f);
            maxSize[1] = (int)(screenInfo[0] / 2.0f);
        }
        return maxSize;
    }

    public static ViewGroup.LayoutParams showVideoThumb(Context context, ImageView imageView, EMMessage message) {
        EMMessageBody body = message.getBody();
        if (!(body instanceof EMVideoMessageBody)) {
            return imageView.getLayoutParams();
        }
        int width = ((EMVideoMessageBody)body).getThumbnailWidth();
        int height = ((EMVideoMessageBody)body).getThumbnailHeight();
        Uri localThumbUri = ((EMVideoMessageBody)body).getLocalThumbUri();
        EaseFileUtils.takePersistableUriPermission(context, localThumbUri);
        String thumbnailUrl = ((EMVideoMessageBody)body).getThumbnailUrl();
        if (!EaseFileUtils.isFileExistByUri(context, localThumbUri)) {
            localThumbUri = null;
        }
        return EaseImageUtils.showImage(context, imageView, localThumbUri, thumbnailUrl, width, height);
    }

    public static ViewGroup.LayoutParams getImageShowSize(Context context, EMMessage message) {
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-2, -2);
        EMMessageBody body = message.getBody();
        if (!(body instanceof EMImageMessageBody)) {
            return params;
        }
        int width = ((EMImageMessageBody)body).getWidth();
        int height = ((EMImageMessageBody)body).getHeight();
        Uri imageUri = ((EMImageMessageBody)body).getLocalUri();
        if (!EaseFileUtils.isFileExistByUri(context, imageUri) && !EaseFileUtils.isFileExistByUri(context, imageUri = ((EMImageMessageBody)body).thumbnailLocalUri())) {
            imageUri = null;
        }
        if (width == 0 || height == 0) {
            BitmapFactory.Options options = null;
            try {
                options = ImageUtils.getBitmapOptions((Context)context, (Uri)imageUri);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (options != null) {
                width = options.outWidth;
                height = options.outHeight;
            }
        }
        int[] maxSize = EaseImageUtils.getImageMaxSize(context);
        int maxWidth = maxSize[0];
        int maxHeight = maxSize[1];
        float mRadio = (float)maxWidth * 1.0f / (float)maxHeight;
        float radio = (float)width * 1.0f / (float)(height == 0 ? 1 : height);
        if (radio == 0.0f) {
            radio = 1.0f;
        }
        if (maxHeight == 0 && maxWidth == 0) {
            return params;
        }
        if (mRadio / radio < 0.1f) {
            params.width = maxWidth;
            params.height = maxWidth / 2;
        } else if (mRadio / radio > 4.0f) {
            params.width = maxHeight / 2;
            params.height = maxHeight;
        } else if (radio < mRadio) {
            params.height = maxHeight;
            params.width = (int)((float)maxHeight * radio);
        } else {
            params.width = maxWidth;
            params.height = (int)((float)maxWidth / radio);
        }
        return params;
    }

    public static ViewGroup.LayoutParams showImage(Context context, ImageView imageView, EMMessage message) {
        EMMessageBody body = message.getBody();
        if (!(body instanceof EMImageMessageBody)) {
            return imageView.getLayoutParams();
        }
        int width = ((EMImageMessageBody)body).getWidth();
        int height = ((EMImageMessageBody)body).getHeight();
        Uri imageUri = ((EMImageMessageBody)body).getLocalUri();
        EaseFileUtils.takePersistableUriPermission(context, imageUri);
        EMLog.e((String)"tag", (String)("current show small view big file: uri:" + imageUri + " exist: " + EaseFileUtils.isFileExistByUri(context, imageUri)));
        if (!EaseFileUtils.isFileExistByUri(context, imageUri)) {
            imageUri = ((EMImageMessageBody)body).thumbnailLocalUri();
            EaseFileUtils.takePersistableUriPermission(context, imageUri);
            EMLog.e((String)"tag", (String)("current show small view thumbnail file: uri:" + imageUri + " exist: " + EaseFileUtils.isFileExistByUri(context, imageUri)));
            if (!EaseFileUtils.isFileExistByUri(context, imageUri)) {
                imageUri = null;
            }
        }
        if (width == 0 || height == 0) {
            BitmapFactory.Options options = null;
            try {
                options = ImageUtils.getBitmapOptions((Context)context, (Uri)imageUri);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (options != null) {
                width = options.outWidth;
                height = options.outHeight;
            }
        }
        String thumbnailUrl = null;
        if (EMClient.getInstance().getOptions().getAutodownloadThumbnail() && TextUtils.isEmpty((CharSequence)(thumbnailUrl = ((EMImageMessageBody)body).getThumbnailUrl()))) {
            thumbnailUrl = ((EMImageMessageBody)body).getRemoteUrl();
        }
        return EaseImageUtils.showImage(context, imageView, imageUri, thumbnailUrl, width, height);
    }

    public static ViewGroup.LayoutParams showImage(Context context, ImageView imageView, Uri imageUri, String imageUrl, int imgWidth, int imgHeight) {
        int[] maxSize = EaseImageUtils.getImageMaxSize(context);
        int maxWidth = maxSize[0];
        int maxHeight = maxSize[1];
        float mRadio = (float)maxWidth * 1.0f / (float)maxHeight;
        imageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
        float radio = (float)imgWidth * 1.0f / (float)(imgHeight == 0 ? 1 : imgHeight);
        if (radio == 0.0f) {
            radio = 1.0f;
        }
        if (maxHeight == 0 && maxWidth == 0) {
            if (context instanceof Activity && (((Activity)context).isFinishing() || ((Activity)context).isDestroyed())) {
                return imageView.getLayoutParams();
            }
            ((RequestBuilder)Glide.with((Context)context).load((Object)(imageUri == null ? imageUrl : imageUri)).diskCacheStrategy(DiskCacheStrategy.ALL)).into(imageView);
            return imageView.getLayoutParams();
        }
        ViewGroup.LayoutParams params = imageView.getLayoutParams();
        if (mRadio / radio < 0.1f) {
            imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
            params.width = maxWidth;
            params.height = maxWidth / 2;
        } else if (mRadio / radio > 4.0f) {
            imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
            params.width = maxHeight / 2;
            params.height = maxHeight;
        } else if (radio < mRadio) {
            params.height = maxHeight;
            params.width = (int)((float)maxHeight * radio);
        } else {
            params.width = maxWidth;
            params.height = (int)((float)maxWidth / radio);
        }
        if (context instanceof Activity && (((Activity)context).isFinishing() || ((Activity)context).isDestroyed())) {
            return params;
        }
        ((RequestBuilder)((RequestBuilder)Glide.with((Context)context).load((Object)(imageUri == null ? imageUrl : imageUri)).apply(new RequestOptions().error(R.drawable.ease_default_image)).diskCacheStrategy(DiskCacheStrategy.ALL)).override(params.width, params.height)).into(imageView);
        return params;
    }
}

