/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.widget;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.hyphenate.easeui.R;

public class EaseAlertDialog
extends Dialog {
    private String title;
    private String msg;
    private AlertDialogUser user;
    private Bundle bundle;
    private boolean showCancel = false;

    public EaseAlertDialog(Context context, int msgId) {
        super(context);
        this.title = context.getResources().getString(R.string.prompt);
        this.msg = context.getResources().getString(msgId);
        this.setCanceledOnTouchOutside(true);
    }

    public EaseAlertDialog(Context context, String msg) {
        super(context);
        this.title = context.getResources().getString(R.string.prompt);
        this.msg = msg;
        this.setCanceledOnTouchOutside(true);
    }

    public EaseAlertDialog(Context context, int titleId, int msgId) {
        super(context);
        this.title = context.getResources().getString(titleId);
        this.msg = context.getResources().getString(msgId);
        this.setCanceledOnTouchOutside(true);
    }

    public EaseAlertDialog(Context context, String title, String msg) {
        super(context);
        this.title = title;
        this.msg = msg;
        this.setCanceledOnTouchOutside(true);
    }

    public EaseAlertDialog(Context context, int titleId, int msgId, Bundle bundle, AlertDialogUser user, boolean showCancel) {
        super(context);
        this.title = context.getResources().getString(titleId);
        this.msg = context.getResources().getString(msgId);
        this.user = user;
        this.bundle = bundle;
        this.showCancel = showCancel;
        this.setCanceledOnTouchOutside(true);
    }

    public EaseAlertDialog(Context context, String title, String msg, Bundle bundle, AlertDialogUser user, boolean showCancel) {
        super(context);
        this.title = title;
        this.msg = msg;
        this.user = user;
        this.bundle = bundle;
        this.showCancel = showCancel;
        this.setCanceledOnTouchOutside(true);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.setContentView(R.layout.ease_alert_dialog);
        Button cancel = (Button)this.findViewById(R.id.btn_cancel);
        Button ok = (Button)this.findViewById(R.id.btn_ok);
        TextView titleView = (TextView)this.findViewById(R.id.title);
        this.setTitle(this.title);
        View.OnClickListener listener = new View.OnClickListener(){

            public void onClick(View view) {
                if (view.getId() == R.id.btn_ok) {
                    EaseAlertDialog.this.onOk(view);
                } else if (view.getId() == R.id.btn_cancel) {
                    EaseAlertDialog.this.onCancel(view);
                }
            }
        };
        cancel.setOnClickListener(listener);
        ok.setOnClickListener(listener);
        if (this.title != null) {
            titleView.setText((CharSequence)this.title);
        }
        if (this.showCancel) {
            cancel.setVisibility(0);
        }
        if (this.msg != null) {
            ((TextView)this.findViewById(R.id.alert_message)).setText((CharSequence)this.msg);
        }
    }

    public void onOk(View view) {
        this.dismiss();
        if (this.user != null) {
            this.user.onResult(true, this.bundle);
        }
    }

    public void onCancel(View view) {
        this.dismiss();
        if (this.user != null) {
            this.user.onResult(false, this.bundle);
        }
    }

    public static interface AlertDialogUser {
        public void onResult(boolean var1, Bundle var2);
    }
}

