/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.utils;

import android.icu.text.Transliterator;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;

public class HanziToPinyin {
    private static final String TAG = "HanziToPinyin";
    private static HanziToPinyin sInstance;
    private Transliterator mPinyinTransliterator;
    private Transliterator mAsciiTransliterator;

    private HanziToPinyin() {
        try {
            this.mPinyinTransliterator = Transliterator.getInstance((String)"Han-Latin/Names; Latin-Ascii; Any-Upper");
            this.mAsciiTransliterator = Transliterator.getInstance((String)"Latin-Ascii");
        }
        catch (IllegalArgumentException e) {
            Log.w((String)TAG, (String)"Han-Latin/Names transliterator data is missing, HanziToPinyin is disabled");
        }
    }

    public boolean hasChineseTransliterator() {
        return this.mPinyinTransliterator != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HanziToPinyin getInstance() {
        Class<HanziToPinyin> clazz = HanziToPinyin.class;
        synchronized (HanziToPinyin.class) {
            if (sInstance == null) {
                sInstance = new HanziToPinyin();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private void tokenize(char character, Token token) {
        token.source = Character.toString(character);
        if (character < '\u0080') {
            token.type = 1;
            token.target = token.source;
            return;
        }
        if (character < '\u0250' || '\u1e00' <= character && character < '\u1eff') {
            token.type = 1;
            token.target = this.mAsciiTransliterator == null ? token.source : this.mAsciiTransliterator.transliterate(token.source);
            return;
        }
        token.type = 2;
        token.target = this.mPinyinTransliterator.transliterate(token.source);
        if (TextUtils.isEmpty((CharSequence)token.target) || TextUtils.equals((CharSequence)token.source, (CharSequence)token.target)) {
            token.type = 3;
            token.target = token.source;
        }
    }

    public String transliterate(String input) {
        if (!this.hasChineseTransliterator() || TextUtils.isEmpty((CharSequence)input)) {
            return null;
        }
        return this.mPinyinTransliterator.transliterate(input);
    }

    public ArrayList<Token> get(String input) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        if (!this.hasChineseTransliterator() || TextUtils.isEmpty((CharSequence)input)) {
            return tokens;
        }
        int inputLength = input.length();
        StringBuilder sb = new StringBuilder();
        int tokenType = 1;
        Token token = new Token();
        for (int i = 0; i < inputLength; ++i) {
            char character = input.charAt(i);
            if (Character.isSpaceChar(character)) {
                if (sb.length() <= 0) continue;
                this.addToken(sb, tokens, tokenType);
                continue;
            }
            this.tokenize(character, token);
            if (token.type == 2) {
                if (sb.length() > 0) {
                    this.addToken(sb, tokens, tokenType);
                }
                tokens.add(token);
                token = new Token();
            } else {
                if (tokenType != token.type && sb.length() > 0) {
                    this.addToken(sb, tokens, tokenType);
                }
                sb.append(token.target);
            }
            tokenType = token.type;
        }
        if (sb.length() > 0) {
            this.addToken(sb, tokens, tokenType);
        }
        return tokens;
    }

    private void addToken(StringBuilder sb, ArrayList<Token> tokens, int tokenType) {
        String str = sb.toString();
        tokens.add(new Token(tokenType, str, str));
        sb.setLength(0);
    }

    public static class Token {
        public static final String SEPARATOR = " ";
        public static final int LATIN = 1;
        public static final int PINYIN = 2;
        public static final int UNKNOWN = 3;
        public int type;
        public String source;
        public String target;

        public Token() {
        }

        public Token(int type, String source, String target) {
            this.type = type;
            this.source = source;
            this.target = target;
        }
    }
}

