/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.ui;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.Toast;
import com.hyphenate.EMCallBack;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMVideoMessageBody;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.ui.EaseShowLocalVideoActivity;
import com.hyphenate.easeui.ui.base.EaseBaseActivity;
import com.hyphenate.easeui.utils.EaseFileUtils;
import com.hyphenate.util.EMLog;
import java.io.File;

public class EaseShowVideoActivity
extends EaseBaseActivity {
    private static final String TAG = "ShowVideoActivity";
    private RelativeLayout loadingLayout;
    private ProgressBar progressBar;
    private Uri localFilePath;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.setContentView(R.layout.ease_showvideo_activity);
        this.loadingLayout = (RelativeLayout)this.findViewById(R.id.loading_layout);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progressBar);
        EMMessage message = (EMMessage)this.getIntent().getParcelableExtra("msg");
        if (!(message.getBody() instanceof EMVideoMessageBody)) {
            Toast.makeText((Context)this, (CharSequence)"Unsupported message body", (int)0).show();
            this.finish();
            return;
        }
        EMVideoMessageBody messageBody = (EMVideoMessageBody)message.getBody();
        this.localFilePath = messageBody.getLocalUri();
        EMLog.d((String)TAG, (String)("localFilePath = " + this.localFilePath));
        EMLog.d((String)TAG, (String)("local filename = " + messageBody.getFileName()));
        EaseFileUtils.takePersistableUriPermission((Context)this, this.localFilePath);
        if (EaseFileUtils.isFileExistByUri((Context)this, this.localFilePath)) {
            this.showLocalVideo(this.localFilePath);
        } else {
            EMLog.d((String)TAG, (String)"download remote video file");
            this.downloadVideo(message);
        }
    }

    private void showLocalVideo(Uri videoUri) {
        EaseShowLocalVideoActivity.actionStart((Context)this, videoUri.toString());
        this.finish();
    }

    private void downloadVideo(final EMMessage message) {
        this.loadingLayout.setVisibility(0);
        message.setMessageStatusCallback(new EMCallBack(){

            public void onSuccess() {
                EaseShowVideoActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        EaseShowVideoActivity.this.loadingLayout.setVisibility(8);
                        EaseShowVideoActivity.this.progressBar.setProgress(0);
                        EaseShowVideoActivity.this.showLocalVideo(((EMVideoMessageBody)message.getBody()).getLocalUri());
                    }
                });
            }

            public void onProgress(final int progress, String status) {
                Log.d((String)"ease", (String)("video progress:" + progress));
                EaseShowVideoActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        EaseShowVideoActivity.this.progressBar.setProgress(progress);
                    }
                });
            }

            public void onError(final int error, String msg) {
                Log.e((String)"###", (String)("offline file transfer error:" + msg));
                Uri localFilePath = ((EMVideoMessageBody)message.getBody()).getLocalUri();
                String filePath = EaseFileUtils.getFilePath((Context)EaseShowVideoActivity.this, localFilePath);
                if (TextUtils.isEmpty((CharSequence)filePath)) {
                    EaseShowVideoActivity.this.getContentResolver().delete(localFilePath, null, null);
                } else {
                    File file = new File(filePath);
                    if (file.exists()) {
                        file.delete();
                    }
                }
                EaseShowVideoActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (error == 400) {
                            Toast.makeText((Context)EaseShowVideoActivity.this.getApplicationContext(), (int)R.string.Video_expired, (int)0).show();
                        }
                    }
                });
            }
        });
        EMClient.getInstance().chatManager().downloadAttachment(message);
    }

    public void onBackPressed() {
        this.finish();
    }
}

