/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.player;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Matrix;
import android.graphics.PorterDuff;
import android.graphics.SurfaceTexture;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.CheckResult;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.player.EasyIUserMethods;
import com.hyphenate.easeui.player.EasyVideoCallback;
import com.hyphenate.easeui.player.EasyVideoProgressCallback;
import com.hyphenate.easeui.player.Util;
import java.io.IOException;

public class EasyVideoPlayer
extends FrameLayout
implements EasyIUserMethods,
TextureView.SurfaceTextureListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnVideoSizeChangedListener,
MediaPlayer.OnErrorListener,
View.OnClickListener,
SeekBar.OnSeekBarChangeListener {
    private static final int UPDATE_INTERVAL = 100;
    private TextureView mTextureView;
    private Surface mSurface;
    private View mControlsFrame;
    private View mClickFrame;
    private SeekBar mSeeker;
    private TextView mLabelPosition;
    private TextView mLabelDuration;
    private ImageButton mBtnPlayPause;
    private MediaPlayer mPlayer;
    private boolean mSurfaceAvailable;
    private boolean mIsPrepared;
    private boolean mWasPlaying;
    private int mInitialTextureWidth;
    private int mInitialTextureHeight;
    private Handler mHandler;
    private Uri mSource;
    private EasyVideoCallback mCallback;
    private EasyVideoProgressCallback mProgressCallback;
    private Drawable mPlayDrawable;
    private Drawable mPauseDrawable;
    private boolean mHideControlsOnPlay = true;
    private boolean mAutoPlay;
    private int mInitialPosition = -1;
    private boolean mControlsDisabled;
    private int mThemeColor = 0;
    private boolean mAutoFullscreen = false;
    private boolean mLoop = false;
    private int currentPos;
    private final Runnable mUpdateCounters = new Runnable(){

        @Override
        public void run() {
            if (EasyVideoPlayer.this.mHandler == null || !EasyVideoPlayer.this.mIsPrepared || EasyVideoPlayer.this.mSeeker == null || EasyVideoPlayer.this.mPlayer == null) {
                return;
            }
            int pos = EasyVideoPlayer.this.mPlayer.getCurrentPosition();
            int dur = EasyVideoPlayer.this.mPlayer.getDuration();
            if ("oppo".equals(Build.BRAND.toLowerCase()) && "OPPO R9sk".equals(Build.MODEL) && pos <= EasyVideoPlayer.this.currentPos) {
                pos = EasyVideoPlayer.this.currentPos;
            }
            if (pos > dur) {
                pos = dur;
            }
            EasyVideoPlayer.this.mLabelPosition.setText((CharSequence)Util.getDurationString(pos, false));
            EasyVideoPlayer.this.mLabelDuration.setText((CharSequence)Util.getDurationString(dur, false));
            EasyVideoPlayer.this.mSeeker.setProgress(pos);
            EasyVideoPlayer.this.mSeeker.setMax(dur);
            if (EasyVideoPlayer.this.mProgressCallback != null) {
                EasyVideoPlayer.this.mProgressCallback.onVideoProgressUpdate(pos, dur);
            }
            if (EasyVideoPlayer.this.mHandler != null) {
                EasyVideoPlayer.this.mHandler.postDelayed((Runnable)this, 100L);
            }
        }
    };

    public EasyVideoPlayer(Context context) {
        super(context);
        this.init(context, null);
    }

    public EasyVideoPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public EasyVideoPlayer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        AppCompatDelegate.setCompatVectorFromResourcesEnabled((boolean)true);
        this.setBackgroundColor(-16777216);
        if (attrs != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.EasyVideoPlayer, 0, 0);
            try {
                String source = a.getString(R.styleable.EasyVideoPlayer_easy_source);
                if (source != null && !source.trim().isEmpty()) {
                    this.mSource = Uri.parse((String)source);
                }
                int playDrawableResId = a.getResourceId(R.styleable.EasyVideoPlayer_easy_playDrawable, -1);
                int pauseDrawableResId = a.getResourceId(R.styleable.EasyVideoPlayer_easy_pauseDrawable, -1);
                if (playDrawableResId != -1) {
                    this.mPlayDrawable = AppCompatResources.getDrawable((Context)context, (int)playDrawableResId);
                }
                if (pauseDrawableResId != -1) {
                    this.mPauseDrawable = AppCompatResources.getDrawable((Context)context, (int)pauseDrawableResId);
                }
                this.mHideControlsOnPlay = a.getBoolean(R.styleable.EasyVideoPlayer_easy_hideControlsOnPlay, true);
                this.mAutoPlay = a.getBoolean(R.styleable.EasyVideoPlayer_easy_autoPlay, false);
                this.mControlsDisabled = a.getBoolean(R.styleable.EasyVideoPlayer_easy_disableControls, false);
                this.mThemeColor = a.getColor(R.styleable.EasyVideoPlayer_easy_themeColor, Util.resolveColor(context, R.attr.colorPrimary));
                this.mAutoFullscreen = a.getBoolean(R.styleable.EasyVideoPlayer_easy_autoFullscreen, false);
                this.mLoop = a.getBoolean(R.styleable.EasyVideoPlayer_easy_loop, false);
            }
            finally {
                a.recycle();
            }
        } else {
            this.mHideControlsOnPlay = true;
            this.mAutoPlay = false;
            this.mControlsDisabled = false;
            this.mThemeColor = Util.resolveColor(context, R.attr.colorPrimary);
            this.mAutoFullscreen = false;
            this.mLoop = false;
        }
        if (this.mPlayDrawable == null) {
            this.mPlayDrawable = AppCompatResources.getDrawable((Context)context, (int)R.drawable.easy_action_play);
        }
        if (this.mPauseDrawable == null) {
            this.mPauseDrawable = AppCompatResources.getDrawable((Context)context, (int)R.drawable.easy_action_pause);
        }
    }

    @Override
    public void setSource(@NonNull Uri source) {
        boolean hadSource;
        boolean bl = hadSource = this.mSource != null;
        if (hadSource) {
            this.stop();
        }
        this.mSource = source;
        if (this.mPlayer != null) {
            if (hadSource) {
                this.sourceChanged();
            } else {
                this.prepare();
            }
        }
    }

    @Override
    public void setCallback(@NonNull EasyVideoCallback callback) {
        this.mCallback = callback;
    }

    @Override
    public void setProgressCallback(@NonNull EasyVideoProgressCallback callback) {
        this.mProgressCallback = callback;
    }

    @Override
    public void setPlayDrawable(@NonNull Drawable drawable2) {
        this.mPlayDrawable = drawable2;
        if (!this.isPlaying()) {
            this.mBtnPlayPause.setImageDrawable(drawable2);
        }
    }

    @Override
    public void setPlayDrawableRes(@DrawableRes int res) {
        this.setPlayDrawable(AppCompatResources.getDrawable((Context)this.getContext(), (int)res));
    }

    @Override
    public void setPauseDrawable(@NonNull Drawable drawable2) {
        this.mPauseDrawable = drawable2;
        if (this.isPlaying()) {
            this.mBtnPlayPause.setImageDrawable(drawable2);
        }
    }

    @Override
    public void setPauseDrawableRes(@DrawableRes int res) {
        this.setPauseDrawable(AppCompatResources.getDrawable((Context)this.getContext(), (int)res));
    }

    @Override
    public void setThemeColor(@ColorInt int color2) {
        this.mThemeColor = color2;
        this.invalidateThemeColors();
    }

    @Override
    public void setThemeColorRes(@ColorRes int colorRes) {
        this.setThemeColor(ContextCompat.getColor((Context)this.getContext(), (int)colorRes));
    }

    @Override
    public void setHideControlsOnPlay(boolean hide) {
        this.mHideControlsOnPlay = hide;
    }

    @Override
    public void setAutoPlay(boolean autoPlay) {
        this.mAutoPlay = autoPlay;
    }

    @Override
    public void setInitialPosition(@IntRange(from=0L, to=0x7FFFFFFFL) int pos) {
        this.mInitialPosition = pos;
    }

    private void sourceChanged() {
        this.setControlsEnabled(false);
        this.mSeeker.setProgress(0);
        this.mSeeker.setEnabled(false);
        this.mPlayer.reset();
        if (this.mCallback != null) {
            this.mCallback.onPreparing(this);
        }
        try {
            this.setSourceInternal();
        }
        catch (IOException e) {
            this.throwError(e);
        }
    }

    private void setSourceInternal() throws IOException {
        if (this.mSource.getScheme() != null && (this.mSource.getScheme().equals("http") || this.mSource.getScheme().equals("https"))) {
            EasyVideoPlayer.LOG("Loading web URI: " + this.mSource.toString(), new Object[0]);
            this.mPlayer.setDataSource(this.mSource.toString());
        } else if (this.mSource.getScheme() != null && this.mSource.getScheme().equals("file") && this.mSource.getPath().contains("/android_assets/")) {
            EasyVideoPlayer.LOG("Loading assets URI: " + this.mSource.toString(), new Object[0]);
            AssetFileDescriptor afd = this.getContext().getAssets().openFd(this.mSource.toString().replace("file:///android_assets/", ""));
            this.mPlayer.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
            afd.close();
        } else if (this.mSource.getScheme() != null && this.mSource.getScheme().equals("asset")) {
            EasyVideoPlayer.LOG("Loading assets URI: " + this.mSource.toString(), new Object[0]);
            AssetFileDescriptor afd = this.getContext().getAssets().openFd(this.mSource.toString().replace("asset://", ""));
            this.mPlayer.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
            afd.close();
        } else {
            EasyVideoPlayer.LOG("Loading local URI: " + this.mSource.toString(), new Object[0]);
            this.mPlayer.setDataSource(this.getContext(), this.mSource);
        }
        this.mPlayer.prepareAsync();
    }

    private void prepare() {
        if (!this.mSurfaceAvailable || this.mSource == null || this.mPlayer == null || this.mIsPrepared) {
            return;
        }
        if (this.mCallback != null) {
            this.mCallback.onPreparing(this);
        }
        try {
            this.mPlayer.setSurface(this.mSurface);
            this.setSourceInternal();
        }
        catch (IOException e) {
            this.throwError(e);
        }
    }

    private void setControlsEnabled(boolean enabled) {
        if (this.mSeeker == null) {
            return;
        }
        this.mSeeker.setEnabled(enabled);
        this.mBtnPlayPause.setEnabled(enabled);
        float disabledAlpha = 0.4f;
        this.mBtnPlayPause.setAlpha(enabled ? 1.0f : 0.4f);
        this.mClickFrame.setEnabled(enabled);
    }

    @Override
    public void showControls() {
        if (this.mControlsDisabled || this.isControlsShown() || this.mSeeker == null) {
            return;
        }
        this.mControlsFrame.animate().cancel();
        this.mControlsFrame.setAlpha(0.0f);
        this.mControlsFrame.setVisibility(0);
        this.mBtnPlayPause.setVisibility(0);
        this.mControlsFrame.animate().alpha(1.0f).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (EasyVideoPlayer.this.mAutoFullscreen) {
                    EasyVideoPlayer.this.setFullscreen(false);
                }
            }
        }).start();
    }

    @Override
    public void hideControls() {
        if (this.mControlsDisabled || !this.isControlsShown() || this.mSeeker == null) {
            return;
        }
        this.mControlsFrame.animate().cancel();
        this.mControlsFrame.setAlpha(1.0f);
        this.mControlsFrame.setVisibility(0);
        this.mControlsFrame.animate().alpha(0.0f).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                EasyVideoPlayer.this.setFullscreen(true);
                if (EasyVideoPlayer.this.mControlsFrame != null) {
                    EasyVideoPlayer.this.mControlsFrame.setVisibility(4);
                    EasyVideoPlayer.this.mBtnPlayPause.setVisibility(4);
                }
            }
        }).start();
    }

    @Override
    @CheckResult
    public boolean isControlsShown() {
        return !this.mControlsDisabled && this.mControlsFrame != null && this.mControlsFrame.getAlpha() > 0.5f;
    }

    @Override
    public void toggleControls() {
        if (this.mControlsDisabled) {
            return;
        }
        if (this.isControlsShown()) {
            this.hideControls();
        } else {
            this.showControls();
        }
    }

    @Override
    public void enableControls(boolean andShow) {
        this.mControlsDisabled = false;
        if (andShow) {
            this.showControls();
        }
        this.mClickFrame.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                EasyVideoPlayer.this.toggleControls();
            }
        });
        this.mClickFrame.setClickable(true);
    }

    @Override
    public void disableControls() {
        this.mControlsDisabled = true;
        this.mControlsFrame.setVisibility(8);
        this.mClickFrame.setOnClickListener(null);
        this.mClickFrame.setClickable(false);
    }

    @Override
    @CheckResult
    public boolean isPrepared() {
        return this.mPlayer != null && this.mIsPrepared;
    }

    @Override
    @CheckResult
    public boolean isPlaying() {
        return this.mPlayer != null && this.mPlayer.isPlaying();
    }

    @Override
    @CheckResult
    public int getCurrentPosition() {
        if (this.mPlayer == null) {
            return -1;
        }
        return this.mPlayer.getCurrentPosition();
    }

    @Override
    @CheckResult
    public int getDuration() {
        if (this.mPlayer == null) {
            return -1;
        }
        return this.mPlayer.getDuration();
    }

    @Override
    public void start() {
        if (this.mPlayer == null) {
            return;
        }
        this.mPlayer.start();
        if (this.mCallback != null) {
            this.mCallback.onStarted(this);
        }
        if (this.mHandler == null) {
            this.mHandler = new Handler();
        }
        this.mHandler.post(this.mUpdateCounters);
        this.mBtnPlayPause.setImageDrawable(this.mPauseDrawable);
    }

    @Override
    public void seekTo(@IntRange(from=0L, to=0x7FFFFFFFL) int pos) {
        if (this.mPlayer == null) {
            return;
        }
        this.mPlayer.seekTo(pos);
    }

    @Override
    public void setVolume(@FloatRange(from=0.0, to=1.0) float leftVolume, @FloatRange(from=0.0, to=1.0) float rightVolume) {
        if (this.mPlayer == null || !this.mIsPrepared) {
            throw new IllegalStateException("You cannot use setVolume(float, float) until the player is prepared.");
        }
        this.mPlayer.setVolume(leftVolume, rightVolume);
    }

    @Override
    public void pause() {
        if (this.mPlayer == null || !this.isPlaying()) {
            return;
        }
        this.mPlayer.pause();
        if (this.mCallback != null) {
            this.mCallback.onPaused(this);
        }
        if (this.mHandler == null) {
            return;
        }
        this.mHandler.removeCallbacks(this.mUpdateCounters);
        this.mBtnPlayPause.setImageDrawable(this.mPlayDrawable);
    }

    @Override
    public void stop() {
        if (this.mPlayer == null) {
            return;
        }
        try {
            this.mPlayer.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.mHandler == null) {
            return;
        }
        this.mHandler.removeCallbacks(this.mUpdateCounters);
        this.mBtnPlayPause.setImageDrawable(this.mPlayDrawable);
    }

    @Override
    public void reset() {
        if (this.mPlayer == null) {
            return;
        }
        this.mIsPrepared = false;
        this.mPlayer.reset();
        this.mIsPrepared = false;
    }

    @Override
    public void release() {
        this.mIsPrepared = false;
        if (this.mPlayer != null) {
            try {
                this.mPlayer.release();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.mPlayer = null;
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacks(this.mUpdateCounters);
            this.mHandler = null;
        }
        EasyVideoPlayer.LOG("Released player and Handler", new Object[0]);
    }

    @Override
    public void setAutoFullscreen(boolean autoFullscreen) {
        this.mAutoFullscreen = autoFullscreen;
    }

    @Override
    public void setLoop(boolean loop) {
        this.mLoop = loop;
        if (this.mPlayer != null) {
            this.mPlayer.setLooping(loop);
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
        EasyVideoPlayer.LOG("Surface texture available: %dx%d", width, height);
        this.mInitialTextureWidth = width;
        this.mInitialTextureHeight = height;
        this.mSurfaceAvailable = true;
        this.mSurface = new Surface(surfaceTexture);
        if (this.mIsPrepared) {
            this.mPlayer.setSurface(this.mSurface);
            if ("oppo".equals(Build.BRAND.toLowerCase()) && "OPPO R9sk".equals(Build.MODEL)) {
                this.mPlayer.seekTo(this.getCurrentPosition());
            }
        } else {
            this.prepare();
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
        EasyVideoPlayer.LOG("Surface texture changed: %dx%d", width, height);
        this.adjustAspectRatio(width, height, this.mPlayer.getVideoWidth(), this.mPlayer.getVideoHeight());
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        EasyVideoPlayer.LOG("Surface texture destroyed", new Object[0]);
        if ("oppo".equals(Build.BRAND.toLowerCase()) && "OPPO R9sk".equals(Build.MODEL)) {
            this.currentPos = this.getCurrentPosition();
        }
        this.mSurfaceAvailable = false;
        this.mSurface = null;
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        EasyVideoPlayer.LOG("onPrepared()", new Object[0]);
        this.mIsPrepared = true;
        if (this.mCallback != null) {
            this.mCallback.onPrepared(this);
        }
        this.mLabelPosition.setText((CharSequence)Util.getDurationString(0L, false));
        this.mLabelDuration.setText((CharSequence)Util.getDurationString(mediaPlayer.getDuration(), false));
        this.mSeeker.setProgress(0);
        this.mSeeker.setMax(mediaPlayer.getDuration());
        this.setControlsEnabled(true);
        if (this.mAutoPlay) {
            if (!this.mControlsDisabled && this.mHideControlsOnPlay) {
                this.hideControls();
            }
            this.start();
            if (this.mInitialPosition > 0) {
                this.seekTo(this.mInitialPosition);
                this.mInitialPosition = -1;
            }
        } else {
            this.mPlayer.start();
            this.mPlayer.pause();
            this.mBtnPlayPause.setImageDrawable(this.mPlayDrawable);
            this.mBtnPlayPause.setVisibility(0);
        }
    }

    public void onBufferingUpdate(MediaPlayer mediaPlayer, int percent) {
        EasyVideoPlayer.LOG("Buffering: %d%%", percent);
        if (this.mCallback != null) {
            this.mCallback.onBuffering(percent);
        }
        if (this.mSeeker != null) {
            if (percent == 100) {
                this.mSeeker.setSecondaryProgress(0);
            } else {
                this.mSeeker.setSecondaryProgress(this.mSeeker.getMax() * (percent / 100));
            }
        }
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        EasyVideoPlayer.LOG("onCompletion()", new Object[0]);
        if ("oppo".equals(Build.BRAND.toLowerCase()) && "OPPO R9sk".equals(Build.MODEL)) {
            this.currentPos = 0;
        }
        if (this.mLoop) {
            this.mBtnPlayPause.setImageDrawable(this.mPlayDrawable);
            if (this.mHandler != null) {
                this.mHandler.removeCallbacks(this.mUpdateCounters);
            }
            this.mSeeker.setProgress(this.mSeeker.getMax());
            this.showControls();
        } else {
            this.seekTo(0);
            this.mSeeker.setProgress(0);
            this.mLabelPosition.setText((CharSequence)Util.getDurationString(0L, false));
            this.mBtnPlayPause.setImageDrawable(this.mPlayDrawable);
            this.showControls();
        }
        if (this.mCallback != null) {
            this.mCallback.onCompletion(this);
            if (this.mLoop) {
                this.mCallback.onStarted(this);
            }
        }
    }

    public void onVideoSizeChanged(MediaPlayer mediaPlayer, int width, int height) {
        EasyVideoPlayer.LOG("Video size changed: %dx%d", width, height);
        this.adjustAspectRatio(this.mInitialTextureWidth, this.mInitialTextureHeight, width, height);
    }

    public boolean onError(MediaPlayer mediaPlayer, int what, int extra) {
        if (what == -38) {
            return false;
        }
        String errorMsg = "Preparation/playback error (" + what + "): ";
        switch (what) {
            default: {
                errorMsg = errorMsg + "Unknown error";
                break;
            }
            case -1004: {
                errorMsg = errorMsg + "I/O error";
                break;
            }
            case -1007: {
                errorMsg = errorMsg + "Malformed";
                break;
            }
            case 200: {
                errorMsg = errorMsg + "Not valid for progressive playback";
                break;
            }
            case 100: {
                errorMsg = errorMsg + "Server died";
                break;
            }
            case -110: {
                errorMsg = errorMsg + "Timed out";
                break;
            }
            case -1010: {
                errorMsg = errorMsg + "Unsupported";
            }
        }
        this.throwError(new Exception(errorMsg));
        return false;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.isInEditMode()) {
            return;
        }
        this.setKeepScreenOn(true);
        this.mHandler = new Handler();
        this.mPlayer = new MediaPlayer();
        this.mPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        this.mPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
        this.mPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        this.mPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
        this.mPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
        this.mPlayer.setAudioStreamType(3);
        this.mPlayer.setLooping(this.mLoop);
        this.initTextureView();
        this.initClickFrame();
        this.initPlayButton();
        this.initControlsFrame();
        if (this.mControlsDisabled) {
            this.mClickFrame.setOnClickListener(null);
            this.mControlsFrame.setVisibility(8);
        } else {
            this.mClickFrame.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    EasyVideoPlayer.this.toggleControls();
                    if (EasyVideoPlayer.this.mCallback != null) {
                        EasyVideoPlayer.this.mCallback.onClickVideoFrame(EasyVideoPlayer.this);
                    }
                }
            });
        }
        this.invalidateThemeColors();
        this.setControlsEnabled(false);
        this.prepare();
    }

    private void initTextureView() {
        FrameLayout.LayoutParams textureLp = new FrameLayout.LayoutParams(-1, -1);
        this.mTextureView = new TextureView(this.getContext());
        this.addView((View)this.mTextureView, (ViewGroup.LayoutParams)textureLp);
        this.mTextureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
    }

    private void initPlayButton() {
        this.mBtnPlayPause = new ImageButton(this.getContext());
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 17;
        this.mBtnPlayPause.setImageDrawable(this.mPauseDrawable);
        this.mBtnPlayPause.setOnClickListener((View.OnClickListener)this);
        this.addView((View)this.mBtnPlayPause, (ViewGroup.LayoutParams)params);
        this.mBtnPlayPause.setId(R.id.btnPlayPause);
        this.mBtnPlayPause.setVisibility(0);
    }

    private void initControlsFrame() {
        LayoutInflater li = LayoutInflater.from((Context)this.getContext());
        this.mControlsFrame = li.inflate(R.layout.easy_include_controls, (ViewGroup)this, false);
        FrameLayout.LayoutParams controlsLp = new FrameLayout.LayoutParams(-1, -2);
        controlsLp.gravity = 80;
        this.addView(this.mControlsFrame, (ViewGroup.LayoutParams)controlsLp);
        this.mSeeker = (SeekBar)this.mControlsFrame.findViewById(R.id.seeker);
        this.mSeeker.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.mLabelPosition = (TextView)this.mControlsFrame.findViewById(R.id.position);
        this.mLabelPosition.setText((CharSequence)Util.getDurationString(0L, false));
        this.mLabelDuration = (TextView)this.mControlsFrame.findViewById(R.id.duration);
        this.mLabelDuration.setText((CharSequence)Util.getDurationString(0L, false));
    }

    private void initClickFrame() {
        this.mClickFrame = new FrameLayout(this.getContext());
        this.addView(this.mClickFrame, new ViewGroup.LayoutParams(-1, -1));
    }

    public void onClick(View view) {
        if (view.getId() == R.id.btnPlayPause) {
            if (this.mPlayer.isPlaying()) {
                this.pause();
            } else {
                if (this.mHideControlsOnPlay && !this.mControlsDisabled) {
                    this.hideControls();
                }
                this.start();
            }
        }
    }

    public void onProgressChanged(SeekBar seekBar, int value, boolean fromUser) {
        if (fromUser) {
            this.seekTo(value);
        }
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
        this.mWasPlaying = this.isPlaying();
        if (this.mWasPlaying) {
            this.mPlayer.pause();
        }
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        if (this.mWasPlaying) {
            this.mPlayer.start();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        EasyVideoPlayer.LOG("Detached from window", new Object[0]);
        this.release();
        this.mSeeker = null;
        this.mLabelPosition = null;
        this.mLabelDuration = null;
        this.mBtnPlayPause = null;
        this.mControlsFrame = null;
        this.mClickFrame = null;
        if (this.mHandler != null) {
            this.mHandler.removeCallbacks(this.mUpdateCounters);
            this.mHandler = null;
        }
    }

    private static void LOG(String message, Object ... args) {
        try {
            if (args != null) {
                message = String.format(message, args);
            }
            Log.d((String)"EasyVideoPlayer", (String)message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void adjustAspectRatio(int viewWidth, int viewHeight, int videoWidth, int videoHeight) {
        int newHeight;
        int newWidth;
        double aspectRatio = (double)videoHeight / (double)videoWidth;
        if (viewHeight > (int)((double)viewWidth * aspectRatio)) {
            newWidth = viewWidth;
            newHeight = (int)((double)viewWidth * aspectRatio);
        } else {
            newWidth = (int)((double)viewHeight / aspectRatio);
            newHeight = viewHeight;
        }
        int xoff = (viewWidth - newWidth) / 2;
        int yoff = (viewHeight - newHeight) / 2;
        Matrix txform = new Matrix();
        this.mTextureView.getTransform(txform);
        txform.setScale((float)newWidth / (float)viewWidth, (float)newHeight / (float)viewHeight);
        txform.postTranslate((float)xoff, (float)yoff);
        this.mTextureView.setTransform(txform);
    }

    private void throwError(Exception e) {
        if (this.mCallback == null) {
            throw new RuntimeException(e);
        }
        this.mCallback.onError(this, e);
    }

    private static void setTint(@NonNull SeekBar seekBar, @ColorInt int color2) {
        ColorStateList s1 = ColorStateList.valueOf((int)color2);
        if (Build.VERSION.SDK_INT >= 21) {
            seekBar.setThumbTintList(s1);
            seekBar.setProgressTintList(s1);
            seekBar.setSecondaryProgressTintList(s1);
        } else if (Build.VERSION.SDK_INT > 10) {
            Drawable progressDrawable = DrawableCompat.wrap((Drawable)seekBar.getProgressDrawable());
            seekBar.setProgressDrawable(progressDrawable);
            DrawableCompat.setTintList((Drawable)progressDrawable, (ColorStateList)s1);
            if (Build.VERSION.SDK_INT >= 16) {
                Drawable thumbDrawable = DrawableCompat.wrap((Drawable)seekBar.getThumb());
                DrawableCompat.setTintList((Drawable)thumbDrawable, (ColorStateList)s1);
                seekBar.setThumb(thumbDrawable);
            }
        } else {
            PorterDuff.Mode mode = PorterDuff.Mode.SRC_IN;
            if (Build.VERSION.SDK_INT <= 10) {
                mode = PorterDuff.Mode.MULTIPLY;
            }
            if (seekBar.getIndeterminateDrawable() != null) {
                seekBar.getIndeterminateDrawable().setColorFilter(color2, mode);
            }
            if (seekBar.getProgressDrawable() != null) {
                seekBar.getProgressDrawable().setColorFilter(color2, mode);
            }
        }
    }

    private Drawable tintDrawable(@NonNull Drawable d, @ColorInt int color2) {
        d = DrawableCompat.wrap((Drawable)d.mutate());
        DrawableCompat.setTint((Drawable)d, (int)color2);
        return d;
    }

    private void tintSelector(@NonNull View view, @ColorInt int color2) {
        if (Build.VERSION.SDK_INT >= 21 && view.getBackground() instanceof RippleDrawable) {
            RippleDrawable rd = (RippleDrawable)view.getBackground();
            rd.setColor(ColorStateList.valueOf((int)Util.adjustAlpha(color2, 0.3f)));
        }
    }

    private void invalidateThemeColors() {
        int labelColor = Util.isColorDark(this.mThemeColor) ? -1 : -16777216;
        this.mControlsFrame.setBackgroundColor(Util.adjustAlpha(this.mThemeColor, 0.8f));
        this.tintSelector((View)this.mBtnPlayPause, labelColor);
        this.mLabelDuration.setTextColor(labelColor);
        this.mLabelPosition.setTextColor(labelColor);
        EasyVideoPlayer.setTint(this.mSeeker, labelColor);
        this.mPlayDrawable = this.tintDrawable(this.mPlayDrawable.mutate(), labelColor);
        this.mPauseDrawable = this.tintDrawable(this.mPauseDrawable.mutate(), labelColor);
    }

    @TargetApi(value=14)
    private void setFullscreen(boolean fullscreen) {
        if (Build.VERSION.SDK_INT >= 14 && this.mAutoFullscreen) {
            int flags = !fullscreen ? 0 : 1;
            ViewCompat.setFitsSystemWindows((View)this.mControlsFrame, (!fullscreen ? 1 : 0) != 0);
            if (Build.VERSION.SDK_INT >= 19) {
                flags |= 0x700;
                if (fullscreen) {
                    flags |= 0x806;
                }
            }
            this.mClickFrame.setSystemUiVisibility(flags);
        }
    }
}

