/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules.chat;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.manager.EaseDingMessageHelper;
import com.hyphenate.easeui.modules.chat.EaseChatLayout;
import com.hyphenate.easeui.modules.chat.EaseChatMessageListLayout;
import com.hyphenate.easeui.modules.chat.interfaces.OnAddMsgAttrsBeforeSendEvent;
import com.hyphenate.easeui.modules.chat.interfaces.OnChatLayoutListener;
import com.hyphenate.easeui.modules.chat.interfaces.OnMenuChangeListener;
import com.hyphenate.easeui.modules.menu.EasePopupWindowHelper;
import com.hyphenate.easeui.modules.menu.MenuItemBean;
import com.hyphenate.easeui.ui.EaseBaiduMapActivity;
import com.hyphenate.easeui.ui.base.EaseBaseFragment;
import com.hyphenate.easeui.utils.EaseCommonUtils;
import com.hyphenate.easeui.utils.EaseCompat;
import com.hyphenate.easeui.utils.EaseFileUtils;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.PathUtil;
import com.hyphenate.util.VersionUtils;
import java.io.File;

public class EaseChatFragment
extends EaseBaseFragment
implements OnChatLayoutListener,
OnMenuChangeListener,
OnAddMsgAttrsBeforeSendEvent {
    protected static final int REQUEST_CODE_MAP = 1;
    protected static final int REQUEST_CODE_CAMERA = 2;
    protected static final int REQUEST_CODE_LOCAL = 3;
    protected static final int REQUEST_CODE_DING_MSG = 4;
    protected static final int REQUEST_CODE_SELECT_VIDEO = 11;
    protected static final int REQUEST_CODE_SELECT_FILE = 12;
    private static final String TAG = EaseChatFragment.class.getSimpleName();
    public EaseChatLayout chatLayout;
    public String conversationId;
    public int chatType;
    public String historyMsgId;
    public boolean isRoam;
    public boolean isMessageInit;
    private OnChatLayoutListener listener;
    protected File cameraFile;

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.initArguments();
        return inflater.inflate(this.getLayoutId(), null);
    }

    private int getLayoutId() {
        return R.layout.ease_fragment_chat_list;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initView();
        this.initListener();
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.initData();
    }

    public void initArguments() {
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.conversationId = bundle.getString("conversationId");
            this.chatType = bundle.getInt("chatType", 1);
            this.historyMsgId = bundle.getString("history_msg_id");
            this.isRoam = bundle.getBoolean("isRoaming", false);
        }
    }

    public void initView() {
        this.chatLayout = (EaseChatLayout)this.findViewById(R.id.layout_chat);
        this.chatLayout.getChatMessageListLayout().setItemShowType(EaseChatMessageListLayout.ShowType.NORMAL);
        this.chatLayout.getChatMessageListLayout().setBackgroundColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.gray));
    }

    public void initListener() {
        this.chatLayout.setOnChatLayoutListener(this);
        this.chatLayout.setOnPopupWindowItemClickListener(this);
        this.chatLayout.setOnAddMsgAttrsBeforeSendEvent(this);
    }

    public void initData() {
        if (!TextUtils.isEmpty((CharSequence)this.historyMsgId)) {
            this.chatLayout.init(EaseChatMessageListLayout.LoadDataType.HISTORY, this.conversationId, this.chatType);
            this.chatLayout.loadData(this.historyMsgId);
        } else {
            if (this.isRoam) {
                this.chatLayout.init(EaseChatMessageListLayout.LoadDataType.ROAM, this.conversationId, this.chatType);
            } else {
                this.chatLayout.init(this.conversationId, this.chatType);
            }
            this.chatLayout.loadDefaultData();
        }
        this.isMessageInit = true;
    }

    public void onResume() {
        super.onResume();
        if (this.isMessageInit) {
            this.chatLayout.getChatMessageListLayout().refreshMessages();
        }
    }

    public void setOnChatLayoutListener(OnChatLayoutListener listener) {
        this.listener = listener;
    }

    @Override
    public boolean onBubbleClick(EMMessage message) {
        if (this.listener != null) {
            return this.listener.onBubbleClick(message);
        }
        return false;
    }

    @Override
    public boolean onBubbleLongClick(View v, EMMessage message) {
        if (this.listener != null) {
            return this.listener.onBubbleLongClick(v, message);
        }
        return false;
    }

    @Override
    public void onUserAvatarClick(String username) {
        if (this.listener != null) {
            this.listener.onUserAvatarClick(username);
        }
    }

    @Override
    public void onUserAvatarLongClick(String username) {
        if (this.listener != null) {
            this.listener.onUserAvatarLongClick(username);
        }
    }

    @Override
    public void onChatExtendMenuItemClick(View view, int itemId) {
        if (itemId == R.id.extend_item_take_picture) {
            this.selectPicFromCamera();
        } else if (itemId == R.id.extend_item_picture) {
            this.selectPicFromLocal();
        } else if (itemId == R.id.extend_item_location) {
            this.startMapLocation(1);
        } else if (itemId == R.id.extend_item_video) {
            this.selectVideoFromLocal();
        } else if (itemId == R.id.extend_item_file) {
            this.selectFileFromLocal();
        }
    }

    @Override
    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    @Override
    public void onChatSuccess(EMMessage message) {
    }

    @Override
    public void onChatError(int code, String errorMsg) {
        if (this.listener != null) {
            this.listener.onChatError(code, errorMsg);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            this.chatLayout.getChatInputMenu().hideExtendContainer();
            if (requestCode == 2) {
                this.onActivityResultForCamera(data);
            } else if (requestCode == 3) {
                this.onActivityResultForLocalPhotos(data);
            } else if (requestCode == 1) {
                this.onActivityResultForMapLocation(data);
            } else if (requestCode == 4) {
                this.onActivityResultForDingMsg(data);
            } else if (requestCode == 12) {
                this.onActivityResultForLocalFiles(data);
            }
        }
    }

    protected void selectPicFromCamera() {
        if (!this.checkSdCardExist()) {
            return;
        }
        this.cameraFile = new File(PathUtil.getInstance().getImagePath(), EMClient.getInstance().getCurrentUser() + System.currentTimeMillis() + ".jpg");
        this.cameraFile.getParentFile().mkdirs();
        this.startActivityForResult(new Intent("android.media.action.IMAGE_CAPTURE").putExtra("output", (Parcelable)EaseCompat.getUriForFile(this.getContext(), this.cameraFile)), 2);
    }

    protected void selectPicFromLocal() {
        EaseCompat.openImage(this, 3);
    }

    protected void startMapLocation(int requestCode) {
        EaseBaiduMapActivity.actionStartForResult(this, requestCode);
    }

    protected void selectVideoFromLocal() {
    }

    protected void selectFileFromLocal() {
        Intent intent = new Intent();
        if (VersionUtils.isTargetQ((Context)this.getActivity())) {
            intent.setAction("android.intent.action.OPEN_DOCUMENT");
        } else if (Build.VERSION.SDK_INT < 24) {
            intent.setAction("android.intent.action.GET_CONTENT");
        } else {
            intent.setAction("android.intent.action.OPEN_DOCUMENT");
        }
        intent.addFlags(3);
        intent.addCategory("android.intent.category.OPENABLE");
        intent.setType("*/*");
        this.startActivityForResult(intent, 12);
    }

    protected void onActivityResultForCamera(Intent data) {
        if (this.cameraFile != null && this.cameraFile.exists()) {
            this.chatLayout.sendImageMessage(Uri.parse((String)this.cameraFile.getAbsolutePath()));
        }
    }

    protected void onActivityResultForLocalPhotos(@Nullable Intent data) {
        Uri selectedImage;
        if (data != null && (selectedImage = data.getData()) != null) {
            String filePath = EaseFileUtils.getFilePath((Context)this.mContext, selectedImage);
            if (!TextUtils.isEmpty((CharSequence)filePath) && new File(filePath).exists()) {
                this.chatLayout.sendImageMessage(Uri.parse((String)filePath));
            } else {
                EaseFileUtils.saveUriPermission((Context)this.mContext, selectedImage, data);
                this.chatLayout.sendImageMessage(selectedImage);
            }
        }
    }

    protected void onActivityResultForMapLocation(@Nullable Intent data) {
        if (data != null) {
            double latitude = data.getDoubleExtra("latitude", 0.0);
            double longitude = data.getDoubleExtra("longitude", 0.0);
            String locationAddress = data.getStringExtra("address");
            if (locationAddress != null && !locationAddress.equals("")) {
                this.chatLayout.sendLocationMessage(latitude, longitude, locationAddress);
            } else if (this.listener != null) {
                this.listener.onChatError(-1, this.getResources().getString(R.string.unable_to_get_loaction));
            }
        }
    }

    protected void onActivityResultForDingMsg(@Nullable Intent data) {
        if (data != null) {
            String msgContent = data.getStringExtra("msg");
            EMLog.i((String)TAG, (String)("To send the ding-type msg, content: " + msgContent));
            EMMessage dingMsg = EaseDingMessageHelper.get().createDingMessage(this.conversationId, msgContent);
            this.chatLayout.sendMessage(dingMsg);
        }
    }

    protected void onActivityResultForLocalFiles(@Nullable Intent data) {
        Uri uri;
        if (data != null && (uri = data.getData()) != null) {
            String filePath = EaseFileUtils.getFilePath((Context)this.mContext, uri);
            if (!TextUtils.isEmpty((CharSequence)filePath) && new File(filePath).exists()) {
                this.chatLayout.sendFileMessage(Uri.parse((String)filePath));
            } else {
                EaseFileUtils.saveUriPermission((Context)this.mContext, uri, data);
                this.chatLayout.sendFileMessage(uri);
            }
        }
    }

    protected boolean checkSdCardExist() {
        return EaseCommonUtils.isSdcardExist();
    }

    @Override
    public void onPreMenu(EasePopupWindowHelper helper, EMMessage message) {
    }

    @Override
    public boolean onMenuItemClick(MenuItemBean item, EMMessage message) {
        return false;
    }

    @Override
    public void addMsgAttrsBeforeSend(EMMessage message) {
    }
}

