/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.widget.emojicon;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.widget.EImageView;
import com.hyphenate.util.DensityUtil;
import java.util.ArrayList;
import java.util.List;

@SuppressLint(value={"NewApi"})
public class EaseEmojiconIndicatorView
extends LinearLayout {
    private Context context;
    private Bitmap selectedBitmap;
    private Bitmap unselectedBitmap;
    private List<ImageView> dotViews;
    private int dotHeight = 12;

    public EaseEmojiconIndicatorView(Context context, AttributeSet attrs, int defStyle) {
        this(context, null);
    }

    public EaseEmojiconIndicatorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public EaseEmojiconIndicatorView(Context context) {
        this(context, null);
    }

    private void init(Context context, AttributeSet attrs) {
        this.context = context;
        this.dotHeight = DensityUtil.dip2px((Context)context, (float)this.dotHeight);
        this.selectedBitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)R.drawable.ease_dot_emojicon_selected);
        this.unselectedBitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)R.drawable.ease_dot_emojicon_unselected);
        this.setGravity(1);
    }

    public void init(int count) {
        this.dotViews = new ArrayList<ImageView>();
        for (int i = 0; i < count; ++i) {
            RelativeLayout rl = new RelativeLayout(this.context);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.dotHeight, this.dotHeight);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.addRule(13);
            EImageView imageView = new EImageView(this.context);
            if (i == 0) {
                imageView.setImageBitmap(this.selectedBitmap);
                rl.addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
            } else {
                imageView.setImageBitmap(this.unselectedBitmap);
                rl.addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
            }
            this.addView((View)rl, (ViewGroup.LayoutParams)params);
            this.dotViews.add(imageView);
        }
    }

    public void updateIndicator(int count) {
        if (this.dotViews == null) {
            return;
        }
        for (int i = 0; i < this.dotViews.size(); ++i) {
            if (i >= count) {
                this.dotViews.get(i).setVisibility(8);
                ((View)this.dotViews.get(i).getParent()).setVisibility(8);
                continue;
            }
            this.dotViews.get(i).setVisibility(0);
            ((View)this.dotViews.get(i).getParent()).setVisibility(0);
        }
        if (count > this.dotViews.size()) {
            int diff = count - this.dotViews.size();
            for (int i = 0; i < diff; ++i) {
                RelativeLayout rl = new RelativeLayout(this.context);
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.dotHeight, this.dotHeight);
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
                layoutParams.addRule(13);
                EImageView imageView = new EImageView(this.context);
                imageView.setImageBitmap(this.unselectedBitmap);
                rl.addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
                rl.setVisibility(8);
                imageView.setVisibility(8);
                this.addView((View)rl, (ViewGroup.LayoutParams)params);
                this.dotViews.add(imageView);
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.selectedBitmap != null) {
            this.selectedBitmap.recycle();
        }
        if (this.unselectedBitmap != null) {
            this.unselectedBitmap.recycle();
        }
    }

    public void selectTo(int position) {
        for (ImageView iv : this.dotViews) {
            iv.setImageBitmap(this.unselectedBitmap);
        }
        this.dotViews.get(position).setImageBitmap(this.selectedBitmap);
    }

    public void selectTo(int startPosition, int targetPostion) {
        ImageView startView = this.dotViews.get(startPosition);
        ImageView targetView = this.dotViews.get(targetPostion);
        startView.setImageBitmap(this.unselectedBitmap);
        targetView.setImageBitmap(this.selectedBitmap);
    }
}

