/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules.chat;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.lifecycle.LifecycleObserver;
import com.hyphenate.EMChatRoomChangeListener;
import com.hyphenate.EMGroupChangeListener;
import com.hyphenate.EMMessageListener;
import com.hyphenate.chat.EMChatManager;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMCmdMessageBody;
import com.hyphenate.chat.EMConversation;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMTextMessageBody;
import com.hyphenate.easeui.EaseIM;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.domain.EaseEmojicon;
import com.hyphenate.easeui.domain.EaseUser;
import com.hyphenate.easeui.interfaces.EaseChatRoomListener;
import com.hyphenate.easeui.interfaces.EaseGroupListener;
import com.hyphenate.easeui.interfaces.MessageListItemClickListener;
import com.hyphenate.easeui.manager.EaseAtMessageHelper;
import com.hyphenate.easeui.manager.EaseThreadManager;
import com.hyphenate.easeui.modules.chat.EaseChatInputMenu;
import com.hyphenate.easeui.modules.chat.EaseChatMessageListLayout;
import com.hyphenate.easeui.modules.chat.interfaces.ChatInputMenuListener;
import com.hyphenate.easeui.modules.chat.interfaces.IChatLayout;
import com.hyphenate.easeui.modules.chat.interfaces.OnAddMsgAttrsBeforeSendEvent;
import com.hyphenate.easeui.modules.chat.interfaces.OnChatLayoutListener;
import com.hyphenate.easeui.modules.chat.interfaces.OnChatRecordTouchListener;
import com.hyphenate.easeui.modules.chat.interfaces.OnMenuChangeListener;
import com.hyphenate.easeui.modules.chat.interfaces.OnRecallMessageResultListener;
import com.hyphenate.easeui.modules.chat.presenter.EaseHandleMessagePresenter;
import com.hyphenate.easeui.modules.chat.presenter.EaseHandleMessagePresenterImpl;
import com.hyphenate.easeui.modules.chat.presenter.IHandleMessageView;
import com.hyphenate.easeui.modules.interfaces.IPopupWindow;
import com.hyphenate.easeui.modules.menu.EasePopupWindow;
import com.hyphenate.easeui.modules.menu.EasePopupWindowHelper;
import com.hyphenate.easeui.modules.menu.MenuItemBean;
import com.hyphenate.easeui.utils.EaseCommonUtils;
import com.hyphenate.easeui.utils.EaseUserUtils;
import com.hyphenate.easeui.widget.EaseAlertDialog;
import com.hyphenate.easeui.widget.EaseVoiceRecorderView;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.EMLog;
import java.util.List;

public class EaseChatLayout
extends RelativeLayout
implements IChatLayout,
IHandleMessageView,
IPopupWindow,
ChatInputMenuListener,
EMMessageListener,
EaseChatMessageListLayout.OnMessageTouchListener,
MessageListItemClickListener,
EaseChatMessageListLayout.OnChatErrorListener {
    private static final String TAG = EaseChatLayout.class.getSimpleName();
    private static final int MSG_TYPING_HEARTBEAT = 0;
    private static final int MSG_TYPING_END = 1;
    private static final int MSG_OTHER_TYPING_END = 2;
    public static final String ACTION_TYPING_BEGIN = "TypingBegin";
    public static final String ACTION_TYPING_END = "TypingEnd";
    protected static final int TYPING_SHOW_TIME = 10000;
    protected static final int OTHER_TYPING_SHOW_TIME = 5000;
    public static final String AT_PREFIX = "@";
    public static final String AT_SUFFIX = " ";
    private EaseChatMessageListLayout messageListLayout;
    private EaseChatInputMenu inputMenu;
    private EaseVoiceRecorderView voiceRecorder;
    private boolean turnOnTyping;
    private Handler typingHandler;
    private String conversationId;
    private int chatType;
    private OnChatLayoutListener listener;
    private OnChatRecordTouchListener recordTouchListener;
    private EaseHandleMessagePresenter presenter = new EaseHandleMessagePresenterImpl();
    private boolean showDefaultMenu = true;
    private EasePopupWindowHelper menuHelper;
    private ClipboardManager clipboard;
    private OnMenuChangeListener menuChangeListener;
    private OnRecallMessageResultListener recallMessageListener;
    private ChatRoomListener chatRoomListener;
    private GroupListener groupListener;
    private OnAddMsgAttrsBeforeSendEvent sendMsgEvent;
    private boolean isNotFirstSend;

    public EaseChatLayout(Context context) {
        this(context, null);
    }

    public EaseChatLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EaseChatLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (context instanceof AppCompatActivity) {
            ((AppCompatActivity)context).getLifecycle().addObserver((LifecycleObserver)this.presenter);
        }
        LayoutInflater.from((Context)context).inflate(R.layout.ease_layout_chat, (ViewGroup)this);
        this.initView();
        this.initListener();
    }

    private void initView() {
        this.messageListLayout = (EaseChatMessageListLayout)this.findViewById(R.id.layout_chat_message);
        this.inputMenu = (EaseChatInputMenu)this.findViewById(R.id.layout_menu);
        this.voiceRecorder = (EaseVoiceRecorderView)this.findViewById(R.id.voice_recorder);
        this.presenter.attachView(this);
        this.menuHelper = new EasePopupWindowHelper();
        this.clipboard = (ClipboardManager)this.getContext().getSystemService("clipboard");
    }

    private void initListener() {
        this.messageListLayout.setOnMessageTouchListener(this);
        this.messageListLayout.setMessageListItemClickListener(this);
        this.messageListLayout.setOnChatErrorListener(this);
        this.inputMenu.setChatInputMenuListener(this);
        this.getChatManager().addMessageListener((EMMessageListener)this);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.getChatManager().removeMessageListener((EMMessageListener)this);
        if (this.chatRoomListener != null) {
            EMClient.getInstance().chatroomManager().removeChatRoomListener((EMChatRoomChangeListener)this.chatRoomListener);
        }
        if (this.groupListener != null) {
            EMClient.getInstance().groupManager().removeGroupChangeListener((EMGroupChangeListener)this.groupListener);
        }
        if (this.isChatRoomCon()) {
            EMClient.getInstance().chatroomManager().leaveChatRoom(this.conversationId);
        }
        if (this.isGroupCon()) {
            EaseAtMessageHelper.get().removeAtMeGroup(this.conversationId);
            EaseAtMessageHelper.get().cleanToAtUserList();
        }
        if (this.typingHandler != null) {
            this.typingHandler.removeCallbacksAndMessages(null);
        }
    }

    public void init(String username, int chatType) {
        this.init(EaseChatMessageListLayout.LoadDataType.LOCAL, username, chatType);
    }

    public void init(EaseChatMessageListLayout.LoadDataType loadDataType, String conversationId, int chatType) {
        this.conversationId = conversationId;
        this.chatType = chatType;
        this.messageListLayout.init(loadDataType, this.conversationId, chatType);
        this.presenter.setupWithToUser(chatType, this.conversationId);
        if (this.isChatRoomCon()) {
            this.chatRoomListener = new ChatRoomListener();
            EMClient.getInstance().chatroomManager().addChatRoomChangeListener((EMChatRoomChangeListener)this.chatRoomListener);
        } else if (this.isGroupCon()) {
            EaseAtMessageHelper.get().removeAtMeGroup(conversationId);
            this.groupListener = new GroupListener();
            EMClient.getInstance().groupManager().addGroupChangeListener((EMGroupChangeListener)this.groupListener);
        }
        this.initTypingHandler();
    }

    public void initHistoryModel(String toChatUsername, int chatType) {
        this.init(EaseChatMessageListLayout.LoadDataType.HISTORY, toChatUsername, chatType);
    }

    public void loadDefaultData() {
        this.sendChannelAck();
        this.messageListLayout.loadDefaultData();
    }

    public void loadData(String msgId, int pageSize) {
        this.sendChannelAck();
        this.messageListLayout.loadData(pageSize, msgId);
    }

    public void loadData(String msgId) {
        this.sendChannelAck();
        this.messageListLayout.loadData(msgId);
    }

    private void initTypingHandler() {
        this.typingHandler = new Handler(){

            public void handleMessage(@NonNull Message msg) {
                switch (msg.what) {
                    case 0: {
                        EaseChatLayout.this.setTypingBeginMsg(this);
                        break;
                    }
                    case 1: {
                        EaseChatLayout.this.setTypingEndMsg(this);
                        break;
                    }
                    case 2: {
                        EaseChatLayout.this.setOtherTypingEnd(this);
                    }
                }
            }
        };
        if (!this.turnOnTyping && this.typingHandler != null) {
            this.typingHandler.removeCallbacksAndMessages(null);
        }
    }

    private void sendChannelAck() {
        if (EaseIM.getInstance().getConfigsManager().enableSendChannelAck()) {
            EMConversation conversation = EMClient.getInstance().chatManager().getConversation(this.conversationId);
            if (conversation == null || conversation.getUnreadMsgCount() <= 0) {
                return;
            }
            try {
                EMClient.getInstance().chatManager().ackConversationRead(this.conversationId);
            }
            catch (HyphenateException e) {
                e.printStackTrace();
            }
        }
    }

    private void setOtherTypingEnd(Handler handler) {
        if (this.chatType != 1) {
            return;
        }
        handler.removeMessages(2);
        if (this.listener != null) {
            this.listener.onOtherTyping(ACTION_TYPING_END);
        }
    }

    private void setTypingBeginMsg(Handler handler) {
        if (!this.turnOnTyping) {
            return;
        }
        if (this.chatType != 1) {
            return;
        }
        this.presenter.sendCmdMessage(ACTION_TYPING_BEGIN);
        handler.sendEmptyMessageDelayed(0, 10000L);
    }

    private void setTypingEndMsg(Handler handler) {
        if (!this.turnOnTyping) {
            return;
        }
        if (this.chatType != 1) {
            return;
        }
        this.isNotFirstSend = false;
        handler.removeMessages(0);
        handler.removeMessages(1);
    }

    public boolean isChatRoomCon() {
        return EaseCommonUtils.getConversationType(this.chatType) == EMConversation.EMConversationType.ChatRoom;
    }

    public boolean isGroupCon() {
        return EaseCommonUtils.getConversationType(this.chatType) == EMConversation.EMConversationType.GroupChat;
    }

    @Override
    public EaseChatMessageListLayout getChatMessageListLayout() {
        return this.messageListLayout;
    }

    @Override
    public EaseChatInputMenu getChatInputMenu() {
        return this.inputMenu;
    }

    @Override
    public String getInputContent() {
        return this.inputMenu.getPrimaryMenu().getEditText().getText().toString().trim();
    }

    @Override
    public void turnOnTypingMonitor(boolean turnOn) {
        this.turnOnTyping = turnOn;
        if (!turnOn) {
            this.isNotFirstSend = false;
        }
    }

    @Override
    public void sendTextMessage(String content) {
        this.presenter.sendTextMessage(content);
    }

    @Override
    public void sendTextMessage(String content, boolean isNeedGroupAck) {
        this.presenter.sendTextMessage(content, isNeedGroupAck);
    }

    @Override
    public void sendAtMessage(String content) {
        this.presenter.sendAtMessage(content);
    }

    @Override
    public void sendBigExpressionMessage(String name, String identityCode) {
        this.presenter.sendBigExpressionMessage(name, identityCode);
    }

    @Override
    public void sendVoiceMessage(String filePath, int length) {
        this.sendVoiceMessage(Uri.parse((String)filePath), length);
    }

    @Override
    public void sendVoiceMessage(Uri filePath, int length) {
        this.presenter.sendVoiceMessage(filePath, length);
    }

    @Override
    public void sendImageMessage(Uri imageUri) {
        this.presenter.sendImageMessage(imageUri);
    }

    @Override
    public void sendImageMessage(Uri imageUri, boolean sendOriginalImage) {
        this.presenter.sendImageMessage(imageUri, sendOriginalImage);
    }

    @Override
    public void sendLocationMessage(double latitude, double longitude, String locationAddress) {
        this.presenter.sendLocationMessage(latitude, longitude, locationAddress);
    }

    @Override
    public void sendVideoMessage(Uri videoUri, int videoLength) {
        this.presenter.sendVideoMessage(videoUri, videoLength);
    }

    @Override
    public void sendFileMessage(Uri fileUri) {
        this.presenter.sendFileMessage(fileUri);
    }

    @Override
    public void sendMessage(EMMessage message) {
        this.presenter.sendMessage(message);
    }

    @Override
    public void resendMessage(EMMessage message) {
        EMLog.i((String)TAG, (String)"resendMessage");
        this.presenter.resendMessage(message);
    }

    @Override
    public void deleteMessage(EMMessage message) {
        this.messageListLayout.getCurrentConversation().removeMessage(message.getMsgId());
        this.messageListLayout.removeMessage(message);
    }

    @Override
    public void recallMessage(EMMessage message) {
        this.presenter.recallMessage(message);
    }

    @Override
    public void addMessageAttributes(EMMessage message) {
        this.presenter.addMessageAttributes(message);
    }

    @Override
    public void setOnChatLayoutListener(OnChatLayoutListener listener) {
        this.listener = listener;
    }

    @Override
    public void setOnChatRecordTouchListener(OnChatRecordTouchListener recordTouchListener) {
        this.recordTouchListener = recordTouchListener;
    }

    @Override
    public void setOnRecallMessageResultListener(OnRecallMessageResultListener listener) {
        this.recallMessageListener = listener;
    }

    @Override
    public void setOnAddMsgAttrsBeforeSendEvent(OnAddMsgAttrsBeforeSendEvent sendMsgEvent) {
        this.sendMsgEvent = sendMsgEvent;
    }

    @Override
    public void onTyping(CharSequence s, int start, int before, int count) {
        if (this.listener != null) {
            this.listener.onTextChanged(s, start, before, count);
        }
        if (this.turnOnTyping && this.typingHandler != null) {
            if (!this.isNotFirstSend) {
                this.isNotFirstSend = true;
                this.typingHandler.sendEmptyMessage(0);
            }
            this.typingHandler.removeMessages(1);
            this.typingHandler.sendEmptyMessageDelayed(1, 10000L);
        }
    }

    @Override
    public void onSendMessage(String content) {
        this.presenter.sendTextMessage(content);
    }

    @Override
    public void onExpressionClicked(Object emojicon) {
        if (emojicon instanceof EaseEmojicon) {
            this.presenter.sendBigExpressionMessage(((EaseEmojicon)emojicon).getName(), ((EaseEmojicon)emojicon).getIdentityCode());
        }
    }

    @Override
    public boolean onPressToSpeakBtnTouch(View v, MotionEvent event) {
        if (this.recordTouchListener != null && this.recordTouchListener.onRecordTouch(v, event)) {
            return this.recordTouchListener.onRecordTouch(v, event);
        }
        return this.voiceRecorder.onPressToSpeakBtnTouch(v, event, this::sendVoiceMessage);
    }

    @Override
    public void onChatExtendMenuItemClick(int itemId, View view) {
        if (this.listener != null) {
            this.listener.onChatExtendMenuItemClick(view, itemId);
        }
    }

    private EMChatManager getChatManager() {
        return EMClient.getInstance().chatManager();
    }

    public void onMessageReceived(List<EMMessage> messages) {
        boolean refresh = false;
        for (EMMessage message : messages) {
            String username = null;
            this.sendGroupReadAck(message);
            this.sendReadAck(message);
            username = message.getChatType() == EMMessage.ChatType.GroupChat || message.getChatType() == EMMessage.ChatType.ChatRoom ? message.getTo() : message.getFrom();
            if (!username.equals(this.conversationId) && !message.getTo().equals(this.conversationId) && !message.conversationId().equals(this.conversationId)) continue;
            refresh = true;
        }
        if (refresh) {
            this.getChatMessageListLayout().refreshToLatest();
        }
    }

    public void sendReadAck(EMMessage message) {
        if (EaseIM.getInstance().getConfigsManager().enableSendChannelAck() && message.direct() == EMMessage.Direct.RECEIVE && !message.isAcked() && message.getChatType() == EMMessage.ChatType.Chat) {
            EMMessage.Type type = message.getType();
            if (type == EMMessage.Type.VIDEO || type == EMMessage.Type.VOICE || type == EMMessage.Type.FILE) {
                return;
            }
            try {
                EMClient.getInstance().chatManager().ackMessageRead(message.getFrom(), message.getMsgId());
            }
            catch (HyphenateException e) {
                e.printStackTrace();
            }
        }
    }

    private void sendGroupReadAck(EMMessage message) {
        if (message.isNeedGroupAck() && message.isUnread()) {
            try {
                EMClient.getInstance().chatManager().ackGroupMessageRead(message.getTo(), message.getMsgId(), "");
            }
            catch (HyphenateException e) {
                e.printStackTrace();
            }
        }
    }

    public void onCmdMessageReceived(List<EMMessage> messages) {
        for (EMMessage msg : messages) {
            EMCmdMessageBody body = (EMCmdMessageBody)msg.getBody();
            EMLog.i((String)TAG, (String)("Receive cmd message: " + body.action() + " - " + body.isDeliverOnlineOnly()));
            EaseThreadManager.getInstance().runOnMainThread(() -> {
                if (TextUtils.equals((CharSequence)msg.getFrom(), (CharSequence)this.conversationId)) {
                    if (this.listener != null) {
                        this.listener.onOtherTyping(body.action());
                    }
                    if (this.typingHandler != null) {
                        this.typingHandler.removeMessages(2);
                        this.typingHandler.sendEmptyMessageDelayed(2, 5000L);
                    }
                }
            });
        }
    }

    public void onMessageRead(List<EMMessage> messages) {
        this.refreshMessages(messages);
    }

    public void onMessageDelivered(List<EMMessage> messages) {
        this.refreshMessages(messages);
    }

    public void onMessageRecalled(List<EMMessage> messages) {
        if (this.getChatMessageListLayout() != null) {
            this.getChatMessageListLayout().refreshMessages();
        }
    }

    public void onMessageChanged(EMMessage message, Object change) {
        this.refreshMessage(message);
    }

    private void refreshMessage(EMMessage message) {
        if (this.getChatMessageListLayout() != null) {
            this.getChatMessageListLayout().refreshMessage(message);
        }
    }

    private void refreshMessages(List<EMMessage> messages) {
        for (EMMessage msg : messages) {
            this.refreshMessage(msg);
        }
    }

    @Override
    public Context context() {
        return this.getContext();
    }

    @Override
    public void createThumbFileFail(String message) {
        if (this.listener != null) {
            this.listener.onChatError(-1, message);
        }
    }

    @Override
    public void addMsgAttrBeforeSend(EMMessage message) {
        if (this.sendMsgEvent != null) {
            this.sendMsgEvent.addMsgAttrsBeforeSend(message);
        }
    }

    @Override
    public void sendMessageFail(String message) {
        if (this.listener != null) {
            this.listener.onChatError(-1, message);
        }
    }

    @Override
    public void sendMessageFinish(EMMessage message) {
        if (this.getChatMessageListLayout() != null) {
            this.getChatMessageListLayout().refreshToLatest();
        }
    }

    @Override
    public void deleteLocalMessageSuccess(EMMessage message) {
        this.messageListLayout.removeMessage(message);
    }

    @Override
    public void recallMessageFinish(EMMessage message) {
        if (this.recallMessageListener != null) {
            this.recallMessageListener.recallSuccess(message);
        }
        this.messageListLayout.refreshMessages();
    }

    @Override
    public void recallMessageFail(int code, String message) {
        if (this.recallMessageListener != null) {
            this.recallMessageListener.recallFail(code, message);
        }
        if (this.listener != null) {
            this.listener.onChatError(code, message);
        }
    }

    @Override
    public void onPresenterMessageSuccess(EMMessage message) {
        EMLog.i((String)TAG, (String)"send message onPresenterMessageSuccess");
    }

    @Override
    public void onPresenterMessageError(EMMessage message, int code, String error) {
        EMLog.i((String)TAG, (String)("send message onPresenterMessageError code: " + code + " error: " + error));
        this.refreshMessage(message);
        if (this.listener != null) {
            this.listener.onChatError(code, error);
        }
    }

    @Override
    public void onPresenterMessageInProgress(EMMessage message, int progress) {
        EMLog.i((String)TAG, (String)"send message onPresenterMessageInProgress");
    }

    @Override
    public void onTouchItemOutside(View v, int position) {
        this.inputMenu.hideSoftKeyboard();
        this.inputMenu.showExtendMenu(false);
    }

    @Override
    public void onViewDragging() {
        this.inputMenu.hideSoftKeyboard();
        this.inputMenu.showExtendMenu(false);
    }

    @Override
    public boolean onBubbleClick(EMMessage message) {
        if (this.listener != null) {
            return this.listener.onBubbleClick(message);
        }
        return false;
    }

    @Override
    public boolean onResendClick(final EMMessage message) {
        EMLog.i((String)TAG, (String)"onResendClick");
        new EaseAlertDialog(this.getContext(), R.string.resend, R.string.confirm_resend, null, new EaseAlertDialog.AlertDialogUser(){

            @Override
            public void onResult(boolean confirmed, Bundle bundle) {
                if (!confirmed) {
                    return;
                }
                EaseChatLayout.this.resendMessage(message);
            }
        }, true).show();
        return true;
    }

    @Override
    public boolean onBubbleLongClick(View v, EMMessage message) {
        if (this.showDefaultMenu) {
            this.showDefaultMenu(v, message);
            if (this.listener != null) {
                return this.listener.onBubbleLongClick(v, message);
            }
            return true;
        }
        if (this.listener != null) {
            return this.listener.onBubbleLongClick(v, message);
        }
        return false;
    }

    @Override
    public void onUserAvatarClick(String username) {
        if (this.listener != null) {
            this.listener.onUserAvatarClick(username);
        }
    }

    @Override
    public void onUserAvatarLongClick(String username) {
        EMLog.i((String)TAG, (String)"onUserAvatarLongClick");
        this.inputAtUsername(username, true);
        if (this.listener != null) {
            this.listener.onUserAvatarLongClick(username);
        }
    }

    @Override
    public void onMessageCreate(EMMessage message) {
        EMLog.i((String)TAG, (String)"onMessageCreate");
    }

    @Override
    public void onMessageSuccess(EMMessage message) {
        EMLog.i((String)TAG, (String)"send message onMessageSuccess");
    }

    @Override
    public void onMessageError(EMMessage message, int code, String error) {
        if (this.listener != null) {
            this.listener.onChatError(code, error);
        }
    }

    @Override
    public void onMessageInProgress(EMMessage message, int progress) {
        EMLog.i((String)TAG, (String)("send message on progress: " + progress));
    }

    @Override
    public void onChatError(int code, String errorMsg) {
        if (this.listener != null) {
            this.listener.onChatError(code, errorMsg);
        }
    }

    @Override
    public void showItemDefaultMenu(boolean showDefault) {
        this.showDefaultMenu = showDefault;
    }

    @Override
    public void clearMenu() {
        this.menuHelper.clear();
    }

    @Override
    public void addItemMenu(MenuItemBean item) {
        this.menuHelper.addItemMenu(item);
    }

    @Override
    public void addItemMenu(int groupId, int itemId, int order, String title) {
        this.menuHelper.addItemMenu(groupId, itemId, order, title);
    }

    @Override
    public MenuItemBean findItem(int id2) {
        return this.menuHelper.findItem(id2);
    }

    @Override
    public void findItemVisible(int id2, boolean visible) {
        this.menuHelper.findItemVisible(id2, visible);
    }

    @Override
    public EasePopupWindowHelper getMenuHelper() {
        return this.menuHelper;
    }

    @Override
    public void setOnPopupWindowItemClickListener(OnMenuChangeListener listener) {
        this.menuChangeListener = listener;
    }

    public void inputAtUsername(String username, boolean autoAddAtSymbol) {
        if (EMClient.getInstance().getCurrentUser().equals(username) || !this.messageListLayout.isGroupChat()) {
            return;
        }
        EaseAtMessageHelper.get().addAtUser(username);
        EaseUser user = EaseUserUtils.getUserInfo(username);
        if (user != null) {
            username = user.getNickname();
        }
        EditText editText = this.inputMenu.getPrimaryMenu().getEditText();
        if (autoAddAtSymbol) {
            this.insertText(editText, AT_PREFIX + username + AT_SUFFIX);
        } else {
            this.insertText(editText, username + AT_SUFFIX);
        }
    }

    private void insertText(EditText edit, String text) {
        if (edit.isFocused()) {
            edit.getText().insert(edit.getSelectionStart(), (CharSequence)text);
        } else {
            edit.getText().insert(edit.getText().length() - 1, (CharSequence)text);
        }
    }

    private void showDefaultMenu(View v, final EMMessage message) {
        this.menuHelper.initMenu(this.getContext());
        this.menuHelper.setDefaultMenus();
        this.menuHelper.setOutsideTouchable(true);
        this.setMenuByMsgType(message);
        if (this.menuChangeListener != null) {
            this.menuChangeListener.onPreMenu(this.menuHelper, message);
        }
        this.menuHelper.setOnPopupMenuItemClickListener(new EasePopupWindow.OnPopupWindowItemClickListener(){

            @Override
            public boolean onMenuItemClick(MenuItemBean item) {
                if (EaseChatLayout.this.menuChangeListener != null && EaseChatLayout.this.menuChangeListener.onMenuItemClick(item, message)) {
                    return true;
                }
                if (EaseChatLayout.this.showDefaultMenu) {
                    int itemId = item.getItemId();
                    if (itemId == R.id.action_chat_copy) {
                        EaseChatLayout.this.clipboard.setPrimaryClip(ClipData.newPlainText(null, (CharSequence)((EMTextMessageBody)message.getBody()).getMessage()));
                        EMLog.i((String)TAG, (String)"copy success");
                    } else if (itemId == R.id.action_chat_delete) {
                        EaseChatLayout.this.deleteMessage(message);
                        EMLog.i((String)TAG, (String)("currentMsgId = " + message.getMsgId() + " timestamp = " + message.getMsgTime()));
                    } else if (itemId == R.id.action_chat_recall) {
                        EaseChatLayout.this.recallMessage(message);
                    }
                    return true;
                }
                return false;
            }
        });
        this.menuHelper.setOnPopupMenuDismissListener(new EasePopupWindow.OnPopupWindowDismissListener(){

            @Override
            public void onDismiss(PopupWindow menu) {
                if (EaseChatLayout.this.menuChangeListener != null) {
                    EaseChatLayout.this.menuChangeListener.onDismiss(menu);
                }
            }
        });
        this.menuHelper.show((View)this, v);
    }

    private void setMenuByMsgType(EMMessage message) {
        EMMessage.Type type = message.getType();
        this.menuHelper.findItemVisible(R.id.action_chat_copy, false);
        this.menuHelper.findItemVisible(R.id.action_chat_recall, false);
        this.menuHelper.findItem(R.id.action_chat_delete).setTitle(this.getContext().getString(R.string.action_delete));
        switch (type) {
            case TXT: {
                this.menuHelper.findItemVisible(R.id.action_chat_copy, true);
                this.menuHelper.findItemVisible(R.id.action_chat_recall, true);
                break;
            }
            case LOCATION: 
            case FILE: 
            case IMAGE: {
                this.menuHelper.findItemVisible(R.id.action_chat_recall, true);
                break;
            }
            case VOICE: {
                this.menuHelper.findItem(R.id.action_chat_delete).setTitle(this.getContext().getString(R.string.delete_voice));
                this.menuHelper.findItemVisible(R.id.action_chat_recall, true);
                break;
            }
            case VIDEO: {
                this.menuHelper.findItem(R.id.action_chat_delete).setTitle(this.getContext().getString(R.string.delete_video));
                this.menuHelper.findItemVisible(R.id.action_chat_recall, true);
            }
        }
        if (message.direct() == EMMessage.Direct.RECEIVE) {
            this.menuHelper.findItemVisible(R.id.action_chat_recall, false);
        }
    }

    private void finishCurrent() {
        if (this.getContext() instanceof Activity) {
            ((Activity)this.getContext()).finish();
        }
    }

    private class GroupListener
    extends EaseGroupListener {
        private GroupListener() {
        }

        @Override
        public void onUserRemoved(String groupId, String groupName) {
            EaseChatLayout.this.finishCurrent();
        }

        @Override
        public void onGroupDestroyed(String groupId, String groupName) {
            EaseChatLayout.this.finishCurrent();
        }
    }

    private class ChatRoomListener
    extends EaseChatRoomListener {
        private ChatRoomListener() {
        }

        @Override
        public void onChatRoomDestroyed(String roomId, String roomName) {
            EaseChatLayout.this.finishCurrent();
        }

        @Override
        public void onRemovedFromChatRoom(int reason, String roomId, String roomName, String participant) {
            if (!TextUtils.equals((CharSequence)roomId, (CharSequence)EaseChatLayout.this.conversationId)) {
                return;
            }
            if (reason == 0) {
                EaseChatLayout.this.finishCurrent();
            }
        }

        @Override
        public void onMemberJoined(String roomId, String participant) {
        }

        @Override
        public void onMemberExited(String roomId, String roomName, String participant) {
        }
    }
}

