/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.domain;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMUserInfo;
import com.hyphenate.util.HanziToPinyin;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EaseUser
implements Serializable {
    @NonNull
    private String username;
    private String nickname;
    private String initialLetter;
    private String avatar;
    private int contact;
    private long lastModifyTimestamp;
    private long modifyInitialLetterTimestamp;
    private String email;
    private String phone;
    private int gender;
    private String sign;
    private String birth;
    private String ext;

    @NonNull
    public String getUsername() {
        return this.username;
    }

    public void setUsername(@NonNull String username) {
        this.username = username;
        this.lastModifyTimestamp = System.currentTimeMillis();
        this.setLastModifyTimestamp(this.lastModifyTimestamp);
    }

    public String getNickname() {
        return TextUtils.isEmpty((CharSequence)this.nickname) ? this.username : this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
        this.lastModifyTimestamp = System.currentTimeMillis();
        this.setLastModifyTimestamp(this.lastModifyTimestamp);
    }

    public String getInitialLetter() {
        if (this.initialLetter == null || this.lastModifyTimestamp > this.modifyInitialLetterTimestamp) {
            if (!TextUtils.isEmpty((CharSequence)this.nickname)) {
                return this.getInitialLetter(this.nickname);
            }
            return this.getInitialLetter(this.username);
        }
        return this.initialLetter;
    }

    public void setInitialLetter(String initialLetter) {
        this.initialLetter = initialLetter;
        this.modifyInitialLetterTimestamp = System.currentTimeMillis();
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
        this.lastModifyTimestamp = System.currentTimeMillis();
        this.setLastModifyTimestamp(this.lastModifyTimestamp);
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
        this.lastModifyTimestamp = System.currentTimeMillis();
        this.setLastModifyTimestamp(this.lastModifyTimestamp);
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
        this.lastModifyTimestamp = System.currentTimeMillis();
        this.setLastModifyTimestamp(this.lastModifyTimestamp);
    }

    public int getGender() {
        return this.gender;
    }

    public void setGender(int gender) {
        this.gender = gender;
        this.lastModifyTimestamp = System.currentTimeMillis();
        this.setLastModifyTimestamp(this.lastModifyTimestamp);
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
        this.lastModifyTimestamp = System.currentTimeMillis();
        this.setLastModifyTimestamp(this.lastModifyTimestamp);
    }

    public String getBirth() {
        return this.birth;
    }

    public void setBirth(String birth) {
        this.birth = birth;
        this.lastModifyTimestamp = System.currentTimeMillis();
        this.setLastModifyTimestamp(this.lastModifyTimestamp);
    }

    public String getExt() {
        return this.ext;
    }

    public void setExt(String ext) {
        this.ext = ext;
        this.lastModifyTimestamp = System.currentTimeMillis();
        this.setLastModifyTimestamp(this.lastModifyTimestamp);
    }

    public int getContact() {
        return this.contact;
    }

    public void setContact(int contact) {
        this.contact = contact;
        this.lastModifyTimestamp = System.currentTimeMillis();
        this.setLastModifyTimestamp(this.lastModifyTimestamp);
    }

    public String getInitialLetter(String name) {
        return new GetInitialLetter().getLetter(name);
    }

    public long getLastModifyTimestamp() {
        return this.lastModifyTimestamp;
    }

    public void setLastModifyTimestamp(long modifyNicknameTimestamp) {
        this.lastModifyTimestamp = modifyNicknameTimestamp;
    }

    public long getModifyInitialLetterTimestamp() {
        return this.modifyInitialLetterTimestamp;
    }

    public void setModifyInitialLetterTimestamp(long modifyInitialLetterTimestamp) {
        this.modifyInitialLetterTimestamp = modifyInitialLetterTimestamp;
    }

    public EaseUser() {
    }

    public EaseUser(@NonNull String username) {
        this.username = username;
    }

    public String toString() {
        return "EaseUser{username='" + this.username + '\'' + ", nickname='" + this.nickname + '\'' + ", initialLetter='" + this.initialLetter + '\'' + ", avatar='" + this.avatar + '\'' + ", email='" + this.email + '\'' + ", phone='" + this.phone + '\'' + ", gender='" + this.gender + '\'' + ", sign='" + this.sign + '\'' + ", birth='" + this.birth + '\'' + ", ext='" + this.ext + '\'' + ", contact=" + this.contact + '}';
    }

    public static List<EaseUser> parse(List<String> ids) {
        ArrayList<EaseUser> users = new ArrayList<EaseUser>();
        if (ids == null || ids.isEmpty()) {
            return users;
        }
        for (String id2 : ids) {
            EaseUser user = new EaseUser(id2);
            users.add(user);
        }
        return users;
    }

    public static List<EaseUser> parse(String[] ids) {
        ArrayList<EaseUser> users = new ArrayList<EaseUser>();
        if (ids == null || ids.length == 0) {
            return users;
        }
        for (String id2 : ids) {
            EaseUser user = new EaseUser(id2);
            users.add(user);
        }
        return users;
    }

    public static List<EaseUser> parseUserInfo(Map<String, EMUserInfo> userInfos) {
        ArrayList<EaseUser> users = new ArrayList<EaseUser>();
        if (userInfos == null || userInfos.isEmpty()) {
            return users;
        }
        Set<String> userSet = userInfos.keySet();
        for (String userId : userSet) {
            EMUserInfo info = userInfos.get(userId);
            EaseUser user = new EaseUser(info.getUserId());
            user.setNickname(info.getNickName());
            user.setAvatar(info.getAvatarUrl());
            user.setEmail(info.getEmail());
            user.setGender(info.getGender());
            user.setBirth(info.getBirth());
            user.setSign(info.getSignature());
            user.setExt(info.getExt());
            if (info.getUserId().equals(EMClient.getInstance().getCurrentUser())) continue;
            users.add(user);
        }
        return users;
    }

    public class GetInitialLetter {
        private String defaultLetter = "#";

        public String getLetter(String name) {
            if (TextUtils.isEmpty((CharSequence)name)) {
                return this.defaultLetter;
            }
            char char0 = name.toLowerCase().charAt(0);
            if (Character.isDigit(char0)) {
                return this.defaultLetter;
            }
            ArrayList l = HanziToPinyin.getInstance().get(name.substring(0, 1));
            if (l != null && !l.isEmpty() && ((HanziToPinyin.Token)l.get((int)0)).target.length() > 0) {
                HanziToPinyin.Token token = (HanziToPinyin.Token)l.get(0);
                String letter = token.target.substring(0, 1).toUpperCase();
                char c = letter.charAt(0);
                if (c < 'A' || c > 'Z') {
                    return this.defaultLetter;
                }
                return letter;
            }
            return this.defaultLetter;
        }
    }
}

